
/* ---------------------------------------------------------------------- */
/* PREFS_PROPERTY_VALUE                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'PREFS_PROPERTY_VALUE')
BEGIN
     DECLARE @reftable_1 nvarchar(60), @constraintname_1 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'PREFS_PROPERTY_VALUE'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_1, @constraintname_1
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_1+' drop constraint '+@constraintname_1)
       FETCH NEXT from refcursor into @reftable_1, @constraintname_1
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE PREFS_PROPERTY_VALUE
END
;

CREATE TABLE PREFS_PROPERTY_VALUE
(
                    PROPERTY_VALUE_ID INT NOT NULL,
                    NODE_ID INT NULL,
                    PROPERTY_KEY_ID INT NULL,
                    BOOLEAN_VALUE BIT NULL,
                    DATETIME_VALUE DATETIME NULL,
                    LONG_VALUE INT NULL,
                    DOUBLE_VALUE FLOAT NULL,
                    TEXT_VALUE VARCHAR (254) NULL,
                    CREATION_DATE DATETIME NULL,
                    MODIFIED_DATE DATETIME NULL,

    CONSTRAINT PREFS_PROPERTY_VALUE_PK PRIMARY KEY(PROPERTY_VALUE_ID));





/* ---------------------------------------------------------------------- */
/* PREFS_NODE_PROPERTY_KEY                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'PREFS_NODE_PROPERTY_KEY')
BEGIN
     DECLARE @reftable_2 nvarchar(60), @constraintname_2 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'PREFS_NODE_PROPERTY_KEY'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_2, @constraintname_2
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_2+' drop constraint '+@constraintname_2)
       FETCH NEXT from refcursor into @reftable_2, @constraintname_2
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE PREFS_NODE_PROPERTY_KEY
END
;

CREATE TABLE PREFS_NODE_PROPERTY_KEY
(
                    NODE_ID INT NOT NULL,
                    PROPERTY_KEY_ID INT NOT NULL,

    CONSTRAINT PREFS_NODE_PROPERTY_KEY_PK PRIMARY KEY(NODE_ID,PROPERTY_KEY_ID));





/* ---------------------------------------------------------------------- */
/* PREFS_PROPERTY_KEY                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'PREFS_PROPERTY_KEY')
BEGIN
     DECLARE @reftable_3 nvarchar(60), @constraintname_3 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'PREFS_PROPERTY_KEY'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_3, @constraintname_3
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_3+' drop constraint '+@constraintname_3)
       FETCH NEXT from refcursor into @reftable_3, @constraintname_3
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE PREFS_PROPERTY_KEY
END
;

CREATE TABLE PREFS_PROPERTY_KEY
(
                    PROPERTY_KEY_ID INT NOT NULL,
                    PROPERTY_NAME VARCHAR (100) NULL,
                    PROPERTY_TYPE SMALLINT NULL,
                    CREATION_DATE DATETIME NULL,
                    MODIFIED_DATE DATETIME NULL,

    CONSTRAINT PREFS_PROPERTY_KEY_PK PRIMARY KEY(PROPERTY_KEY_ID));





/* ---------------------------------------------------------------------- */
/* PREFS_NODE                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type ='RI' AND name='PREFS_NODE_FK_1')
    ALTER TABLE PREFS_NODE DROP CONSTRAINT PREFS_NODE_FK_1;
IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'PREFS_NODE')
BEGIN
     DECLARE @reftable_4 nvarchar(60), @constraintname_4 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'PREFS_NODE'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_4, @constraintname_4
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_4+' drop constraint '+@constraintname_4)
       FETCH NEXT from refcursor into @reftable_4, @constraintname_4
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE PREFS_NODE
END
;

CREATE TABLE PREFS_NODE
(
                    NODE_ID INT NOT NULL,
                    PARENT_NODE_ID INT NULL,
                    NODE_NAME VARCHAR (100) NULL,
                    NODE_TYPE SMALLINT NULL,
                    FULL_PATH VARCHAR (254) NULL,
                    CREATION_DATE DATETIME NULL,
                    MODIFIED_DATE DATETIME NULL,

    CONSTRAINT PREFS_NODE_PK PRIMARY KEY(NODE_ID));





/* ---------------------------------------------------------------------- */
/* PREFS_NODE                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* PREFS_PROPERTY_VALUE                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* PREFS_NODE_PROPERTY_KEY                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* PREFS_PROPERTY_KEY                                                      */
/* ---------------------------------------------------------------------- */

BEGIN
ALTER TABLE PREFS_NODE
    ADD CONSTRAINT PREFS_NODE_FK_1 FOREIGN KEY (PARENT_NODE_ID)
    REFERENCES PREFS_NODE (NODE_ID)
END    
;



