
/* ---------------------------------------------------------------------- */
/* SUB_PAGES                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'SUB_PAGES')
BEGIN
     DECLARE @reftable_1 nvarchar(60), @constraintname_1 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'SUB_PAGES'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_1, @constraintname_1
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_1+' drop constraint '+@constraintname_1)
       FETCH NEXT from refcursor into @reftable_1, @constraintname_1
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE SUB_PAGES
END
;

CREATE TABLE SUB_PAGES
(
                    PAGE_ID VARCHAR (80) NOT NULL,
                    SUB_PAGE_ID VARCHAR (80) NOT NULL,
);

CREATE  INDEX IX_SUB_PAGES_1 ON SUB_PAGES (PAGE_ID, SUB_PAGE_ID);




/* ---------------------------------------------------------------------- */
/* PAGE                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'PAGE')
BEGIN
     DECLARE @reftable_2 nvarchar(60), @constraintname_2 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'PAGE'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_2, @constraintname_2
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_2+' drop constraint '+@constraintname_2)
       FETCH NEXT from refcursor into @reftable_2, @constraintname_2
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE PAGE
END
;

CREATE TABLE PAGE
(
                    PAGE_ID VARCHAR (80) NOT NULL,
                    TITLE VARCHAR (100) NULL,
                    DEFAULT_SKIN VARCHAR (100) NULL,
                    DEFAULT_DECORATOR VARCHAR (100) NULL,
                    DEFAULT_PORTLET_DECORATOR VARCHAR (100) NULL,
                    ACL VARCHAR (80) NULL,

    CONSTRAINT PAGE_PK PRIMARY KEY(PAGE_ID));





/* ---------------------------------------------------------------------- */
/* FRAGMENT                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'FRAGMENT')
BEGIN
     DECLARE @reftable_3 nvarchar(60), @constraintname_3 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'FRAGMENT'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_3, @constraintname_3
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_3+' drop constraint '+@constraintname_3)
       FETCH NEXT from refcursor into @reftable_3, @constraintname_3
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE FRAGMENT
END
;

CREATE TABLE FRAGMENT
(
                    FRAGMENT_ID VARCHAR (80) NOT NULL,
                    COMPONENT_NAME VARCHAR (100) NULL,
                    ACL VARCHAR (80) NULL,
                    TITLE VARCHAR (100) NULL,
                    TYPE VARCHAR (40) NULL,
                    SKIN VARCHAR (80) NULL,
                    DECORATOR VARCHAR (80) NULL,
                    STATE VARCHAR (40) NULL,

    CONSTRAINT FRAGMENT_PK PRIMARY KEY(FRAGMENT_ID));





/* ---------------------------------------------------------------------- */
/* PAGE_FRAGMENTS                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'PAGE_FRAGMENTS')
BEGIN
     DECLARE @reftable_4 nvarchar(60), @constraintname_4 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'PAGE_FRAGMENTS'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_4, @constraintname_4
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_4+' drop constraint '+@constraintname_4)
       FETCH NEXT from refcursor into @reftable_4, @constraintname_4
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE PAGE_FRAGMENTS
END
;

CREATE TABLE PAGE_FRAGMENTS
(
                    PAGE_ID VARCHAR (80) NOT NULL,
                    FRAGMENT_ID VARCHAR (80) NOT NULL,
);

CREATE  INDEX IX_PAGE_FRAGMENTS_1 ON PAGE_FRAGMENTS (PAGE_ID, FRAGMENT_ID);




/* ---------------------------------------------------------------------- */
/* SUB_FRAGMENTS                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'SUB_FRAGMENTS')
BEGIN
     DECLARE @reftable_5 nvarchar(60), @constraintname_5 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'SUB_FRAGMENTS'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_5, @constraintname_5
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_5+' drop constraint '+@constraintname_5)
       FETCH NEXT from refcursor into @reftable_5, @constraintname_5
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE SUB_FRAGMENTS
END
;

CREATE TABLE SUB_FRAGMENTS
(
                    FRAGMENT_ID VARCHAR (80) NOT NULL,
                    SUB_FRAGMENT_ID VARCHAR (80) NOT NULL,
);

CREATE  INDEX IX_SUB_FRAGMENTS_1 ON SUB_FRAGMENTS (FRAGMENT_ID, SUB_FRAGMENT_ID);




/* ---------------------------------------------------------------------- */
/* FRAGMENT_PARAMETER                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'FRAGMENT_PARAMETER')
BEGIN
     DECLARE @reftable_6 nvarchar(60), @constraintname_6 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'FRAGMENT_PARAMETER'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_6, @constraintname_6
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_6+' drop constraint '+@constraintname_6)
       FETCH NEXT from refcursor into @reftable_6, @constraintname_6
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE FRAGMENT_PARAMETER
END
;

CREATE TABLE FRAGMENT_PARAMETER
(
                    PARAMETER_ID INT NOT NULL,
                    FRAGMENT_ID INT NOT NULL,
                    NAME VARCHAR (80) NOT NULL,
                    VALUE TEXT NOT NULL,

    CONSTRAINT FRAGMENT_PARAMETER_PK PRIMARY KEY(PARAMETER_ID),
    UNIQUE (FRAGMENT_ID, PARAMETER_ID));





/* ---------------------------------------------------------------------- */
/* FRAGMENT_REF                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'FRAGMENT_REF')
BEGIN
     DECLARE @reftable_7 nvarchar(60), @constraintname_7 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'FRAGMENT_REF'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_7, @constraintname_7
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_7+' drop constraint '+@constraintname_7)
       FETCH NEXT from refcursor into @reftable_7, @constraintname_7
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE FRAGMENT_REF
END
;

CREATE TABLE FRAGMENT_REF
(
                    FRAGMENT_REF_ID VARCHAR (80) NOT NULL,
                    FRAGMENT_ID VARCHAR (80) NOT NULL,
                    NAME VARCHAR (80) NOT NULL,
                    TITLE VARCHAR (100) NULL,

    CONSTRAINT FRAGMENT_REF_PK PRIMARY KEY(FRAGMENT_REF_ID));





/* ---------------------------------------------------------------------- */
/* FRAGMENT_REFS                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'FRAGMENT_REFS')
BEGIN
     DECLARE @reftable_8 nvarchar(60), @constraintname_8 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'FRAGMENT_REFS'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_8, @constraintname_8
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_8+' drop constraint '+@constraintname_8)
       FETCH NEXT from refcursor into @reftable_8, @constraintname_8
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE FRAGMENT_REFS
END
;

CREATE TABLE FRAGMENT_REFS
(
                    FRAGMENT_REF_ID VARCHAR (80) NOT NULL,
                    FRAGMENT_ID VARCHAR (80) NOT NULL,
);





/* ---------------------------------------------------------------------- */
/* PROFILING_RULE                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'PROFILING_RULE')
BEGIN
     DECLARE @reftable_9 nvarchar(60), @constraintname_9 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'PROFILING_RULE'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_9, @constraintname_9
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_9+' drop constraint '+@constraintname_9)
       FETCH NEXT from refcursor into @reftable_9, @constraintname_9
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE PROFILING_RULE
END
;

CREATE TABLE PROFILING_RULE
(
                    RULE_ID VARCHAR (80) NOT NULL,
                    CLASS_NAME VARCHAR (100) NOT NULL,
                    TITLE VARCHAR (100) NULL,

    CONSTRAINT PROFILING_RULE_PK PRIMARY KEY(RULE_ID));





/* ---------------------------------------------------------------------- */
/* RULE_CRITERION                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type ='RI' AND name='RULE_CRITERION_FK_1')
    ALTER TABLE RULE_CRITERION DROP CONSTRAINT RULE_CRITERION_FK_1;
IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'RULE_CRITERION')
BEGIN
     DECLARE @reftable_10 nvarchar(60), @constraintname_10 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'RULE_CRITERION'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_10, @constraintname_10
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_10+' drop constraint '+@constraintname_10)
       FETCH NEXT from refcursor into @reftable_10, @constraintname_10
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE RULE_CRITERION
END
;

CREATE TABLE RULE_CRITERION
(
                    CRITERION_ID VARCHAR (80) NOT NULL,
                    RULE_ID VARCHAR (80) NOT NULL,
                    FALLBACK_ORDER INT NOT NULL,
                    REQUEST_TYPE VARCHAR (40) NOT NULL,
                    NAME VARCHAR (80) NOT NULL,
                    VALUE VARCHAR (128) NULL,
                    FALLBACK_TYPE INT default 1 NULL,

    CONSTRAINT RULE_CRITERION_PK PRIMARY KEY(CRITERION_ID));

CREATE  INDEX IX_RULE_CRITERION_1 ON RULE_CRITERION (RULE_ID, FALLBACK_ORDER);




/* ---------------------------------------------------------------------- */
/* PRINCIPAL_RULE_ASSOC                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'PRINCIPAL_RULE_ASSOC')
BEGIN
     DECLARE @reftable_11 nvarchar(60), @constraintname_11 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'PRINCIPAL_RULE_ASSOC'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_11, @constraintname_11
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_11+' drop constraint '+@constraintname_11)
       FETCH NEXT from refcursor into @reftable_11, @constraintname_11
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE PRINCIPAL_RULE_ASSOC
END
;

CREATE TABLE PRINCIPAL_RULE_ASSOC
(
                    PRINCIPAL_NAME VARCHAR (80) NOT NULL,
                    LOCATOR_NAME VARCHAR (80) NOT NULL,
                    RULE_ID VARCHAR (80) NOT NULL,

    CONSTRAINT PRINCIPAL_RULE_ASSOC_PK PRIMARY KEY(PRINCIPAL_NAME,LOCATOR_NAME));





/* ---------------------------------------------------------------------- */
/* PROFILE_PAGE_ASSOC                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'PROFILE_PAGE_ASSOC')
BEGIN
     DECLARE @reftable_12 nvarchar(60), @constraintname_12 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'PROFILE_PAGE_ASSOC'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_12, @constraintname_12
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_12+' drop constraint '+@constraintname_12)
       FETCH NEXT from refcursor into @reftable_12, @constraintname_12
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE PROFILE_PAGE_ASSOC
END
;

CREATE TABLE PROFILE_PAGE_ASSOC
(
                    LOCATOR_HASH VARCHAR (40) NOT NULL,
                    PAGE_ID VARCHAR (80) NOT NULL,

    UNIQUE (LOCATOR_HASH, PAGE_ID));





/* ---------------------------------------------------------------------- */
/* CLUBS                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'CLUBS')
BEGIN
     DECLARE @reftable_13 nvarchar(60), @constraintname_13 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'CLUBS'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_13, @constraintname_13
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_13+' drop constraint '+@constraintname_13)
       FETCH NEXT from refcursor into @reftable_13, @constraintname_13
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE CLUBS
END
;

CREATE TABLE CLUBS
(
                    NAME VARCHAR (80) NOT NULL,
                    COUNTRY VARCHAR (40) NOT NULL,
                    CITY VARCHAR (40) NOT NULL,
                    STADIUM VARCHAR (80) NOT NULL,
                    CAPACITY INT NULL,
                    FOUNDED INT NULL,
                    PITCH VARCHAR (40) NULL,
                    NICKNAME VARCHAR (40) NULL,

    CONSTRAINT CLUBS_PK PRIMARY KEY(NAME));





/* ---------------------------------------------------------------------- */
/* CLUBS                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* SUB_PAGES                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* PAGE                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* FRAGMENT                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* PAGE_FRAGMENTS                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* SUB_FRAGMENTS                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* FRAGMENT_PARAMETER                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* FRAGMENT_REF                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* FRAGMENT_REFS                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* PROFILING_RULE                                                      */
/* ---------------------------------------------------------------------- */

BEGIN
ALTER TABLE RULE_CRITERION
    ADD CONSTRAINT RULE_CRITERION_FK_1 FOREIGN KEY (RULE_ID)
    REFERENCES PROFILING_RULE (RULE_ID)
    ON DELETE CASCADE 
END    
;




/* ---------------------------------------------------------------------- */
/* RULE_CRITERION                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* PRINCIPAL_RULE_ASSOC                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* PROFILE_PAGE_ASSOC                                                      */
/* ---------------------------------------------------------------------- */



