
/* ---------------------------------------------------------------------- */
/* MEDIA_TYPE                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'MEDIA_TYPE')
BEGIN
     DECLARE @reftable_1 nvarchar(60), @constraintname_1 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'MEDIA_TYPE'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_1, @constraintname_1
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_1+' drop constraint '+@constraintname_1)
       FETCH NEXT from refcursor into @reftable_1, @constraintname_1
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE MEDIA_TYPE
END
;

CREATE TABLE MEDIA_TYPE
(
                    MEDIATYPE_ID INT NOT NULL,
                    NAME VARCHAR (80) NOT NULL,
                    CHARACTER_SET VARCHAR (40) NULL,
                    TITLE VARCHAR (80) NULL,
                    DESCRIPTION TEXT NULL,

    CONSTRAINT MEDIA_TYPE_PK PRIMARY KEY(MEDIATYPE_ID));





/* ---------------------------------------------------------------------- */
/* CLIENT                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'CLIENT')
BEGIN
     DECLARE @reftable_2 nvarchar(60), @constraintname_2 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'CLIENT'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_2, @constraintname_2
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_2+' drop constraint '+@constraintname_2)
       FETCH NEXT from refcursor into @reftable_2, @constraintname_2
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE CLIENT
END
;

CREATE TABLE CLIENT
(
                    CLIENT_ID INT NOT NULL,
                    NAME VARCHAR (80) NOT NULL,
                    USER_AGENT_PATTERN VARCHAR (128) NULL,
                    MANUFACTURER VARCHAR (80) NULL,
                    MODEL VARCHAR (80) NULL,
                    VERSION VARCHAR (40) NULL,
                    PREFERRED_MIMETYPE_ID INT NOT NULL,

    CONSTRAINT CLIENT_PK PRIMARY KEY(CLIENT_ID));





/* ---------------------------------------------------------------------- */
/* MIMETYPE                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'MIMETYPE')
BEGIN
     DECLARE @reftable_3 nvarchar(60), @constraintname_3 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'MIMETYPE'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_3, @constraintname_3
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_3+' drop constraint '+@constraintname_3)
       FETCH NEXT from refcursor into @reftable_3, @constraintname_3
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE MIMETYPE
END
;

CREATE TABLE MIMETYPE
(
                    MIMETYPE_ID INT NOT NULL,
                    NAME VARCHAR (80) NOT NULL,

    CONSTRAINT MIMETYPE_PK PRIMARY KEY(MIMETYPE_ID));





/* ---------------------------------------------------------------------- */
/* CAPABILITY                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'CAPABILITY')
BEGIN
     DECLARE @reftable_4 nvarchar(60), @constraintname_4 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'CAPABILITY'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_4, @constraintname_4
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_4+' drop constraint '+@constraintname_4)
       FETCH NEXT from refcursor into @reftable_4, @constraintname_4
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE CAPABILITY
END
;

CREATE TABLE CAPABILITY
(
                    CAPABILITY_ID INT NOT NULL,
                    CAPABILITY VARCHAR (80) NOT NULL,

    CONSTRAINT CAPABILITY_PK PRIMARY KEY(CAPABILITY_ID));





/* ---------------------------------------------------------------------- */
/* CLIENT_TO_CAPABILITY                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'CLIENT_TO_CAPABILITY')
BEGIN
     DECLARE @reftable_5 nvarchar(60), @constraintname_5 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'CLIENT_TO_CAPABILITY'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_5, @constraintname_5
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_5+' drop constraint '+@constraintname_5)
       FETCH NEXT from refcursor into @reftable_5, @constraintname_5
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE CLIENT_TO_CAPABILITY
END
;

CREATE TABLE CLIENT_TO_CAPABILITY
(
                    CLIENT_ID INT NOT NULL,
                    CAPABILITY_ID INT NOT NULL,
);





/* ---------------------------------------------------------------------- */
/* CLIENT_TO_MIMETYPE                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'CLIENT_TO_MIMETYPE')
BEGIN
     DECLARE @reftable_6 nvarchar(60), @constraintname_6 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'CLIENT_TO_MIMETYPE'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_6, @constraintname_6
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_6+' drop constraint '+@constraintname_6)
       FETCH NEXT from refcursor into @reftable_6, @constraintname_6
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE CLIENT_TO_MIMETYPE
END
;

CREATE TABLE CLIENT_TO_MIMETYPE
(
                    CLIENT_ID INT NOT NULL,
                    MIMETYPE_ID INT NOT NULL,
);





/* ---------------------------------------------------------------------- */
/* MEDIATYPE_TO_CAPABILITY                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'MEDIATYPE_TO_CAPABILITY')
BEGIN
     DECLARE @reftable_7 nvarchar(60), @constraintname_7 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'MEDIATYPE_TO_CAPABILITY'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_7, @constraintname_7
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_7+' drop constraint '+@constraintname_7)
       FETCH NEXT from refcursor into @reftable_7, @constraintname_7
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE MEDIATYPE_TO_CAPABILITY
END
;

CREATE TABLE MEDIATYPE_TO_CAPABILITY
(
                    MEDIATYPE_ID INT NOT NULL,
                    CAPABILITY_ID INT NOT NULL,
);





/* ---------------------------------------------------------------------- */
/* MEDIATYPE_TO_MIMETYPE                                                      */
/* ---------------------------------------------------------------------- */

IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'MEDIATYPE_TO_MIMETYPE')
BEGIN
     DECLARE @reftable_8 nvarchar(60), @constraintname_8 nvarchar(60)
     DECLARE refcursor CURSOR FOR
     select reftables.name tablename, cons.name constraintname
      from sysobjects tables,
           sysobjects reftables,
           sysobjects cons,
           sysreferences ref
       where tables.id = ref.rkeyid
         and cons.id = ref.constid
         and reftables.id = ref.fkeyid
         and tables.name = 'MEDIATYPE_TO_MIMETYPE'
     OPEN refcursor
     FETCH NEXT from refcursor into @reftable_8, @constraintname_8
     while @@FETCH_STATUS = 0
     BEGIN
       exec ('alter table '+@reftable_8+' drop constraint '+@constraintname_8)
       FETCH NEXT from refcursor into @reftable_8, @constraintname_8
     END
     CLOSE refcursor
     DEALLOCATE refcursor
     DROP TABLE MEDIATYPE_TO_MIMETYPE
END
;

CREATE TABLE MEDIATYPE_TO_MIMETYPE
(
                    MEDIATYPE_ID INT NOT NULL,
                    MIMETYPE_ID INT NOT NULL,
);





/* ---------------------------------------------------------------------- */
/* MEDIATYPE_TO_MIMETYPE                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* MEDIA_TYPE                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* CLIENT                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* MIMETYPE                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* CAPABILITY                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* CLIENT_TO_CAPABILITY                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* CLIENT_TO_MIMETYPE                                                      */
/* ---------------------------------------------------------------------- */




/* ---------------------------------------------------------------------- */
/* MEDIATYPE_TO_CAPABILITY                                                      */
/* ---------------------------------------------------------------------- */



