
-----------------------------------------------------------------------------
-- SECURITY_PRINCIPAL
-----------------------------------------------------------------------------
drop table SECURITY_PRINCIPAL if exists;

CREATE TABLE SECURITY_PRINCIPAL
(
            PRINCIPAL_ID integer,
            CLASSNAME VARCHAR (254),
            IS_MAPPING_ONLY BIT,
            IS_ENABLED BIT,
            FULL_PATH VARCHAR (254),
            CREATION_DATE timestamp,
            MODIFIED_DATE timestamp,
    PRIMARY KEY(PRINCIPAL_ID),
    UNIQUE (FULL_PATH)
);


-----------------------------------------------------------------------------
-- SECURITY_PERMISSION
-----------------------------------------------------------------------------
drop table SECURITY_PERMISSION if exists;

CREATE TABLE SECURITY_PERMISSION
(
            PERMISSION_ID integer,
            CLASSNAME VARCHAR (254),
            NAME VARCHAR (254),
            ACTIONS VARCHAR (254),
            CREATION_DATE timestamp,
            MODIFIED_DATE timestamp,
    PRIMARY KEY(PERMISSION_ID)
);


-----------------------------------------------------------------------------
-- PRINCIPAL_PERMISSION
-----------------------------------------------------------------------------
drop table PRINCIPAL_PERMISSION if exists;

CREATE TABLE PRINCIPAL_PERMISSION
(
            PRINCIPAL_ID integer,
            PERMISSION_ID integer,
    PRIMARY KEY(PRINCIPAL_ID,PERMISSION_ID)
);


-----------------------------------------------------------------------------
-- SECURITY_CREDENTIAL
-----------------------------------------------------------------------------
drop table SECURITY_CREDENTIAL if exists;

CREATE TABLE SECURITY_CREDENTIAL
(
            CREDENTIAL_ID integer,
            PRINCIPAL_ID integer,
            VALUE VARCHAR (254),
            TYPE SMALLINT,
            CLASSNAME VARCHAR (254),
            UPDATE_REQUIRED BIT,
            IS_ENCODED BIT,
            IS_ENABLED BIT,
            AUTH_FAILURES SMALLINT,
            IS_EXPIRED BIT,
            CREATION_DATE timestamp,
            MODIFIED_DATE timestamp,
            PREV_AUTH_DATE timestamp,
            LAST_AUTH_DATE timestamp,
            EXPIRATION_DATE date,
    PRIMARY KEY(CREDENTIAL_ID)
);


-----------------------------------------------------------------------------
-- SSO_SITE
-----------------------------------------------------------------------------
drop table SSO_SITE if exists;

CREATE TABLE SSO_SITE
(
            SITE_ID integer,
            NAME VARCHAR (254),
            URL VARCHAR (254),
            ALLOW_USER_SET BIT,
            REQUIRES_CERTIFICATE BIT,
    PRIMARY KEY(SITE_ID),
    UNIQUE (URL)
);


-----------------------------------------------------------------------------
-- SSO_SITE_TO_PRINCIPALS
-----------------------------------------------------------------------------
drop table SSO_SITE_TO_PRINCIPALS if exists;

CREATE TABLE SSO_SITE_TO_PRINCIPALS
(
            SITE_ID integer,
            PRINCIPAL_ID integer,
    PRIMARY KEY(SITE_ID,PRINCIPAL_ID)
);


-----------------------------------------------------------------------------
-- SSO_PRINCIPAL_TO_REMOTE
-----------------------------------------------------------------------------
drop table SSO_PRINCIPAL_TO_REMOTE if exists;

CREATE TABLE SSO_PRINCIPAL_TO_REMOTE
(
            PRINCIPAL_ID integer,
            REMOTE_PRINCIPAL_ID integer,
    PRIMARY KEY(PRINCIPAL_ID,REMOTE_PRINCIPAL_ID)
);


-----------------------------------------------------------------------------
-- SSO_SITE_TO_REMOTE
-----------------------------------------------------------------------------
drop table SSO_SITE_TO_REMOTE if exists;

CREATE TABLE SSO_SITE_TO_REMOTE
(
            SITE_ID integer,
            PRINCIPAL_ID integer,
    PRIMARY KEY(SITE_ID,PRINCIPAL_ID)
);


-----------------------------------------------------------------------------
-- SECURITY_USER_ROLE
-----------------------------------------------------------------------------
drop table SECURITY_USER_ROLE if exists;

CREATE TABLE SECURITY_USER_ROLE
(
            USER_ID integer,
            ROLE_ID integer,
    PRIMARY KEY(USER_ID,ROLE_ID)
);


-----------------------------------------------------------------------------
-- SECURITY_USER_GROUP
-----------------------------------------------------------------------------
drop table SECURITY_USER_GROUP if exists;

CREATE TABLE SECURITY_USER_GROUP
(
            USER_ID integer,
            GROUP_ID integer,
    PRIMARY KEY(USER_ID,GROUP_ID)
);


-----------------------------------------------------------------------------
-- SECURITY_GROUP_ROLE
-----------------------------------------------------------------------------
drop table SECURITY_GROUP_ROLE if exists;

CREATE TABLE SECURITY_GROUP_ROLE
(
            GROUP_ID integer,
            ROLE_ID integer,
    PRIMARY KEY(GROUP_ID,ROLE_ID)
);





    ALTER TABLE PRINCIPAL_PERMISSION
        ADD CONSTRAINT PRINCIPAL_PERMISSION_FK_1 FOREIGN KEY (PERMISSION_ID)
            REFERENCES SECURITY_PERMISSION (PERMISSION_ID);
    ALTER TABLE PRINCIPAL_PERMISSION
        ADD CONSTRAINT PRINCIPAL_PERMISSION_FK_2 FOREIGN KEY (PRINCIPAL_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID);


    ALTER TABLE SECURITY_CREDENTIAL
        ADD CONSTRAINT SECURITY_CREDENTIAL_FK_1 FOREIGN KEY (PRINCIPAL_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID);




    ALTER TABLE SSO_SITE_TO_PRINCIPALS
        ADD CONSTRAINT SSO_SITE_TO_PRINCIPALS_FK_1 FOREIGN KEY (SITE_ID)
            REFERENCES SSO_SITE (SITE_ID);
    ALTER TABLE SSO_SITE_TO_PRINCIPALS
        ADD CONSTRAINT SSO_SITE_TO_PRINCIPALS_FK_2 FOREIGN KEY (PRINCIPAL_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID);


    ALTER TABLE SSO_PRINCIPAL_TO_REMOTE
        ADD CONSTRAINT SSO_PRINCIPAL_TO_REMOTE_FK_1 FOREIGN KEY (PRINCIPAL_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID);
    ALTER TABLE SSO_PRINCIPAL_TO_REMOTE
        ADD CONSTRAINT SSO_PRINCIPAL_TO_REMOTE_FK_2 FOREIGN KEY (REMOTE_PRINCIPAL_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID);


    ALTER TABLE SSO_SITE_TO_REMOTE
        ADD CONSTRAINT SSO_SITE_TO_REMOTE_FK_1 FOREIGN KEY (SITE_ID)
            REFERENCES SSO_SITE (SITE_ID);
    ALTER TABLE SSO_SITE_TO_REMOTE
        ADD CONSTRAINT SSO_SITE_TO_REMOTE_FK_2 FOREIGN KEY (PRINCIPAL_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID);


    ALTER TABLE SECURITY_USER_ROLE
        ADD CONSTRAINT SECURITY_USER_ROLE_FK_1 FOREIGN KEY (ROLE_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID);
    ALTER TABLE SECURITY_USER_ROLE
        ADD CONSTRAINT SECURITY_USER_ROLE_FK_2 FOREIGN KEY (USER_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID);


    ALTER TABLE SECURITY_USER_GROUP
        ADD CONSTRAINT SECURITY_USER_GROUP_FK_1 FOREIGN KEY (GROUP_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID);
    ALTER TABLE SECURITY_USER_GROUP
        ADD CONSTRAINT SECURITY_USER_GROUP_FK_2 FOREIGN KEY (USER_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID);


    ALTER TABLE SECURITY_GROUP_ROLE
        ADD CONSTRAINT SECURITY_GROUP_ROLE_FK_1 FOREIGN KEY (GROUP_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID);
    ALTER TABLE SECURITY_GROUP_ROLE
        ADD CONSTRAINT SECURITY_GROUP_ROLE_FK_2 FOREIGN KEY (ROLE_ID)
            REFERENCES SECURITY_PRINCIPAL (PRINCIPAL_ID);


