
-----------------------------------------------------------------------------
-- PREFS_PROPERTY_VALUE
-----------------------------------------------------------------------------
drop table PREFS_PROPERTY_VALUE if exists;

CREATE TABLE PREFS_PROPERTY_VALUE
(
            PROPERTY_VALUE_ID integer,
            NODE_ID integer,
            PROPERTY_KEY_ID integer,
            BOOLEAN_VALUE BIT,
            DATETIME_VALUE timestamp,
            LONG_VALUE integer,
            DOUBLE_VALUE DOUBLE,
            TEXT_VALUE VARCHAR (254),
            CREATION_DATE timestamp,
            MODIFIED_DATE timestamp,
    PRIMARY KEY(PROPERTY_VALUE_ID)
);


-----------------------------------------------------------------------------
-- PREFS_NODE_PROPERTY_KEY
-----------------------------------------------------------------------------
drop table PREFS_NODE_PROPERTY_KEY if exists;

CREATE TABLE PREFS_NODE_PROPERTY_KEY
(
            NODE_ID integer,
            PROPERTY_KEY_ID integer,
    PRIMARY KEY(NODE_ID,PROPERTY_KEY_ID)
);


-----------------------------------------------------------------------------
-- PREFS_PROPERTY_KEY
-----------------------------------------------------------------------------
drop table PREFS_PROPERTY_KEY if exists;

CREATE TABLE PREFS_PROPERTY_KEY
(
            PROPERTY_KEY_ID integer,
            PROPERTY_NAME VARCHAR (100),
            PROPERTY_TYPE SMALLINT,
            CREATION_DATE timestamp,
            MODIFIED_DATE timestamp,
    PRIMARY KEY(PROPERTY_KEY_ID)
);


-----------------------------------------------------------------------------
-- PREFS_NODE
-----------------------------------------------------------------------------
drop table PREFS_NODE if exists;

CREATE TABLE PREFS_NODE
(
            NODE_ID integer,
            PARENT_NODE_ID integer,
            NODE_NAME VARCHAR (100),
            NODE_TYPE SMALLINT,
            FULL_PATH VARCHAR (254),
            CREATION_DATE timestamp,
            MODIFIED_DATE timestamp,
    PRIMARY KEY(NODE_ID)
);







    ALTER TABLE PREFS_NODE
        ADD CONSTRAINT PREFS_NODE_FK_1 FOREIGN KEY (PARENT_NODE_ID)
            REFERENCES PREFS_NODE (NODE_ID);


