
-----------------------------------------------------------------------------
-- MEDIA_TYPE
-----------------------------------------------------------------------------
drop table MEDIA_TYPE if exists;

CREATE TABLE MEDIA_TYPE
(
            MEDIATYPE_ID integer,
            NAME VARCHAR (80),
            CHARACTER_SET VARCHAR (40),
            TITLE VARCHAR (80),
            DESCRIPTION VARCHAR,
    PRIMARY KEY(MEDIATYPE_ID)
);


-----------------------------------------------------------------------------
-- CLIENT
-----------------------------------------------------------------------------
drop table CLIENT if exists;

CREATE TABLE CLIENT
(
            CLIENT_ID integer,
            NAME VARCHAR (80),
            USER_AGENT_PATTERN VARCHAR (128),
            MANUFACTURER VARCHAR (80),
            MODEL VARCHAR (80),
            VERSION VARCHAR (40),
            PREFERRED_MIMETYPE_ID integer,
    PRIMARY KEY(CLIENT_ID)
);


-----------------------------------------------------------------------------
-- MIMETYPE
-----------------------------------------------------------------------------
drop table MIMETYPE if exists;

CREATE TABLE MIMETYPE
(
            MIMETYPE_ID integer,
            NAME VARCHAR (80),
    PRIMARY KEY(MIMETYPE_ID)
);


-----------------------------------------------------------------------------
-- CAPABILITY
-----------------------------------------------------------------------------
drop table CAPABILITY if exists;

CREATE TABLE CAPABILITY
(
            CAPABILITY_ID integer,
            CAPABILITY VARCHAR (80),
    PRIMARY KEY(CAPABILITY_ID)
);


-----------------------------------------------------------------------------
-- CLIENT_TO_CAPABILITY
-----------------------------------------------------------------------------
drop table CLIENT_TO_CAPABILITY if exists;

CREATE TABLE CLIENT_TO_CAPABILITY
(
            CLIENT_ID integer,
            CAPABILITY_ID integer
);


-----------------------------------------------------------------------------
-- CLIENT_TO_MIMETYPE
-----------------------------------------------------------------------------
drop table CLIENT_TO_MIMETYPE if exists;

CREATE TABLE CLIENT_TO_MIMETYPE
(
            CLIENT_ID integer,
            MIMETYPE_ID integer
);


-----------------------------------------------------------------------------
-- MEDIATYPE_TO_CAPABILITY
-----------------------------------------------------------------------------
drop table MEDIATYPE_TO_CAPABILITY if exists;

CREATE TABLE MEDIATYPE_TO_CAPABILITY
(
            MEDIATYPE_ID integer,
            CAPABILITY_ID integer
);


-----------------------------------------------------------------------------
-- MEDIATYPE_TO_MIMETYPE
-----------------------------------------------------------------------------
drop table MEDIATYPE_TO_MIMETYPE if exists;

CREATE TABLE MEDIATYPE_TO_MIMETYPE
(
            MEDIATYPE_ID integer,
            MIMETYPE_ID integer
);

















