/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.impl.ldap.AbstractLdapDao;
import org.apache.jetspeed.security.spi.impl.ldap.LdapUserCredentialDao;

public class LdapUserCredentialDaoImpl
extends AbstractLdapDao
implements LdapUserCredentialDao {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$jetspeed$security$spi$impl$ldap$LdapUserCredentialDaoImpl == null ? (class$org$apache$jetspeed$security$spi$impl$ldap$LdapUserCredentialDaoImpl = LdapUserCredentialDaoImpl.class$("org.apache.jetspeed.security.spi.impl.ldap.LdapUserCredentialDaoImpl")) : class$org$apache$jetspeed$security$spi$impl$ldap$LdapUserCredentialDaoImpl));
    private static final String PASSWORD_ATTR_NAME = "userPassword";
    static /* synthetic */ Class class$org$apache$jetspeed$security$spi$impl$ldap$LdapUserCredentialDaoImpl;

    public LdapUserCredentialDaoImpl() throws NamingException, SecurityException {
    }

    public LdapUserCredentialDaoImpl(String ldapServerName, String rootDn, String rootPassword, String rootContext, String defaultDnSuffix) throws NamingException, SecurityException {
        super(ldapServerName, rootDn, rootPassword, rootContext, defaultDnSuffix);
    }

    public void changePassword(String uid, String password) throws SecurityException {
        this.validateUid(uid);
        this.validatePassword(password);
        String userDn = this.lookupByUid(uid);
        try {
            this.setPassword(userDn, password);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    public boolean authenticate(String uid, String password) throws SecurityException {
        this.validateUid(uid);
        this.validatePassword(password);
        String savedPassword = String.valueOf(this.getPassword(uid));
        return savedPassword.equals(password);
    }

    public char[] getPassword(String uid) throws SecurityException {
        this.validateUid(uid);
        try {
            SearchControls cons = this.setSearchControls();
            NamingEnumeration results = this.searchByWildcardedUid(uid, cons);
            return this.getPassword(results, uid);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    private void setPassword(String userDn, String password) throws NamingException {
        String rdn = this.getSubcontextName(userDn);
        BasicAttributes attrs = new BasicAttributes(false);
        attrs.put(PASSWORD_ATTR_NAME, password);
        this.ctx.modifyAttributes(rdn, 2, (Attributes)attrs);
    }

    private char[] getPassword(NamingEnumeration results, String uid) throws NamingException {
        if (!results.hasMore()) {
            throw new NamingException("Could not find any user with uid[" + uid + "]");
        }
        Attributes userAttributes = this.getFirstUser(results);
        return this.convertRawPassword(this.getAttribute(PASSWORD_ATTR_NAME, userAttributes));
    }

    private Attribute getAttribute(String attributeName, Attributes userAttributes) throws NamingException {
        NamingEnumeration<? extends Attribute> ae = userAttributes.getAll();
        while (ae.hasMore()) {
            Attribute attr = ae.next();
            if (!attr.getID().equals(attributeName)) continue;
            return attr;
        }
        return null;
    }

    private char[] convertRawPassword(Attribute attr) throws NamingException {
        byte[] rawPass = (byte[])attr.getAll().next();
        char[] charPass = new char[rawPass.length];
        for (int i = 0; i < rawPass.length; ++i) {
            LOG.debug((Object)new String("password byte[" + i + "]:" + rawPass[i]));
            Byte passByte = new Byte(rawPass[i]);
            LOG.debug((Object)("password byte[" + i + "] short value:" + passByte.shortValue()));
            charPass[i] = (char)rawPass[i];
            LOG.debug((Object)("passchar char[" + i + "]:" + charPass[i]));
        }
        return charPass;
    }

    private Attributes getFirstUser(NamingEnumeration results) throws NamingException {
        SearchResult result = (SearchResult)results.next();
        Attributes answer = result.getAttributes();
        return answer;
    }

    protected String getObjectClass() {
        return "jetspeed-2-user";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

