/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.impl.ldap.AbstractLdapDao;
import org.apache.jetspeed.security.spi.impl.ldap.LdapPrincipalDao;

public abstract class LdapPrincipalDaoImpl
extends AbstractLdapDao
implements LdapPrincipalDao {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$jetspeed$security$spi$impl$ldap$LdapPrincipalDaoImpl == null ? (class$org$apache$jetspeed$security$spi$impl$ldap$LdapPrincipalDaoImpl = LdapPrincipalDaoImpl.class$("org.apache.jetspeed.security.spi.impl.ldap.LdapPrincipalDaoImpl")) : class$org$apache$jetspeed$security$spi$impl$ldap$LdapPrincipalDaoImpl));
    protected static final String UID_ATTR_NAME = "uid";
    static /* synthetic */ Class class$org$apache$jetspeed$security$spi$impl$ldap$LdapPrincipalDaoImpl;

    public LdapPrincipalDaoImpl() throws NamingException, SecurityException {
    }

    public LdapPrincipalDaoImpl(String ldapServerName, String rootDn, String rootPassword, String rootContext, String defaultDnSuffix) throws NamingException, SecurityException {
        super(ldapServerName, rootDn, rootPassword, rootContext, defaultDnSuffix);
    }

    protected abstract Principal makePrincipal(String var1);

    protected abstract Attributes defineLdapAttributes(String var1);

    public void create(String principalUid) throws SecurityException {
        Attributes attrs = this.defineLdapAttributes(principalUid);
        try {
            this.ctx.createSubcontext("uid=" + principalUid + this.defaultDnSuffix, attrs);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    public void delete(String principalUid) throws SecurityException {
        String dn = this.lookupByUid(principalUid);
        if (dn == null) {
            return;
        }
        try {
            String rdn = this.getSubcontextName(dn);
            this.ctx.destroySubcontext(rdn);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    protected String convertUidToLdapAcceptableName(String uid) {
        return uid.replaceAll("/", "&");
    }

    protected String convertUidFromLdapAcceptableName(String uid) {
        return uid.replaceAll("&", "/");
    }

    public Principal[] find(String principalUid) throws SecurityException {
        try {
            SearchControls cons = this.setSearchControls();
            NamingEnumeration searchResults = this.searchByWildcardedUid(this.convertUidToLdapAcceptableName(principalUid), cons);
            ArrayList principals = new ArrayList();
            this.enumerateOverSearchResults(searchResults, principals);
            return this.convertPrincipalListToArray(principals);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    private Principal[] convertPrincipalListToArray(Collection principals) {
        return principals.toArray(new Principal[principals.size()]);
    }

    private void enumerateOverSearchResults(NamingEnumeration searchResults, Collection principals) throws NamingException {
        while (searchResults.hasMore()) {
            SearchResult searchResult = (SearchResult)searchResults.next();
            this.buildPrincipal(principals, searchResult);
        }
    }

    private void buildPrincipal(Collection principals, SearchResult searchResult) throws NamingException {
        if (searchResult.getObject() instanceof DirContext) {
            Attributes atts = searchResult.getAttributes();
            String uid = (String)this.getAttribute(UID_ATTR_NAME, atts).getAll().next();
            Principal principal = this.makePrincipal(uid);
            principals.add(principal);
        }
    }

    protected Attribute getAttribute(String attributeName, Attributes userAttributes) throws NamingException {
        NamingEnumeration<? extends Attribute> ae = userAttributes.getAll();
        while (ae.hasMore()) {
            Attribute attr = ae.next();
            if (!attr.getID().equals(attributeName)) continue;
            return attr;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

