/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import java.util.Properties;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.SecurityException;

public abstract class AbstractLdapDao {
    private String ldapServerName = null;
    protected String rootDn = null;
    protected String rootPassword = null;
    protected String rootContext = null;
    protected String defaultDnSuffix = null;
    protected LdapContext ctx;

    public AbstractLdapDao() {
    }

    public AbstractLdapDao(String ldapServerName, String rootDn, String rootPassword, String rootContext, String defaultDnSuffix) throws SecurityException, NamingException {
        this.ldapServerName = ldapServerName;
        this.rootDn = rootDn;
        this.rootPassword = rootPassword;
        this.rootContext = rootContext;
        this.defaultDnSuffix = defaultDnSuffix;
        this.bindToServer(rootDn, rootPassword);
    }

    protected void bindToServer(String rootDn, String rootPassword) throws SecurityException, NamingException {
        this.validateDn(rootDn);
        this.validatePassword(rootPassword);
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + this.ldapServerName + "/" + this.rootContext);
        env.put("java.naming.security.principal", rootDn);
        env.put("java.naming.security.credentials", rootPassword);
        env.put("java.naming.security.authentication", "simple");
        this.ctx = new InitialLdapContext(env, null);
    }

    protected String getSubcontextName(String dn) throws NamingException {
        String rootStr;
        Name root;
        NameParser parser = this.ctx.getNameParser("");
        Name name = parser.parse(dn);
        if (name.startsWith(root = parser.parse(rootStr = this.ctx.getNameInNamespace()))) {
            Name rname = name.getSuffix(root.size());
            return rname.toString();
        }
        return dn;
    }

    protected void validateDn(String dn) {
        if (StringUtils.isEmpty((String)dn)) {
            throw new IllegalArgumentException("The dn cannot be null or empty");
        }
    }

    protected void validatePassword(String password) {
        if (StringUtils.isEmpty((String)password)) {
            throw new IllegalArgumentException("The password cannot be null or empty");
        }
    }

    protected SearchControls setSearchControls() {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningObjFlag(true);
        return controls;
    }

    public String lookupByUid(String uid) throws SecurityException {
        this.validateUid(uid);
        try {
            SearchControls cons = this.setSearchControls();
            NamingEnumeration searchResults = this.searchByWildcardedUid(uid, cons);
            return this.getFirstDnForUid(searchResults);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    private String getFirstDnForUid(NamingEnumeration searchResults) throws NamingException {
        String userDn = null;
        while (searchResults.hasMore()) {
            SearchResult searchResult = (SearchResult)searchResults.next();
            if (!(searchResult.getObject() instanceof DirContext)) continue;
            DirContext userEntry = (DirContext)searchResult.getObject();
            userDn = userEntry.getNameInNamespace();
        }
        return userDn;
    }

    protected void validateUid(String uid) {
        if (StringUtils.isEmpty((String)uid) || uid.matches("\\(\\[\\{\\^\\$\\|\\)\\?\\*\\+\\.\\\\")) {
            throw new IllegalArgumentException("The uid cannot contain any regular expression meta-characters or be null or be empty ");
        }
    }

    protected NamingEnumeration searchByWildcardedUid(String filter, SearchControls cons) throws NamingException {
        NamingEnumeration<SearchResult> searchResults = this.ctx.search("", "(&(uid=" + (StringUtils.isEmpty((String)filter) ? "*" : filter) + ") (objectclass=" + this.getObjectClass() + "))", cons);
        return searchResults;
    }

    protected abstract String getObjectClass();
}

