/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import org.apache.jetspeed.security.InvalidPasswordException;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.CredentialPasswordValidator;

public class SimpleCredentialPasswordValidator
implements CredentialPasswordValidator {
    private int minPasswordLength;
    private int minNumberOfDigits;

    public SimpleCredentialPasswordValidator(int minPasswordLength, int minNumberOfDigits) {
        this.minPasswordLength = minPasswordLength;
        this.minNumberOfDigits = minNumberOfDigits;
    }

    public void validate(String clearTextPassword) throws SecurityException {
        int digits = 0;
        char[] pwd = clearTextPassword.toCharArray();
        if (this.minPasswordLength > 0 && pwd.length < this.minPasswordLength) {
            throw new InvalidPasswordException();
        }
        if (this.minNumberOfDigits > 0) {
            for (int i = 0; i < pwd.length; ++i) {
                if (!Character.isDigit(pwd[i])) continue;
                ++digits;
            }
            if (digits < this.minNumberOfDigits) {
                throw new InvalidPasswordException();
            }
        }
    }
}

