/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.CredentialPasswordEncoder;

public class MessageDigestCredentialPasswordEncoder
implements CredentialPasswordEncoder {
    MessageDigest digester;

    public MessageDigestCredentialPasswordEncoder() throws NoSuchAlgorithmException {
        this("SHA-1");
    }

    public MessageDigestCredentialPasswordEncoder(String algorithm) throws NoSuchAlgorithmException {
        this.digester = MessageDigest.getInstance(algorithm);
    }

    public String getAlgorithm() {
        return this.digester.getAlgorithm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode(String userName, String clearTextPassword) throws SecurityException {
        byte[] value;
        MessageDigest messageDigest = this.digester;
        synchronized (messageDigest) {
            this.digester.reset();
            value = this.digester.digest(clearTextPassword.getBytes());
            this.digester.update(userName.getBytes());
            value = this.digester.digest(value);
        }
        return new String(Base64.encodeBase64((byte[])value));
    }
}

