/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.GroupPrincipal;
import org.apache.jetspeed.security.HierarchyResolver;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.UserPrincipal;
import org.apache.jetspeed.security.impl.GeneralizationHierarchyResolver;
import org.apache.jetspeed.security.impl.GroupPrincipalImpl;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;
import org.apache.jetspeed.security.spi.SecurityMappingHandler;
import org.apache.jetspeed.security.spi.impl.ldap.LdapGroupDaoImpl;
import org.apache.jetspeed.security.spi.impl.ldap.LdapPrincipalDao;
import org.apache.jetspeed.security.spi.impl.ldap.LdapUserPrincipalDao;
import org.apache.jetspeed.security.spi.impl.ldap.LdapUserPrincipalDaoImpl;

public class LdapSecurityMappingHandler
implements SecurityMappingHandler {
    private LdapUserPrincipalDao userDao;
    private LdapPrincipalDao groupDao;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$jetspeed$security$spi$impl$LdapSecurityMappingHandler == null ? (class$org$apache$jetspeed$security$spi$impl$LdapSecurityMappingHandler = LdapSecurityMappingHandler.class$("org.apache.jetspeed.security.spi.impl.LdapSecurityMappingHandler")) : class$org$apache$jetspeed$security$spi$impl$LdapSecurityMappingHandler));
    private HierarchyResolver roleHierarchyResolver = new GeneralizationHierarchyResolver();
    private HierarchyResolver groupHierarchyResolver = new GeneralizationHierarchyResolver();
    static /* synthetic */ Class class$org$apache$jetspeed$security$spi$impl$LdapSecurityMappingHandler;

    public LdapSecurityMappingHandler(LdapUserPrincipalDao userDao, LdapPrincipalDao groupDao) {
        this.userDao = userDao;
        this.groupDao = groupDao;
    }

    public LdapSecurityMappingHandler() throws SecurityException, NamingException {
        this.userDao = new LdapUserPrincipalDaoImpl();
        this.groupDao = new LdapGroupDaoImpl();
    }

    public HierarchyResolver getRoleHierarchyResolver() {
        return this.roleHierarchyResolver;
    }

    public void setRoleHierarchyResolver(HierarchyResolver roleHierarchyResolver) {
        this.roleHierarchyResolver = roleHierarchyResolver;
    }

    public HierarchyResolver getGroupHierarchyResolver() {
        return this.groupHierarchyResolver;
    }

    public void setGroupHierarchyResolver(HierarchyResolver groupHierarchyResolver) {
        this.groupHierarchyResolver = groupHierarchyResolver;
    }

    public Set getRolePrincipals(String username) {
        HashSet rolePrincipals = new HashSet();
        return rolePrincipals;
    }

    public void setRolePrincipal(String username, String roleFullPathName) throws SecurityException {
    }

    public void removeRolePrincipal(String username, String roleFullPathName) throws SecurityException {
    }

    public Set getRolePrincipalsInGroup(String groupFullPathName) {
        HashSet rolePrincipals = new HashSet();
        return rolePrincipals;
    }

    public void setRolePrincipalInGroup(String groupFullPathName, String roleFullPathName) throws SecurityException {
    }

    public void removeRolePrincipalInGroup(String groupFullPathName, String roleFullPathName) throws SecurityException {
    }

    public Set getGroupPrincipals(String userPrincipalUid) {
        HashSet groupPrincipals = new HashSet();
        try {
            String[] groups = this.userDao.getGroupUidsForUser(userPrincipalUid);
            for (int i = 0; i < groups.length; ++i) {
                this.createResolvedGroupPrincipalSet(userPrincipalUid, groupPrincipals, groups, i);
            }
        }
        catch (SecurityException e) {
            LOG.error((Object)e);
        }
        return groupPrincipals;
    }

    public Set getGroupPrincipalsInRole(String roleFullPathName) {
        HashSet groupPrincipals = new HashSet();
        return groupPrincipals;
    }

    public Set getUserPrincipalsInRole(String roleFullPathName) {
        HashSet userPrincipals = new HashSet();
        return userPrincipals;
    }

    public Set getUserPrincipalsInGroup(String groupFullPathName) {
        HashSet userPrincipals = new HashSet();
        Preferences preferences = Preferences.userRoot().node(groupFullPathName);
        String[] fullPaths = this.groupHierarchyResolver.resolve(preferences);
        try {
            this.getUserPrincipalsInGroup(userPrincipals, fullPaths);
        }
        catch (SecurityException e) {
            LOG.error((Object)e);
        }
        return userPrincipals;
    }

    private void getUserPrincipalsInGroup(Set userPrincipals, String[] fullPaths) throws SecurityException {
        for (int i = 0; i < fullPaths.length; ++i) {
            String[] usersInGroup = this.userDao.getUserUidsForGroup(fullPaths[i]);
            for (int y = 0; y < usersInGroup.length; ++y) {
                UserPrincipalImpl userPrincipal = new UserPrincipalImpl(usersInGroup[y]);
                userPrincipals.add(userPrincipal);
            }
        }
    }

    public void setUserPrincipalInGroup(String username, String groupFullPathName) throws SecurityException {
        this.verifyUserAndGroupExist(username, groupFullPathName);
        this.addGroupToUser(username, groupFullPathName);
    }

    public void removeUserPrincipalInGroup(String username, String groupFullPathName) throws SecurityException {
        this.verifyUserAndGroupExist(username, groupFullPathName);
        this.removeUserFromGroup(username, groupFullPathName);
    }

    private void verifyUserAndGroupExist(String username, String groupFullPathName) throws SecurityException {
        UserPrincipal user = this.getUser(username);
        GroupPrincipal group = this.getGroup(groupFullPathName);
    }

    private void createResolvedGroupPrincipalSet(String username, Set groupPrincipals, String[] groups, int i) {
        LOG.debug((Object)("Group [" + i + "] for user[" + username + "] is [" + groups[i] + "]"));
        GroupPrincipalImpl group = new GroupPrincipalImpl(groups[i]);
        Preferences preferences = Preferences.userRoot().node(group.getName());
        LOG.debug((Object)("Group name:" + group.getName()));
        String[] fullPaths = this.groupHierarchyResolver.resolve(preferences);
        for (int n = 0; n < fullPaths.length; ++n) {
            LOG.debug((Object)("Group [" + i + "] for user[" + username + "] is [" + GroupPrincipalImpl.getPrincipalNameFromFullPath(fullPaths[n]) + "]"));
            groupPrincipals.add(new GroupPrincipalImpl(GroupPrincipalImpl.getPrincipalNameFromFullPath(fullPaths[n])));
        }
    }

    private void removeUserFromGroup(String username, String groupFullPathName) throws SecurityException {
        this.userDao.removeGroup(username, groupFullPathName);
    }

    private UserPrincipal getUser(String uid) throws SecurityException {
        Principal[] user = this.userDao.find(uid);
        if (user.length == 1) {
            return (UserPrincipal)user[0];
        }
        throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)uid));
    }

    private GroupPrincipal getGroup(String uid) throws SecurityException {
        Principal[] group = this.groupDao.find(uid);
        if (group.length == 1) {
            return (GroupPrincipal)group[0];
        }
        throw new SecurityException(SecurityException.GROUP_DOES_NOT_EXIST.create((Object)uid));
    }

    private void addGroupToUser(String username, String groupFullPathName) throws SecurityException {
        this.userDao.addGroup(username, groupFullPathName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

