/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.GroupPrincipal;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.GroupPrincipalImpl;
import org.apache.jetspeed.security.spi.GroupSecurityHandler;
import org.apache.jetspeed.security.spi.impl.ldap.LdapGroupDaoImpl;
import org.apache.jetspeed.security.spi.impl.ldap.LdapPrincipalDao;

public class LdapGroupSecurityHandler
implements GroupSecurityHandler {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$jetspeed$security$spi$impl$LdapGroupSecurityHandler == null ? (class$org$apache$jetspeed$security$spi$impl$LdapGroupSecurityHandler = LdapGroupSecurityHandler.class$("org.apache.jetspeed.security.spi.impl.LdapGroupSecurityHandler")) : class$org$apache$jetspeed$security$spi$impl$LdapGroupSecurityHandler));
    private LdapPrincipalDao ldap;
    static /* synthetic */ Class class$org$apache$jetspeed$security$spi$impl$LdapGroupSecurityHandler;

    public LdapGroupSecurityHandler(LdapPrincipalDao ldap) {
        this.ldap = ldap;
    }

    public LdapGroupSecurityHandler() throws NamingException, SecurityException {
        this(new LdapGroupDaoImpl());
    }

    public Principal getGroupPrincipal(String groupPrincipalUid) {
        String groupUidWithoutSlashes = this.convertUidToAcceptableName(groupPrincipalUid);
        this.verifyGroupId(groupUidWithoutSlashes);
        try {
            String dn = this.ldap.lookupByUid(groupUidWithoutSlashes);
            if (!StringUtils.isEmpty((String)dn)) {
                return new GroupPrincipalImpl(groupPrincipalUid);
            }
        }
        catch (SecurityException e) {
            this.logSecurityException(e, groupPrincipalUid);
        }
        return null;
    }

    private void verifyGroupId(String groupPrincipalUid) {
        if (StringUtils.isEmpty((String)groupPrincipalUid)) {
            throw new IllegalArgumentException("The groupId cannot be null or empty.");
        }
    }

    private void logSecurityException(SecurityException e, String groupPrincipalUid) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("An LDAP error has occurred for groupId:" + groupPrincipalUid), (Throwable)e);
        }
    }

    public void setGroupPrincipal(GroupPrincipal groupPrincipal) throws SecurityException {
        System.out.println("Group Principal UID:" + groupPrincipal.getFullPath());
        this.verifyGroupPrincipal(groupPrincipal);
        String uid = groupPrincipal.getFullPath();
        String groupUidWithoutSlashes = this.convertUidToAcceptableName(uid);
        LOG.debug((Object)("Group Principal UID:" + groupUidWithoutSlashes));
        if (this.getGroupPrincipal(groupUidWithoutSlashes) == null) {
            LOG.debug((Object)("Group Principal UID:" + groupUidWithoutSlashes));
            this.ldap.create(groupUidWithoutSlashes);
        }
    }

    private String convertUidToAcceptableName(String uid) {
        return uid.replaceAll("/", "&");
    }

    private void verifyGroupPrincipal(GroupPrincipal groupPrincipal) {
        if (groupPrincipal == null) {
            throw new IllegalArgumentException("The GroupPrincipal cannot be null or empty.");
        }
    }

    public void removeGroupPrincipal(GroupPrincipal groupPrincipal) throws SecurityException {
        this.verifyGroupPrincipal(groupPrincipal);
        String uid = groupPrincipal.getFullPath();
        String groupUidWithoutSlashes = this.convertUidToAcceptableName(uid);
        this.ldap.delete(groupUidWithoutSlashes);
    }

    public List getGroupPrincipals(String filter) {
        try {
            String filterWithoutSlashes = this.convertUidToAcceptableName(filter);
            return Arrays.asList(this.ldap.find(filterWithoutSlashes));
        }
        catch (SecurityException e) {
            this.logSecurityException(e, filter);
            return new ArrayList();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

