/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.CredentialHandler;
import org.apache.jetspeed.security.spi.impl.DefaultPasswordCredentialImpl;
import org.apache.jetspeed.security.spi.impl.ldap.LdapUserCredentialDao;
import org.apache.jetspeed.security.spi.impl.ldap.LdapUserCredentialDaoImpl;

public class LdapCredentialHandler
implements CredentialHandler {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$jetspeed$security$spi$impl$LdapCredentialHandler == null ? (class$org$apache$jetspeed$security$spi$impl$LdapCredentialHandler = LdapCredentialHandler.class$("org.apache.jetspeed.security.spi.impl.LdapCredentialHandler")) : class$org$apache$jetspeed$security$spi$impl$LdapCredentialHandler));
    private LdapUserCredentialDao ldap;
    static /* synthetic */ Class class$org$apache$jetspeed$security$spi$impl$LdapCredentialHandler;

    public LdapCredentialHandler() throws NamingException, SecurityException {
        this(new LdapUserCredentialDaoImpl());
    }

    public LdapCredentialHandler(LdapUserCredentialDao ldap) throws NamingException, SecurityException {
        this.ldap = ldap;
    }

    public Set getPublicCredentials(String username) {
        return new HashSet();
    }

    public Set getPrivateCredentials(String uid) {
        HashSet<DefaultPasswordCredentialImpl> privateCredentials = new HashSet<DefaultPasswordCredentialImpl>();
        try {
            privateCredentials.add(new DefaultPasswordCredentialImpl(uid, this.ldap.getPassword(uid)));
        }
        catch (SecurityException e) {
            this.logSecurityException(e, uid);
        }
        return privateCredentials;
    }

    private void logSecurityException(SecurityException e, String uid) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("Failure creating a PasswordCredential for InternalCredential uid:" + uid), (Throwable)e);
        }
    }

    public void setPassword(String uid, String oldPassword, String newPassword) throws SecurityException {
        this.validate(uid, newPassword);
        if (!StringUtils.isEmpty((String)oldPassword)) {
            this.ldap.authenticate(uid, oldPassword);
        }
        this.ldap.changePassword(uid, newPassword);
    }

    public void setPasswordEnabled(String userName, boolean enabled) throws SecurityException {
    }

    public void setPasswordUpdateRequired(String userName, boolean updateRequired) throws SecurityException {
    }

    public boolean authenticate(String uid, String password) throws SecurityException {
        this.validate(uid, password);
        return this.ldap.authenticate(uid, password);
    }

    private void validate(String uid, String password) throws SecurityException {
        if (StringUtils.isEmpty((String)password)) {
            throw new SecurityException(SecurityException.EMPTY_PARAMETER.create((Object)"password"));
        }
        if (StringUtils.isEmpty((String)uid)) {
            throw new SecurityException(SecurityException.EMPTY_PARAMETER.create((Object)"uid"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

