/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.security.Principal;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.UserPrincipal;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;
import org.apache.jetspeed.security.om.InternalUserPrincipal;
import org.apache.jetspeed.security.om.impl.InternalUserPrincipalImpl;
import org.apache.jetspeed.security.spi.SecurityAccess;
import org.apache.jetspeed.security.spi.UserSecurityHandler;

public class DefaultUserSecurityHandler
implements UserSecurityHandler {
    private SecurityAccess securityAccess = null;

    public DefaultUserSecurityHandler(SecurityAccess securityAccess) {
        this.securityAccess = securityAccess;
    }

    public boolean isUserPrincipal(String userName) {
        return this.securityAccess.isKnownUser(userName);
    }

    public Principal getUserPrincipal(String username) {
        UserPrincipalImpl userPrincipal = null;
        InternalUserPrincipal internalUser = this.securityAccess.getInternalUserPrincipal(username, false);
        if (null != internalUser) {
            userPrincipal = new UserPrincipalImpl(UserPrincipalImpl.getPrincipalNameFromFullPath(internalUser.getFullPath()));
        }
        return userPrincipal;
    }

    public List getUserPrincipals(String filter) {
        LinkedList<UserPrincipalImpl> userPrincipals = new LinkedList<UserPrincipalImpl>();
        Iterator result = this.securityAccess.getInternalUserPrincipals(filter);
        while (result.hasNext()) {
            InternalUserPrincipal internalUser = (InternalUserPrincipal)result.next();
            String path = internalUser.getFullPath();
            if (path == null) continue;
            userPrincipals.add(new UserPrincipalImpl(UserPrincipalImpl.getPrincipalNameFromFullPath(internalUser.getFullPath())));
        }
        return userPrincipals;
    }

    public void addUserPrincipal(UserPrincipal userPrincipal) throws SecurityException {
        String fullPath = userPrincipal.getFullPath();
        InternalUserPrincipalImpl internalUser = new InternalUserPrincipalImpl(fullPath);
        this.securityAccess.setInternalUserPrincipal(internalUser, false);
    }

    public void updateUserPrincipal(UserPrincipal userPrincipal) throws SecurityException {
        String fullPath = userPrincipal.getFullPath();
        InternalUserPrincipalImpl internalUser = new InternalUserPrincipalImpl(fullPath);
        this.securityAccess.setInternalUserPrincipal(internalUser, false);
    }

    public void removeUserPrincipal(UserPrincipal userPrincipal) throws SecurityException {
        InternalUserPrincipal internalUser = this.securityAccess.getInternalUserPrincipal(userPrincipal.getName(), false);
        if (null != internalUser) {
            this.securityAccess.removeInternalUserPrincipal(internalUser);
        } else {
            internalUser = this.securityAccess.getInternalUserPrincipal(userPrincipal.getName(), true);
            if (null != internalUser) {
                this.securityAccess.removeInternalUserPrincipal(internalUser);
            }
        }
    }
}

