/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.prefs.Preferences;
import org.apache.jetspeed.security.HierarchyResolver;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.GeneralizationHierarchyResolver;
import org.apache.jetspeed.security.impl.GroupPrincipalImpl;
import org.apache.jetspeed.security.impl.RolePrincipalImpl;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;
import org.apache.jetspeed.security.om.InternalGroupPrincipal;
import org.apache.jetspeed.security.om.InternalRolePrincipal;
import org.apache.jetspeed.security.om.InternalUserPrincipal;
import org.apache.jetspeed.security.om.impl.InternalUserPrincipalImpl;
import org.apache.jetspeed.security.spi.SecurityAccess;
import org.apache.jetspeed.security.spi.SecurityMappingHandler;

public class DefaultSecurityMappingHandler
implements SecurityMappingHandler {
    HierarchyResolver roleHierarchyResolver = new GeneralizationHierarchyResolver();
    HierarchyResolver groupHierarchyResolver = new GeneralizationHierarchyResolver();
    private SecurityAccess commonQueries = null;

    public DefaultSecurityMappingHandler(SecurityAccess commonQueries) {
        this.commonQueries = commonQueries;
    }

    public DefaultSecurityMappingHandler(SecurityAccess commonQueries, HierarchyResolver roleHierarchyResolver, HierarchyResolver groupHierarchyResolver) {
        this.commonQueries = commonQueries;
        if (null != roleHierarchyResolver) {
            this.roleHierarchyResolver = roleHierarchyResolver;
        }
        if (null != groupHierarchyResolver) {
            this.groupHierarchyResolver = groupHierarchyResolver;
        }
    }

    public HierarchyResolver getRoleHierarchyResolver() {
        return this.roleHierarchyResolver;
    }

    public void setRoleHierarchyResolver(HierarchyResolver roleHierarchyResolver) {
        this.roleHierarchyResolver = roleHierarchyResolver;
    }

    public HierarchyResolver getGroupHierarchyResolver() {
        return this.groupHierarchyResolver;
    }

    public void setGroupHierarchyResolver(HierarchyResolver groupHierarchyResolver) {
        this.groupHierarchyResolver = groupHierarchyResolver;
    }

    public Set getRolePrincipals(String username) {
        Collection internalRoles;
        HashSet<RolePrincipalImpl> rolePrincipals = new HashSet<RolePrincipalImpl>();
        InternalUserPrincipal internalUser = this.commonQueries.getInternalUserPrincipal(username);
        if (null != internalUser && null != (internalRoles = internalUser.getRolePrincipals())) {
            Iterator internalRolesIter = internalRoles.iterator();
            while (internalRolesIter.hasNext()) {
                InternalRolePrincipal internalRole = (InternalRolePrincipal)internalRolesIter.next();
                Preferences preferences = Preferences.userRoot().node(internalRole.getFullPath());
                String[] fullPaths = this.roleHierarchyResolver.resolve(preferences);
                for (int i = 0; i < fullPaths.length; ++i) {
                    RolePrincipalImpl rolePrincipal = new RolePrincipalImpl(RolePrincipalImpl.getPrincipalNameFromFullPath(fullPaths[i]));
                    if (rolePrincipals.contains(rolePrincipal)) continue;
                    rolePrincipals.add(rolePrincipal);
                }
            }
        }
        return rolePrincipals;
    }

    public void setRolePrincipal(String username, String roleFullPathName) throws SecurityException {
        InternalUserPrincipal internalUser = this.commonQueries.getInternalUserPrincipal(username);
        boolean isMappingOnly = false;
        if (null == internalUser) {
            isMappingOnly = true;
            internalUser = new InternalUserPrincipalImpl(UserPrincipalImpl.getFullPathFromPrincipalName(username));
        }
        Collection internalRoles = internalUser.getRolePrincipals();
        InternalRolePrincipal internalRole = this.commonQueries.getInternalRolePrincipal(RolePrincipalImpl.getFullPathFromPrincipalName(roleFullPathName));
        if (null == internalRole) {
            throw new SecurityException(SecurityException.ROLE_DOES_NOT_EXIST.create((Object)roleFullPathName));
        }
        internalRoles.add(internalRole);
        internalUser.setRolePrincipals(internalRoles);
        this.commonQueries.setInternalUserPrincipal(internalUser, isMappingOnly);
    }

    public void removeRolePrincipal(String username, String roleFullPathName) throws SecurityException {
        boolean isMappingOnly = false;
        InternalUserPrincipal internalUser = this.commonQueries.getInternalUserPrincipal(username, false);
        if (null == internalUser) {
            internalUser = this.commonQueries.getInternalUserPrincipal(username, true);
            isMappingOnly = true;
        }
        if (null != internalUser) {
            Collection internalRoles = internalUser.getRolePrincipals();
            InternalRolePrincipal internalRole = this.commonQueries.getInternalRolePrincipal(RolePrincipalImpl.getFullPathFromPrincipalName(roleFullPathName));
            if (null == internalRole) {
                throw new SecurityException(SecurityException.ROLE_DOES_NOT_EXIST.create((Object)roleFullPathName));
            }
            internalRoles.remove(internalRole);
            if (isMappingOnly && internalRoles.isEmpty() && internalUser.getGroupPrincipals().isEmpty() && internalUser.getPermissions().isEmpty()) {
                this.commonQueries.removeInternalUserPrincipal(internalUser);
            } else {
                internalUser.setRolePrincipals(internalRoles);
                this.commonQueries.setInternalUserPrincipal(internalUser, isMappingOnly);
            }
        } else {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)username));
        }
    }

    public Set getRolePrincipalsInGroup(String groupFullPathName) {
        HashSet<RolePrincipalImpl> rolePrincipals = new HashSet<RolePrincipalImpl>();
        Preferences preferences = Preferences.userRoot().node(GroupPrincipalImpl.getFullPathFromPrincipalName(groupFullPathName));
        String[] fullPaths = this.groupHierarchyResolver.resolve(preferences);
        for (int i = 0; i < fullPaths.length; ++i) {
            Collection internalRoles;
            InternalGroupPrincipal internalGroup = this.commonQueries.getInternalGroupPrincipal(fullPaths[i]);
            if (null == internalGroup || null == (internalRoles = internalGroup.getRolePrincipals())) continue;
            Iterator internalRolesIter = internalRoles.iterator();
            while (internalRolesIter.hasNext()) {
                InternalRolePrincipal internalRole = (InternalRolePrincipal)internalRolesIter.next();
                RolePrincipalImpl rolePrincipal = new RolePrincipalImpl(UserPrincipalImpl.getPrincipalNameFromFullPath(internalRole.getFullPath()));
                if (rolePrincipals.contains(rolePrincipal)) continue;
                rolePrincipals.add(rolePrincipal);
            }
        }
        return rolePrincipals;
    }

    public void setRolePrincipalInGroup(String groupFullPathName, String roleFullPathName) throws SecurityException {
        InternalGroupPrincipal internalGroup = this.commonQueries.getInternalGroupPrincipal(GroupPrincipalImpl.getFullPathFromPrincipalName(groupFullPathName));
        if (null == internalGroup) {
            throw new SecurityException(SecurityException.GROUP_DOES_NOT_EXIST.create((Object)groupFullPathName));
        }
        Collection internalRoles = internalGroup.getRolePrincipals();
        InternalRolePrincipal internalRole = this.commonQueries.getInternalRolePrincipal(RolePrincipalImpl.getFullPathFromPrincipalName(roleFullPathName));
        internalRoles.add(internalRole);
        internalGroup.setRolePrincipals(internalRoles);
        this.commonQueries.setInternalGroupPrincipal(internalGroup, false);
    }

    public void removeRolePrincipalInGroup(String groupFullPathName, String roleFullPathName) throws SecurityException {
        InternalGroupPrincipal internalGroup = this.commonQueries.getInternalGroupPrincipal(GroupPrincipalImpl.getFullPathFromPrincipalName(groupFullPathName));
        if (null == internalGroup) {
            throw new SecurityException(SecurityException.GROUP_DOES_NOT_EXIST.create((Object)internalGroup));
        }
        Collection internalRoles = internalGroup.getRolePrincipals();
        InternalRolePrincipal internalRole = this.commonQueries.getInternalRolePrincipal(RolePrincipalImpl.getFullPathFromPrincipalName(roleFullPathName));
        internalRoles.remove(internalRole);
        internalGroup.setRolePrincipals(internalRoles);
        this.commonQueries.setInternalGroupPrincipal(internalGroup, false);
    }

    public Set getGroupPrincipals(String username) {
        Collection internalGroups;
        HashSet<GroupPrincipalImpl> groupPrincipals = new HashSet<GroupPrincipalImpl>();
        InternalUserPrincipal internalUser = this.commonQueries.getInternalUserPrincipal(username);
        if (null != internalUser && null != (internalGroups = internalUser.getGroupPrincipals())) {
            Iterator internalGroupsIter = internalGroups.iterator();
            while (internalGroupsIter.hasNext()) {
                InternalGroupPrincipal internalGroup = (InternalGroupPrincipal)internalGroupsIter.next();
                Preferences preferences = Preferences.userRoot().node(internalGroup.getFullPath());
                String[] fullPaths = this.groupHierarchyResolver.resolve(preferences);
                for (int i = 0; i < fullPaths.length; ++i) {
                    groupPrincipals.add(new GroupPrincipalImpl(GroupPrincipalImpl.getPrincipalNameFromFullPath(fullPaths[i])));
                }
            }
        }
        return groupPrincipals;
    }

    public Set getGroupPrincipalsInRole(String roleFullPathName) {
        HashSet<GroupPrincipalImpl> groupPrincipals = new HashSet<GroupPrincipalImpl>();
        Preferences preferences = Preferences.userRoot().node(RolePrincipalImpl.getFullPathFromPrincipalName(roleFullPathName));
        String[] fullPaths = this.roleHierarchyResolver.resolve(preferences);
        for (int i = 0; i < fullPaths.length; ++i) {
            Collection internalGroups;
            InternalRolePrincipal internalRole = this.commonQueries.getInternalRolePrincipal(fullPaths[i]);
            if (null == internalRole || null == (internalGroups = internalRole.getGroupPrincipals())) continue;
            Iterator internalGroupsIter = internalGroups.iterator();
            while (internalGroupsIter.hasNext()) {
                InternalGroupPrincipal internalGroup = (InternalGroupPrincipal)internalGroupsIter.next();
                GroupPrincipalImpl groupPrincipal = new GroupPrincipalImpl(GroupPrincipalImpl.getPrincipalNameFromFullPath(internalGroup.getFullPath()));
                if (groupPrincipals.contains(groupPrincipal)) continue;
                groupPrincipals.add(groupPrincipal);
            }
        }
        return groupPrincipals;
    }

    public Set getUserPrincipalsInRole(String roleFullPathName) {
        HashSet<UserPrincipalImpl> userPrincipals = new HashSet<UserPrincipalImpl>();
        Preferences preferences = Preferences.userRoot().node(RolePrincipalImpl.getFullPathFromPrincipalName(roleFullPathName));
        String[] fullPaths = this.roleHierarchyResolver.resolve(preferences);
        for (int i = 0; i < fullPaths.length; ++i) {
            Collection internalUsers;
            InternalRolePrincipal internalRole = this.commonQueries.getInternalRolePrincipal(fullPaths[i]);
            if (null == internalRole || null == (internalUsers = internalRole.getUserPrincipals())) continue;
            Iterator internalUsersIter = internalUsers.iterator();
            while (internalUsersIter.hasNext()) {
                InternalUserPrincipal internalUser = (InternalUserPrincipal)internalUsersIter.next();
                UserPrincipalImpl userPrincipal = new UserPrincipalImpl(UserPrincipalImpl.getPrincipalNameFromFullPath(internalUser.getFullPath()));
                if (userPrincipals.contains(userPrincipal)) continue;
                userPrincipals.add(userPrincipal);
            }
        }
        return userPrincipals;
    }

    public Set getUserPrincipalsInGroup(String groupFullPathName) {
        HashSet<UserPrincipalImpl> userPrincipals = new HashSet<UserPrincipalImpl>();
        Preferences preferences = Preferences.userRoot().node(GroupPrincipalImpl.getFullPathFromPrincipalName(groupFullPathName));
        String[] fullPaths = this.groupHierarchyResolver.resolve(preferences);
        for (int i = 0; i < fullPaths.length; ++i) {
            Collection internalUsers;
            InternalGroupPrincipal internalGroup = this.commonQueries.getInternalGroupPrincipal(fullPaths[i]);
            if (null == internalGroup || null == (internalUsers = internalGroup.getUserPrincipals())) continue;
            Iterator internalUsersIter = internalUsers.iterator();
            while (internalUsersIter.hasNext()) {
                InternalUserPrincipal internalUser = (InternalUserPrincipal)internalUsersIter.next();
                UserPrincipalImpl userPrincipal = new UserPrincipalImpl(UserPrincipalImpl.getPrincipalNameFromFullPath(internalUser.getFullPath()));
                if (userPrincipals.contains(userPrincipal)) continue;
                userPrincipals.add(userPrincipal);
            }
        }
        return userPrincipals;
    }

    public void setUserPrincipalInGroup(String username, String groupFullPathName) throws SecurityException {
        InternalUserPrincipal internalUser = this.commonQueries.getInternalUserPrincipal(username);
        boolean isMappingOnly = false;
        if (null == internalUser) {
            isMappingOnly = true;
            internalUser = new InternalUserPrincipalImpl(UserPrincipalImpl.getFullPathFromPrincipalName(username));
        }
        Collection internalGroups = internalUser.getGroupPrincipals();
        InternalGroupPrincipal internalGroup = this.commonQueries.getInternalGroupPrincipal(GroupPrincipalImpl.getFullPathFromPrincipalName(groupFullPathName));
        if (null == internalGroup) {
            throw new SecurityException(SecurityException.GROUP_DOES_NOT_EXIST.create((Object)groupFullPathName));
        }
        internalGroups.add(internalGroup);
        internalUser.setGroupPrincipals(internalGroups);
        this.commonQueries.setInternalUserPrincipal(internalUser, isMappingOnly);
    }

    public void removeUserPrincipalInGroup(String username, String groupFullPathName) throws SecurityException {
        boolean isMappingOnly = false;
        InternalUserPrincipal internalUser = this.commonQueries.getInternalUserPrincipal(username, false);
        if (null == internalUser) {
            internalUser = this.commonQueries.getInternalUserPrincipal(username, true);
            isMappingOnly = true;
        }
        if (null != internalUser) {
            Collection internalGroups = internalUser.getGroupPrincipals();
            InternalGroupPrincipal internalGroup = this.commonQueries.getInternalGroupPrincipal(GroupPrincipalImpl.getFullPathFromPrincipalName(groupFullPathName));
            if (null == internalGroup) {
                throw new SecurityException(SecurityException.GROUP_DOES_NOT_EXIST.create((Object)groupFullPathName));
            }
            internalGroups.remove(internalGroup);
            if (isMappingOnly && internalGroups.isEmpty() && internalUser.getRolePrincipals().isEmpty() && internalUser.getPermissions().isEmpty()) {
                this.commonQueries.removeInternalUserPrincipal(internalUser);
            } else {
                internalUser.setGroupPrincipals(internalGroups);
                this.commonQueries.setInternalUserPrincipal(internalUser, isMappingOnly);
            }
        } else {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)username));
        }
    }
}

