/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.InvalidNewPasswordException;
import org.apache.jetspeed.security.InvalidPasswordException;
import org.apache.jetspeed.security.PasswordAlreadyUsedException;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.om.InternalCredential;
import org.apache.jetspeed.security.om.InternalUserPrincipal;
import org.apache.jetspeed.security.om.impl.InternalCredentialImpl;
import org.apache.jetspeed.security.spi.CredentialHandler;
import org.apache.jetspeed.security.spi.InternalPasswordCredentialInterceptor;
import org.apache.jetspeed.security.spi.PasswordCredentialProvider;
import org.apache.jetspeed.security.spi.SecurityAccess;

public class DefaultCredentialHandler
implements CredentialHandler {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$security$spi$impl$DefaultCredentialHandler == null ? (class$org$apache$jetspeed$security$spi$impl$DefaultCredentialHandler = DefaultCredentialHandler.class$("org.apache.jetspeed.security.spi.impl.DefaultCredentialHandler")) : class$org$apache$jetspeed$security$spi$impl$DefaultCredentialHandler));
    private SecurityAccess securityAccess;
    private PasswordCredentialProvider pcProvider;
    private InternalPasswordCredentialInterceptor ipcInterceptor;
    static /* synthetic */ Class class$org$apache$jetspeed$security$spi$impl$DefaultCredentialHandler;

    public DefaultCredentialHandler(SecurityAccess securityAccess, PasswordCredentialProvider pcProvider, InternalPasswordCredentialInterceptor ipcInterceptor) {
        this.securityAccess = securityAccess;
        this.pcProvider = pcProvider;
        this.ipcInterceptor = ipcInterceptor;
    }

    public Set getPrivateCredentials(String username) {
        HashSet<PasswordCredential> credentials;
        block3: {
            InternalCredential credential;
            credentials = new HashSet<PasswordCredential>();
            InternalUserPrincipal internalUser = this.securityAccess.getInternalUserPrincipal(username, false);
            if (null != internalUser && (credential = this.getPasswordCredential(internalUser, username)) != null) {
                try {
                    credentials.add(this.pcProvider.create(username, credential));
                }
                catch (SecurityException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)("Failure creating a PasswordCredential for InternalCredential " + credential), (Throwable)e);
                }
            }
        }
        return credentials;
    }

    public Set getPublicCredentials(String username) {
        return new HashSet();
    }

    private InternalCredential getPasswordCredential(InternalUserPrincipal internalUser, String username) {
        InternalCredential credential = null;
        Collection internalCredentials = internalUser.getCredentials();
        if (internalCredentials != null) {
            Iterator iter = internalCredentials.iterator();
            while (iter.hasNext()) {
                block5: {
                    credential = (InternalCredential)iter.next();
                    if (credential.getType() == 0 && null != credential.getClassname() && credential.getClassname().equals(this.pcProvider.getPasswordCredentialClass().getName())) {
                        try {
                            if (this.ipcInterceptor == null || !this.ipcInterceptor.afterLoad(this.pcProvider, username, credential)) break;
                            this.securityAccess.setInternalUserPrincipal(internalUser, internalUser.isMappingOnly());
                            break;
                        }
                        catch (SecurityException e) {
                            if (!log.isErrorEnabled()) break block5;
                            log.error((Object)("Failure loading InternalCredential " + credential), (Throwable)e);
                        }
                    }
                }
                credential = null;
            }
        }
        return credential;
    }

    public void setPassword(String userName, String oldPassword, String newPassword) throws SecurityException {
        boolean create;
        InternalUserPrincipal internalUser = this.securityAccess.getInternalUserPrincipal(userName, false);
        if (null == internalUser) {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userName));
        }
        ArrayList<InternalCredential> credentials = internalUser.getCredentials();
        if (null == credentials) {
            credentials = new ArrayList<InternalCredential>();
        }
        InternalCredential credential = this.getPasswordCredential(internalUser, userName);
        if (null != oldPassword && credential != null && credential.getValue() != null && credential.isEncoded() && this.pcProvider.getEncoder() != null) {
            oldPassword = this.pcProvider.getEncoder().encode(userName, oldPassword);
        }
        if (!(oldPassword == null || credential != null && credential.getValue() != null && credential.getValue().equals(oldPassword))) {
            throw new InvalidPasswordException();
        }
        if (this.pcProvider.getValidator() != null) {
            try {
                this.pcProvider.getValidator().validate(newPassword);
            }
            catch (InvalidPasswordException ipe) {
                throw new InvalidNewPasswordException();
            }
        }
        boolean encoded = false;
        if (this.pcProvider.getEncoder() != null) {
            newPassword = this.pcProvider.getEncoder().encode(userName, newPassword);
            encoded = true;
        }
        boolean bl = create = credential == null;
        if (create) {
            credential = new InternalCredentialImpl(internalUser.getPrincipalId(), newPassword, 0, this.pcProvider.getPasswordCredentialClass().getName());
            credential.setEncoded(encoded);
            credentials.add(credential);
        } else if (oldPassword != null && oldPassword.equals(newPassword)) {
            throw new PasswordAlreadyUsedException();
        }
        if (this.ipcInterceptor != null) {
            if (create) {
                this.ipcInterceptor.beforeCreate(internalUser, credentials, userName, credential, newPassword);
            } else {
                this.ipcInterceptor.beforeSetPassword(internalUser, credentials, userName, credential, newPassword, oldPassword != null);
            }
        }
        if (!create) {
            credential.setValue(newPassword);
            credential.setEncoded(encoded);
        }
        internalUser.setModifiedDate(new Timestamp(new Date().getTime()));
        internalUser.setCredentials(credentials);
        this.securityAccess.setInternalUserPrincipal(internalUser, false);
    }

    public void setPasswordEnabled(String userName, boolean enabled) throws SecurityException {
        InternalUserPrincipal internalUser = this.securityAccess.getInternalUserPrincipal(userName, false);
        if (null != internalUser) {
            InternalCredential credential = this.getPasswordCredential(internalUser, userName);
            if (credential != null && !credential.isExpired() && credential.isEnabled() != enabled) {
                credential.setEnabled(enabled);
                internalUser.setModifiedDate(new Timestamp(new Date().getTime()));
                this.securityAccess.setInternalUserPrincipal(internalUser, false);
            }
        } else {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userName));
        }
    }

    public void setPasswordUpdateRequired(String userName, boolean updateRequired) throws SecurityException {
        InternalUserPrincipal internalUser = this.securityAccess.getInternalUserPrincipal(userName, false);
        if (null != internalUser) {
            InternalCredential credential = this.getPasswordCredential(internalUser, userName);
            if (credential != null && !credential.isExpired() && credential.isUpdateRequired() != updateRequired) {
                if (!updateRequired && !credential.isEncoded() && this.pcProvider.getValidator() != null) {
                    this.pcProvider.getValidator().validate(credential.getValue());
                }
                credential.setUpdateRequired(updateRequired);
                long time = new Date().getTime();
                credential.setModifiedDate(new Timestamp(time));
                credential.setPreviousAuthenticationDate(new Timestamp(time));
                internalUser.setModifiedDate(new Timestamp(time));
                this.securityAccess.setInternalUserPrincipal(internalUser, false);
            }
        } else {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userName));
        }
    }

    public boolean authenticate(String userName, String password) throws SecurityException {
        boolean authenticated = false;
        InternalUserPrincipal internalUser = this.securityAccess.getInternalUserPrincipal(userName, false);
        if (null != internalUser) {
            InternalCredential credential = this.getPasswordCredential(internalUser, userName);
            if (credential != null && credential.isEnabled() && !credential.isExpired()) {
                if (this.pcProvider.getEncoder() != null && credential.isEncoded()) {
                    password = this.pcProvider.getEncoder().encode(userName, password);
                }
                authenticated = credential.getValue().equals(password);
                boolean update = false;
                if (this.ipcInterceptor != null && (update = this.ipcInterceptor.afterAuthenticated(internalUser, userName, credential, authenticated)) && (!credential.isEnabled() || credential.isExpired())) {
                    authenticated = false;
                }
                if (authenticated) {
                    credential.setAuthenticationFailures(0);
                    credential.setPreviousAuthenticationDate(credential.getLastAuthenticationDate());
                    credential.setLastAuthenticationDate(new Timestamp(System.currentTimeMillis()));
                    update = true;
                }
                if (update) {
                    internalUser.setModifiedDate(new Timestamp(System.currentTimeMillis()));
                    this.securityAccess.setInternalUserPrincipal(internalUser, false);
                }
            }
        } else {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userName));
        }
        return authenticated;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

