/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import org.apache.jetspeed.security.BasePrincipal;

public class BasePrincipalImpl
implements BasePrincipal {
    private final String name;
    private final String fullPath;
    private boolean enabled;

    public BasePrincipalImpl(String name, String prefsRoot) {
        this.name = name;
        this.fullPath = BasePrincipalImpl.getFullPathFromPrincipalName(name, prefsRoot);
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public static String getFullPathFromPrincipalName(String name, String prefsRoot) {
        String fullPath = name;
        if (null != fullPath) {
            fullPath = prefsRoot + fullPath.replace('.', '/');
        }
        return fullPath;
    }

    public static String getPrincipalNameFromFullPath(String fullPath, String prefsRoot) {
        String name = fullPath;
        if (null != name) {
            name = prefsRoot.equals("/user/") ? name.substring(prefsRoot.length(), name.length()) : name.substring(prefsRoot.length(), name.length());
            name = name.replace('/', '.');
        }
        return name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

