/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.interceptors;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.jetspeed.cache.general.GeneralCache;

public abstract class AbstractCacheInterceptor
implements Interceptor,
MethodInterceptor,
Advice {
    protected GeneralCache cache;
    protected String uniquePrefix;

    public AbstractCacheInterceptor(GeneralCache cache, String uniquePrefix) {
        this.cache = cache;
        this.uniquePrefix = uniquePrefix;
    }

    public AbstractCacheInterceptor(GeneralCache cache) {
        this(cache, null);
    }

    public static final String buildKey(String uniquePrefix, String arg0) {
        return uniquePrefix + ":" + arg0;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        Object[] args = mi.getArguments();
        Method method = mi.getMethod();
        if (args == null) {
            throw new IllegalArgumentException(method.getDeclaringClass() + "." + method.getName() + "() receives no arguments.  " + "CacheInterceptor can only intercept methods that have at least (1) argument.");
        }
        Object arg0 = args[0];
        if (arg0 == null) {
            throw new IllegalArgumentException("CacheInterceptor requires that the first argument passed to a cached be non-null");
        }
        String prefix = null;
        prefix = this.uniquePrefix != null ? AbstractCacheInterceptor.buildKey(this.uniquePrefix, arg0.toString()) : AbstractCacheInterceptor.buildKey(mi.getMethod().getDeclaringClass().getName(), arg0.toString());
        return this.doCacheOperation(mi, prefix);
    }

    protected abstract Object doCacheOperation(MethodInvocation var1, String var2) throws Throwable;
}

