/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.service;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.TomcatTreeBuilder;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;
import org.apache.webapp.admin.logger.DeleteLoggerAction;
import org.apache.webapp.admin.service.ServiceForm;

public final class SaveServiceAction
extends Action {
    private String[] createStandardEngineTypes = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
    private String[] createStandardServiceTypes = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
    private String[] createStandardEngineServiceTypes = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
    private String[] createUserDatabaseRealmTypes = new String[]{"java.lang.String", "java.lang.String"};
    private MBeanServer mBServer = null;
    private MessageResources resources = null;

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (this.resources == null) {
            this.resources = this.getServlet().getResources();
        }
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        ServiceForm sform = (ServiceForm)form;
        String adminAction = sform.getAdminAction();
        String sObjectName = sform.getObjectName();
        String eObjectName = sform.getEngineObjectName();
        String serverObjectName = sform.getServerObjectName();
        ObjectName eoname = null;
        ObjectName soname = null;
        if ("Create".equals(adminAction)) {
            String operation = null;
            Object[] values = null;
            try {
                String engineName = sform.getEngineName();
                ObjectName oname = new ObjectName("*:type=Service,serviceName=" + sform.getServiceName());
                Iterator<ObjectName> names = this.mBServer.queryNames(oname, null).iterator();
                while (names.hasNext()) {
                    if (!this.mBServer.isRegistered(names.next())) continue;
                    ActionErrors errors = new ActionErrors();
                    errors.add("serviceName", new ActionError("error.serviceName.exists"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                oname = new ObjectName(engineName + ":type=Engine");
                if (this.mBServer.isRegistered(oname)) {
                    ActionErrors errors = new ActionErrors();
                    errors.add("serviceName", new ActionError("error.engineName.exists"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                ObjectName fname = TomcatTreeBuilder.getMBeanFactory();
                values = new String[]{":type=Server", engineName, sform.getDefaultHost(), sform.getServiceName()};
                operation = "createStandardEngineService";
                Vector onames = (Vector)this.mBServer.invoke(fname, operation, values, this.createStandardEngineServiceTypes);
                eoname = (ObjectName)onames.get(0);
                soname = (ObjectName)onames.get(1);
                sObjectName = soname.toString();
                eObjectName = eoname.toString();
                String realmOName = DeleteLoggerAction.getObjectName(eObjectName, ":type=Realm");
                ObjectName roname = new ObjectName(realmOName);
                if (this.mBServer.isRegistered(roname)) {
                    this.mBServer.unregisterMBean(roname);
                }
                values = new String[]{eObjectName, "UserDatabase"};
                operation = "createUserDatabaseRealm";
                sObjectName = soname.toString();
                eObjectName = eoname.toString();
                TreeControl control = (TreeControl)session.getAttribute("treeControlTest");
                if (control != null) {
                    String parentName = "Catalina:type=Server";
                    TreeControlNode parentNode = control.findNode(parentName);
                    if (parentNode != null) {
                        String nodeLabel = this.resources.getMessage(locale, "server.service.treeBuilder.subtreeNode") + " (" + soname.getKeyProperty("serviceName") + ")";
                        String encodedName = URLEncoder.encode(sObjectName);
                        TreeControlNode childNode = new TreeControlNode(sObjectName, "Service.gif", nodeLabel, "EditService.do?select=" + encodedName, "content", true, engineName);
                        parentNode.addChild(childNode);
                    } else {
                        this.getServlet().log("Cannot find parent node '" + parentName + "'");
                    }
                } else {
                    this.getServlet().log("Cannot find TreeControlNode!");
                }
            }
            catch (Exception e) {
                this.getServlet().log(this.resources.getMessage(locale, "users.error.invoke", operation), (Throwable)e);
                response.sendError(500, this.resources.getMessage(locale, "users.error.invoke", operation));
                return null;
            }
        }
        String attribute = null;
        try {
            eoname = new ObjectName(eObjectName);
            soname = new ObjectName(sObjectName);
            attribute = "debug";
            int debug = 0;
            try {
                debug = Integer.parseInt(sform.getDebugLvl());
            }
            catch (Throwable t) {
                debug = 0;
            }
            this.mBServer.setAttribute(soname, new Attribute("debug", new Integer(debug)));
            this.mBServer.setAttribute(eoname, new Attribute("debug", new Integer(debug)));
            attribute = "defaultHost";
            String defaultHost = sform.getDefaultHost();
            if ("".equals(defaultHost)) {
                defaultHost = null;
            }
            this.mBServer.setAttribute(eoname, new Attribute("defaultHost", defaultHost));
        }
        catch (Exception e) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.attribute.set", attribute), (Throwable)e);
            response.sendError(500, this.resources.getMessage(locale, "users.error.attribute.set", (Object)attribute));
            return null;
        }
        session.removeAttribute(mapping.getAttribute());
        return mapping.findForward("Save Successful");
    }
}

