/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.io.IOException;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.resources.ResourceLinkForm;

public final class SetUpResourceLinkAction
extends Action {
    private MBeanServer mserver = null;
    private MessageResources resources = null;

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        if (this.resources == null) {
            this.resources = this.getServlet().getResources();
        }
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        String objectName = request.getParameter("objectName");
        String resourcetype = request.getParameter("resourcetype");
        String path = request.getParameter("path");
        String host = request.getParameter("host");
        String domain = request.getParameter("domain");
        ResourceLinkForm resourceLinkForm = new ResourceLinkForm();
        resourceLinkForm.setResourcetype(resourcetype);
        resourceLinkForm.setPath(path);
        resourceLinkForm.setHost(host);
        resourceLinkForm.setDomain(domain);
        if (objectName == null) {
            resourceLinkForm.setNodeLabel(this.resources.getMessage(locale, "resources.actions.resourcelk.create"));
            resourceLinkForm.setObjectName(null);
        } else {
            resourceLinkForm.setNodeLabel(this.resources.getMessage(locale, "resources.actions.resourcelk.edit"));
            resourceLinkForm.setObjectName(objectName);
            String attribute = null;
            try {
                ObjectName oname = new ObjectName(objectName);
                attribute = "name";
                resourceLinkForm.setName((String)this.mserver.getAttribute(oname, attribute));
                attribute = "global";
                resourceLinkForm.setGlobal((String)this.mserver.getAttribute(oname, attribute));
                attribute = "type";
                resourceLinkForm.setType((String)this.mserver.getAttribute(oname, attribute));
            }
            catch (Exception e) {
                this.getServlet().log(this.resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), (Throwable)e);
                response.sendError(500, this.resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
                return null;
            }
        }
        this.saveToken(request);
        request.setAttribute("resourceLinkForm", (Object)resourceLinkForm);
        return mapping.findForward("ResourceLink");
    }
}

