/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.webapp.admin.LabelValueBean;
import org.apache.webapp.admin.resources.BaseForm;

public final class EnvEntryForm
extends BaseForm {
    private String name = null;
    private String entryType = null;
    private String value = null;
    private String description = null;
    private boolean override = true;
    private String resourcetype = null;
    private String path = null;
    private String host = null;
    private String domain = null;
    private static List typeVals = new ArrayList();
    private ActionErrors errors = null;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEntryType() {
        return this.entryType;
    }

    public void setEntryType(String entryType) {
        this.entryType = entryType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean getOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public String getResourcetype() {
        return this.resourcetype;
    }

    public void setResourcetype(String resourcetype) {
        this.resourcetype = resourcetype;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public List getTypeVals() {
        return typeVals;
    }

    public void setTypeVals(List typeVals) {
        EnvEntryForm.typeVals = typeVals;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.name = null;
        this.entryType = null;
        this.value = null;
        this.description = null;
        this.override = false;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        this.errors = new ActionErrors();
        String submit = request.getParameter("submit");
        if (this.name == null || this.name.length() < 1) {
            this.errors.add("name", new ActionError("resources.error.name.required"));
        }
        if (this.value == null || this.value.length() < 1) {
            this.errors.add("value", new ActionError("resources.error.value.required"));
        }
        if (this.name != null && this.name.indexOf(34) >= 0) {
            this.errors.add("name", new ActionError("users.error.quotes"));
        }
        if (this.value != null && this.value.indexOf(34) > 0) {
            this.errors.add("value", new ActionError("users.error.quotes"));
        }
        if (this.description != null && this.description.indexOf(34) > 0) {
            this.errors.add("description", new ActionError("users.error.quotes"));
        }
        boolean bl = this.override = request.getParameter("override") != null;
        if (this.validateType(this.entryType, this.value)) {
            this.errors.add("value", new ActionError("resources.error.value.mismatch"));
        }
        return this.errors;
    }

    private boolean validateType(String entryType, String value) {
        Class<?> cls = null;
        boolean mismatch = false;
        try {
            cls = Class.forName(entryType);
            if ((class$java$lang$Character == null ? (class$java$lang$Character = EnvEntryForm.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(cls)) {
                if (value.length() != 1) {
                    mismatch = true;
                }
            } else if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = EnvEntryForm.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(cls)) {
                if (!"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
                    mismatch = true;
                }
            } else if ((class$java$lang$Number == null ? (class$java$lang$Number = EnvEntryForm.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(cls)) {
                try {
                    Class[] parameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EnvEntryForm.class$("java.lang.String")) : class$java$lang$String};
                    Constructor<?> ct = cls.getConstructor(parameterTypes);
                    Object[] arglist1 = new Object[]{value};
                    Object retobj = ct.newInstance(arglist1);
                }
                catch (Exception e) {
                    mismatch = true;
                }
            } else if (!(class$java$lang$String == null ? (class$java$lang$String = EnvEntryForm.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(cls)) {
                this.errors.add("entryType", new ActionError("resources.error.entryType.notimpl"));
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.errors.add("entryType", new ActionError("resources.error.entryType.invalid"));
        }
        return mismatch;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        typeVals.add(new LabelValueBean("java.lang.Boolean", "java.lang.Boolean"));
        typeVals.add(new LabelValueBean("java.lang.Byte", "java.lang.Byte"));
        typeVals.add(new LabelValueBean("java.lang.Character", "java.lang.Character"));
        typeVals.add(new LabelValueBean("java.lang.Double", "java.lang.Double"));
        typeVals.add(new LabelValueBean("java.lang.Float", "java.lang.Float"));
        typeVals.add(new LabelValueBean("java.lang.Integer", "java.lang.Integer"));
        typeVals.add(new LabelValueBean("java.lang.Long", "java.lang.Long"));
        typeVals.add(new LabelValueBean("java.lang.Short", "java.lang.Short"));
        typeVals.add(new LabelValueBean("java.lang.String", "java.lang.String"));
    }
}

