/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.io.IOException;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.resources.UserDatabasesForm;

public final class DeleteUserDatabasesAction
extends Action {
    private MBeanServer mserver = null;
    private MessageResources resources = null;

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        if (this.resources == null) {
            this.resources = this.getServlet().getResources();
        }
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (this.isCancelled(request)) {
            return mapping.findForward("List UserDatabases Setup");
        }
        if (!this.isTokenValid(request)) {
            response.sendError(400, this.resources.getMessage(locale, "users.error.token"));
            return null;
        }
        UserDatabasesForm userDatabasesForm = (UserDatabasesForm)form;
        String[] userDatabases = userDatabasesForm.getUserDatabases();
        if (userDatabases == null) {
            userDatabases = new String[]{};
        }
        try {
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new String[1];
            for (int i = 0; i < userDatabases.length; ++i) {
                ObjectName oname = new ObjectName(userDatabases[i]);
                ObjectName dname = new ObjectName(oname.getDomain() + ":type=NamingResources" + ",resourcetype=Global");
                params[0] = oname.getKeyProperty("name");
                this.mserver.invoke(dname, "removeResource", params, signature);
            }
        }
        catch (Throwable t) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.invoke", (Object)"removeResource"), t);
            response.sendError(500, this.resources.getMessage(locale, "users.error.invoke", (Object)"removeResource"));
            return null;
        }
        return mapping.findForward("UserDatabases List Setup");
    }
}

