/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.realm;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.TomcatTreeBuilder;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;
import org.apache.webapp.admin.logger.DeleteLoggerAction;
import org.apache.webapp.admin.realm.DataSourceRealmForm;

public final class SaveDataSourceRealmAction
extends Action {
    private String[] createDataSourceRealmTypes = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
    private MBeanServer mBServer = null;
    private MessageResources resources = null;

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (this.resources == null) {
            this.resources = this.getServlet().getResources();
        }
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        DataSourceRealmForm rform = (DataSourceRealmForm)form;
        String adminAction = rform.getAdminAction();
        String rObjectName = rform.getObjectName();
        if ("Create".equals(adminAction)) {
            String operation = null;
            Object[] values = null;
            try {
                String parent = rform.getParentObjectName();
                String objectName = DeleteLoggerAction.getObjectName(parent, ":type=Realm");
                ObjectName pname = new ObjectName(parent);
                StringBuffer sb = new StringBuffer(pname.getDomain());
                try {
                    if ("Service".equalsIgnoreCase(pname.getKeyProperty("type"))) {
                        sb.append(":type=Engine");
                        parent = sb.toString();
                    }
                }
                catch (Exception e) {
                    String message = this.resources.getMessage(locale, "error.engineName.bad", (Object)sb.toString());
                    this.getServlet().log(message);
                    response.sendError(400, message);
                    return null;
                }
                ObjectName oname = new ObjectName(objectName);
                if (this.mBServer.isRegistered(oname)) {
                    ActionErrors errors = new ActionErrors();
                    errors.add("realmName", new ActionError("error.realmName.exists"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                String domain = oname.getDomain();
                ObjectName fname = TomcatTreeBuilder.getMBeanFactory();
                values = new String[]{parent, rform.getDataSourceName(), rform.getRoleNameCol(), rform.getUserCredCol(), rform.getUserNameCol(), rform.getUserRoleTable(), rform.getUserTable()};
                operation = "createDataSourceRealm";
                rObjectName = (String)this.mBServer.invoke(fname, operation, values, this.createDataSourceRealmTypes);
                if (rObjectName == null) {
                    request.setAttribute("warning", (Object)"error.datasourcerealm");
                    return mapping.findForward("Save Unsuccessful");
                }
                TreeControl control = (TreeControl)session.getAttribute("treeControlTest");
                if (control != null) {
                    TreeControlNode parentNode = control.findNode(rform.getParentObjectName());
                    if (parentNode != null) {
                        String nodeLabel = rform.getNodeLabel();
                        String encodedName = URLEncoder.encode(rObjectName);
                        TreeControlNode childNode = new TreeControlNode(rObjectName, "Realm.gif", nodeLabel, "EditRealm.do?select=" + encodedName, "content", true, domain);
                        parentNode.addChild(childNode);
                    } else {
                        this.getServlet().log("Cannot find parent node '" + parent + "'");
                    }
                } else {
                    this.getServlet().log("Cannot find TreeControlNode!");
                }
            }
            catch (Exception e) {
                this.getServlet().log(this.resources.getMessage(locale, "users.error.invoke", operation), (Throwable)e);
                response.sendError(500, this.resources.getMessage(locale, "users.error.invoke", operation));
                return null;
            }
        }
        String attribute = null;
        try {
            ObjectName roname = new ObjectName(rObjectName);
            attribute = "debug";
            int debug = 0;
            try {
                debug = Integer.parseInt(rform.getDebugLvl());
            }
            catch (Throwable t) {
                debug = 0;
            }
            this.mBServer.setAttribute(roname, new Attribute("debug", new Integer(debug)));
            attribute = "dataSourceName";
            this.mBServer.setAttribute(roname, new Attribute(attribute, rform.getDataSourceName()));
            attribute = "digest";
            this.mBServer.setAttribute(roname, new Attribute("digest", rform.getDigest()));
            attribute = "roleNameCol";
            this.mBServer.setAttribute(roname, new Attribute("roleNameCol", rform.getRoleNameCol()));
            attribute = "userCredCol";
            this.mBServer.setAttribute(roname, new Attribute("userCredCol", rform.getUserCredCol()));
            attribute = "userNameCol";
            this.mBServer.setAttribute(roname, new Attribute("userNameCol", rform.getUserNameCol()));
            attribute = "userRoleTable";
            this.mBServer.setAttribute(roname, new Attribute("userRoleTable", rform.getUserRoleTable()));
            attribute = "userTable";
            this.mBServer.setAttribute(roname, new Attribute("userTable", rform.getUserTable()));
        }
        catch (Exception e) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.attribute.set", (Object)attribute), (Throwable)e);
            response.sendError(500, this.resources.getMessage(locale, "users.error.attribute.set", (Object)attribute));
            return null;
        }
        session.removeAttribute(mapping.getAttribute());
        return mapping.findForward("Save Successful");
    }
}

