/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.datasource;

import javax.naming.NamingException;
import org.apache.jetspeed.components.datasource.DBCPDatasourceComponent;
import org.apache.jetspeed.components.jndi.JNDIComponent;

public class BoundDBCPDatasourceComponent
extends DBCPDatasourceComponent {
    private JNDIComponent jndi;
    private String bindName;

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public BoundDBCPDatasourceComponent(String user, String password, String driverName, String connectURI, int maxActive, int maxWait, byte whenExhausted, boolean autoCommit, String bindName, JNDIComponent jndi) {
        super(user, password, driverName, connectURI, maxActive, maxWait, whenExhausted, autoCommit);
        if (jndi == null) {
            throw new IllegalArgumentException("jndi argument cannot be null for BoundDBCPDatasourceComponent");
        }
        if (bindName == null) {
            throw new IllegalArgumentException("bindName argument cannot be null for BoundDBCPDatasourceComponent");
        }
        this.jndi = jndi;
        this.bindName = bindName;
    }

    public void start() {
        super.start();
        try {
            this.jndi.bindObject("comp/env/jdbc/" + this.bindName, this.getDatasource());
            this.jndi.bindObject("jdbc/" + this.bindName, this.getDatasource());
        }
        catch (NamingException e) {
            IllegalStateException ise = new IllegalStateException("Naming exception " + e.toString());
            ise.initCause(e);
            throw ise;
        }
    }

    public void stop() {
        try {
            this.jndi.unbindObject("comp/env/jdbc/" + this.bindName);
            this.jndi.unbindObject("jdbc/" + this.bindName);
        }
        catch (NamingException e) {
            throw new IllegalStateException("Naming exception " + e.toString());
        }
        super.stop();
    }
}

