/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class LockableFileWriter
extends Writer {
    private static final String LCK = ".lck";
    private File lockFile = null;
    private FileWriter writer = null;
    private boolean append = false;
    static /* synthetic */ Class class$org$apache$commons$io$LockableFileWriter;

    public LockableFileWriter(File file) throws IOException {
        this(file, false, null);
    }

    public LockableFileWriter(File file, boolean append) throws IOException {
        this(file, append, null);
    }

    public LockableFileWriter(File file, boolean append, String lockDir) throws IOException {
        this.append = append;
        if (lockDir == null) {
            lockDir = System.getProperty("java.io.tmpdir");
        }
        this.testLockDir(new File(lockDir));
        this.lockFile = new File(lockDir, String.valueOf(file.getName()) + LCK);
        this.createLock();
        this.writer = new FileWriter(file.getAbsolutePath(), this.append);
    }

    public LockableFileWriter(String fileName) throws IOException {
        this(fileName, false, null);
    }

    public LockableFileWriter(String fileName, boolean append) throws IOException {
        this(fileName, append, null);
    }

    public LockableFileWriter(String fileName, boolean append, String lockDir) throws IOException {
        this(new File(fileName), append, lockDir);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() throws IOException {
        try {
            this.writer.close();
        }
        finally {
            Object var2_1 = null;
            this.lockFile.delete();
        }
    }

    private void createLock() throws IOException {
        Class clazz = class$org$apache$commons$io$LockableFileWriter != null ? class$org$apache$commons$io$LockableFileWriter : (class$org$apache$commons$io$LockableFileWriter = LockableFileWriter.class$("org.apache.commons.io.LockableFileWriter"));
        synchronized (clazz) {
            if (!this.lockFile.createNewFile()) {
                throw new IOException("Can't write file, lock " + this.lockFile.getAbsolutePath() + " exists");
            }
            this.lockFile.deleteOnExit();
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    private void testLockDir(File lockDir) throws IOException {
        if (!lockDir.exists()) {
            throw new IOException("Could not find lockDir: " + lockDir.getAbsolutePath());
        }
        if (!lockDir.canWrite()) {
            throw new IOException("Could not write to lockDir: " + lockDir.getAbsolutePath());
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }
}

