/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;

public class FileUtils {
    public static final int ONE_KB = 1024;
    public static final int ONE_MB = 0x100000;
    public static final int ONE_GB = 0x40000000;

    public static String basename(String filename) {
        return FileUtils.basename(filename, FileUtils.extension(filename));
    }

    public static String basename(String filename, String suffix) {
        int lastDot;
        int i = filename.lastIndexOf(File.separator) + 1;
        int n = lastDot = suffix != null && suffix.length() > 0 ? filename.lastIndexOf(suffix) : -1;
        if (lastDot >= 0) {
            return filename.substring(i, lastDot);
        }
        if (i > 0) {
            return filename.substring(i);
        }
        return filename;
    }

    private static Vector blendFilesToVector(Vector v, String[] files) {
        int i = 0;
        while (i < files.length) {
            v.addElement(files[i]);
            ++i;
        }
        return v;
    }

    public static String byteCountToDisplaySize(int size) {
        String displaySize = size / 0x40000000 > 0 ? String.valueOf(String.valueOf(size / 0x40000000)) + " GB" : (size / 0x100000 > 0 ? String.valueOf(String.valueOf(size / 0x100000)) + " MB" : (size / 1024 > 0 ? String.valueOf(String.valueOf(size / 1024)) + " KB" : String.valueOf(String.valueOf(size)) + " bytes"));
        return displaySize;
    }

    public static String dirname(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(0, i) : "";
    }

    public static String extension(String filename) {
        int lastDot = filename.lastIndexOf(46);
        if (lastDot >= 0) {
            return filename.substring(lastDot + 1);
        }
        return "";
    }

    public static void fileDelete(String fileName) {
        File file = new File(fileName);
        file.delete();
    }

    public static boolean fileExists(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public static String fileRead(String fileName) throws Exception {
        int count;
        StringBuffer buf = new StringBuffer();
        FileInputStream in = new FileInputStream(fileName);
        byte[] b = new byte[512];
        while ((count = in.read(b)) > 0) {
            buf.append(new String(b, 0, count));
        }
        in.close();
        return buf.toString();
    }

    public static void fileWrite(String fileName, String data) throws Exception {
        FileOutputStream out = new FileOutputStream(fileName);
        out.write(data.getBytes());
        out.close();
    }

    public static String filename(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(i + 1) : filename;
    }

    public static File getFile(String fileName) {
        return new File(fileName);
    }

    public static String[] getFilesFromExtension(String directory, String[] extensions) {
        Vector files = new Vector();
        File currentDir = new File(directory);
        String[] unknownFiles = currentDir.list();
        if (unknownFiles == null) {
            return new String[0];
        }
        int i = 0;
        while (i < unknownFiles.length) {
            String currentFileName = String.valueOf(directory) + System.getProperty("file.separator") + unknownFiles[i];
            File currentFile = new File(currentFileName);
            if (currentFile.isDirectory()) {
                if (!currentFile.getName().equals("CVS")) {
                    String[] fetchFiles = FileUtils.getFilesFromExtension(currentFileName, extensions);
                    files = FileUtils.blendFilesToVector(files, fetchFiles);
                }
            } else {
                String add = currentFile.getAbsolutePath();
                if (FileUtils.isValidFile(add, extensions)) {
                    files.addElement(add);
                }
            }
            ++i;
        }
        Object[] foundFiles = new String[files.size()];
        files.copyInto(foundFiles);
        return foundFiles;
    }

    private static boolean isValidFile(String file, String[] extensions) {
        String extension = FileUtils.extension(file);
        if (extension == null) {
            extension = "";
        }
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].equals(extension)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void mkdir(String dir) {
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static boolean waitFor(String fileName, int seconds) {
        File file = new File(fileName);
        int timeout = 0;
        int tick = 0;
        while (!file.exists()) {
            if (tick++ >= 10) {
                tick = 0;
                if (timeout++ > seconds) {
                    return false;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                break;
            }
        }
        return true;
    }
}

