/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core.impl;

import java.util.Enumeration;
import java.util.Vector;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import javax.portlet.PortletSessionUtil;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.pluto.factory.PortletObjectAccess;
import org.apache.pluto.om.window.PortletWindow;

public class PortletSessionImpl
implements PortletSession,
HttpSession {
    private final int DEFAULT_SCOPE = 2;
    private HttpSession httpSession;
    private PortletContext portletContext = null;
    private PortletWindow portletWindow;

    public PortletSessionImpl(PortletWindow portletWindow, HttpSession httpSession) {
        this.portletWindow = portletWindow;
        this.httpSession = httpSession;
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 2);
    }

    public Enumeration getAttributeNames() {
        return this.getAttributeNames(2);
    }

    public long getCreationTime() throws IllegalStateException {
        return this.httpSession.getCreationTime();
    }

    public String getId() throws IllegalStateException {
        return this.httpSession.getId();
    }

    public long getLastAccessedTime() throws IllegalStateException {
        return this.httpSession.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.httpSession.getMaxInactiveInterval();
    }

    public void invalidate() throws IllegalStateException {
        this.httpSession.invalidate();
    }

    public boolean isNew() throws IllegalStateException {
        return this.httpSession.isNew();
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, 2);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 2);
    }

    public void setMaxInactiveInterval(int interval) {
        this.httpSession.setMaxInactiveInterval(interval);
    }

    public Object getAttribute(String name, int scope) throws IllegalStateException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (scope == 1) {
            return this.httpSession.getAttribute(name);
        }
        Object attribute = this.httpSession.getAttribute("javax.portlet.p." + this.portletWindow.getId() + "?" + name);
        if (attribute == null) {
            attribute = this.httpSession.getAttribute(name);
        }
        return attribute;
    }

    public Enumeration getAttributeNames(int scope) {
        if (scope == 1) {
            return this.httpSession.getAttributeNames();
        }
        Enumeration attributes = this.httpSession.getAttributeNames();
        Vector<String> portletAttributes = new Vector<String>();
        int prefix_length = "javax.portlet.p.".length();
        String portletWindowId = this.portletWindow.getId().toString();
        while (attributes.hasMoreElements()) {
            String portletAttribute;
            String attribute = (String)attributes.nextElement();
            int attributeScope = PortletSessionUtil.decodeScope((String)attribute);
            if (attributeScope != 2 || !attribute.startsWith(portletWindowId, prefix_length) || (portletAttribute = PortletSessionUtil.decodeAttributeName((String)attribute)) == null) continue;
            portletAttributes.add(portletAttribute);
        }
        return portletAttributes.elements();
    }

    public void removeAttribute(String name, int scope) throws IllegalStateException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (scope == 1) {
            this.httpSession.removeAttribute(name);
        } else {
            this.httpSession.removeAttribute("javax.portlet.p." + this.portletWindow.getId() + "?" + name);
        }
    }

    public void setAttribute(String name, Object value, int scope) throws IllegalStateException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (scope == 1) {
            this.httpSession.setAttribute(name, value);
        } else {
            this.httpSession.setAttribute("javax.portlet.p." + this.portletWindow.getId() + "?" + name, value);
        }
    }

    public PortletContext getPortletContext() {
        return this.getInternalPortletContext();
    }

    public ServletContext getServletContext() {
        return this.httpSession.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        return this.httpSession.getSessionContext();
    }

    public Object getValue(String name) {
        return this.getAttribute(name, 2);
    }

    public String[] getValueNames() {
        return null;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value, 2);
    }

    public void removeValue(String name) {
        this.removeAttribute(name, 2);
    }

    private synchronized PortletContext getInternalPortletContext() {
        if (this.portletContext == null) {
            this.portletContext = PortletObjectAccess.getPortletContext(this.getServletContext(), this.portletWindow.getPortletEntity().getPortletApplicationEntity().getPortletApplicationDefinition());
        }
        return this.portletContext;
    }
}

