/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto;

import java.util.HashMap;
import java.util.Stack;
import org.apache.pluto.services.ContainerService;
import org.apache.pluto.services.PortletContainerEnvironment;

public class PortletContainerServices {
    private static ThreadLocal currentContainerService = new StackedThreadLocal();
    private static ThreadLocal currentUniqueContainerName = new StackedThreadLocal();
    private static HashMap containerServices = new HashMap();

    public static ContainerService get(Class service) {
        Stack currentContainerServiceStack = (Stack)currentContainerService.get();
        if (currentContainerServiceStack.isEmpty()) {
            throw new IllegalStateException("The prepare method was never called");
        }
        PortletContainerEnvironment environment = (PortletContainerEnvironment)currentContainerServiceStack.peek();
        if (environment == null) {
            throw new IllegalStateException("The prepare method was never called");
        }
        return environment.getContainerService(service);
    }

    public static String getUniqueContainerName() {
        Stack currentNameStack = (Stack)currentUniqueContainerName.get();
        if (currentNameStack.isEmpty()) {
            throw new IllegalStateException("The prepare method was never called");
        }
        return (String)currentNameStack.peek();
    }

    public static synchronized void createReference(String uniqueContainerName, PortletContainerEnvironment environment) {
        if (containerServices.containsKey(uniqueContainerName)) {
            throw new IllegalArgumentException("The given container name is not unique: " + uniqueContainerName);
        }
        containerServices.put(uniqueContainerName, environment);
    }

    public static synchronized void destroyReference(String uniqueContainerName) {
        containerServices.remove(uniqueContainerName);
    }

    public static synchronized void prepare(String uniqueContainerName) {
        Stack currentContainerServiceStack = (Stack)currentContainerService.get();
        currentContainerServiceStack.push(containerServices.get(uniqueContainerName));
        Stack currentNameStack = (Stack)currentUniqueContainerName.get();
        currentNameStack.push(uniqueContainerName);
    }

    public static void release() {
        Stack currentNameStack;
        Stack currentContainerServiceStack = (Stack)currentContainerService.get();
        if (!currentContainerServiceStack.isEmpty()) {
            currentContainerServiceStack.pop();
        }
        if (!(currentNameStack = (Stack)currentUniqueContainerName.get()).isEmpty()) {
            currentNameStack.pop();
        }
    }

    private static class StackedThreadLocal
    extends ThreadLocal {
        private StackedThreadLocal() {
        }

        public Object initialValue() {
            return new Stack();
        }
    }
}

