/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.copy;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.util.IdentityMapFactory;
import org.apache.ojb.otm.copy.ObjectCopyException;
import org.apache.ojb.otm.copy.ObjectCopyStrategy;
import org.apache.ojb.otm.copy.SerializeObjectCopyStrategy;

public final class ReflectiveObjectCopyStrategy
implements ObjectCopyStrategy {
    private static final Set FINAL_IMMUTABLE_CLASSES;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static final Class[] EMPTY_CLASS_ARRAY;
    private static final SerializeObjectCopyStrategy _serialize;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public final Object copy(Object toCopy, PersistenceBroker broker) {
        return ReflectiveObjectCopyStrategy.clone(toCopy, IdentityMapFactory.getIdentityMap(), new HashMap());
    }

    private static Object clone(Object toCopy, Map objMap, Map metadataMap) {
        Object retval;
        if (objMap.containsKey(toCopy)) {
            return objMap.get(toCopy);
        }
        Class<?> objClass = toCopy.getClass();
        if (objClass.isArray()) {
            retval = ReflectiveObjectCopyStrategy.handleArray(toCopy, objMap, objClass, metadataMap);
        } else if (FINAL_IMMUTABLE_CLASSES.contains(objClass)) {
            objMap.put(toCopy, toCopy);
            retval = toCopy;
        } else {
            retval = ReflectiveObjectCopyStrategy.handleObjectWithNoArgsConstructor(metadataMap, objClass, objMap, toCopy);
        }
        return retval;
    }

    private static Object handleObjectWithNoArgsConstructor(Map metadataMap, Class objClass, Map objMap, Object toCopy) {
        Object retval = null;
        ClassMetadata metadata = (ClassMetadata)metadataMap.get(objClass);
        if (metadata == null) {
            metadata = new ClassMetadata();
            metadataMap.put(objClass, metadata);
        }
        Constructor noArg = metadata.m_noArgConstructor;
        if (metadata.m_hasNoArgConstructor && noArg == null) {
            try {
                metadata.m_noArgConstructor = noArg = objClass.getDeclaredConstructor(EMPTY_CLASS_ARRAY);
            }
            catch (Exception e) {
                metadata.m_hasNoArgConstructor = false;
            }
        }
        if (metadata.m_hasNoArgConstructor) {
            if (!metadata.m_noArgConstructorAccessible && (1 & noArg.getModifiers()) == 0) {
                try {
                    noArg.setAccessible(true);
                }
                catch (SecurityException e) {
                    throw new ObjectCopyException("cannot access noArg constructor [" + noArg + "] of class [" + objClass.getName() + "]: " + e.toString(), e);
                }
                metadata.m_noArgConstructorAccessible = true;
            }
            try {
                retval = noArg.newInstance(EMPTY_OBJECT_ARRAY);
                objMap.put(toCopy, retval);
            }
            catch (Exception e) {
                throw new ObjectCopyException("cannot instantiate class [" + objClass.getName() + "] using noArg constructor: " + e.toString(), e);
            }
            for (Class c = objClass; c != (class$java$lang$Object == null ? ReflectiveObjectCopyStrategy.class$("java.lang.Object") : class$java$lang$Object); c = c.getSuperclass()) {
                ReflectiveObjectCopyStrategy.copyClass(metadataMap, c, toCopy, retval, objMap);
            }
        } else {
            retval = _serialize.copy(toCopy, null);
        }
        return retval;
    }

    private static void copyClass(Map metadataMap, Class c, Object obj, Object retval, Map objMap) {
        Field[] declaredFields;
        ClassMetadata metadata = (ClassMetadata)metadataMap.get(c);
        if (metadata == null) {
            metadata = new ClassMetadata();
            metadataMap.put(c, metadata);
        }
        if ((declaredFields = metadata.m_declaredFields) == null) {
            declaredFields = c.getDeclaredFields();
            metadata.m_declaredFields = declaredFields;
        }
        ReflectiveObjectCopyStrategy.setFields(obj, retval, declaredFields, metadata.m_fieldsAccessible, objMap, metadataMap);
        metadata.m_fieldsAccessible = true;
    }

    private static Object handleArray(Object obj, Map objMap, Class objClass, Map metadataMap) {
        Object retval;
        int arrayLength = Array.getLength(obj);
        if (arrayLength == 0) {
            objMap.put(obj, obj);
            retval = obj;
        } else {
            Class<?> componentType = objClass.getComponentType();
            retval = Array.newInstance(componentType, arrayLength);
            objMap.put(obj, retval);
            if (componentType.isPrimitive() || FINAL_IMMUTABLE_CLASSES.contains(componentType)) {
                System.arraycopy(obj, 0, retval, 0, arrayLength);
            } else {
                for (int i = 0; i < arrayLength; ++i) {
                    Object slot = Array.get(obj, i);
                    if (slot == null) continue;
                    Object slotClone = ReflectiveObjectCopyStrategy.clone(slot, objMap, metadataMap);
                    Array.set(retval, i, slotClone);
                }
            }
        }
        return retval;
    }

    private static void setFields(Object from, Object to, Field[] fields, boolean accessible, Map objMap, Map metadataMap) {
        int fieldsLength = fields.length;
        for (int f = 0; f < fieldsLength; ++f) {
            Field field = fields[f];
            int modifiers = field.getModifiers();
            if ((8 & modifiers) != 0) continue;
            if ((0x10 & modifiers) != 0) {
                throw new ObjectCopyException("cannot set final field [" + field.getName() + "] of class [" + from.getClass().getName() + "]");
            }
            if (!accessible && (1 & modifiers) == 0) {
                try {
                    field.setAccessible(true);
                }
                catch (SecurityException e) {
                    throw new ObjectCopyException("cannot access field [" + field.getName() + "] of class [" + from.getClass().getName() + "]: " + e.toString(), e);
                }
            }
            try {
                ReflectiveObjectCopyStrategy.cloneAndSetFieldValue(field, from, to, objMap, metadataMap);
                continue;
            }
            catch (Exception e) {
                throw new ObjectCopyException("cannot set field [" + field.getName() + "] of class [" + from.getClass().getName() + "]: " + e.toString(), e);
            }
        }
    }

    private static void cloneAndSetFieldValue(Field field, Object src, Object dest, Map objMap, Map metadataMap) throws IllegalAccessException {
        Object value = field.get(src);
        if (value == null) {
            field.set(dest, null);
        } else {
            Class<?> valueType = value.getClass();
            if (!valueType.isPrimitive() && !FINAL_IMMUTABLE_CLASSES.contains(valueType)) {
                value = ReflectiveObjectCopyStrategy.clone(value, objMap, metadataMap);
            }
            field.set(dest, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        EMPTY_OBJECT_ARRAY = new Object[0];
        EMPTY_CLASS_ARRAY = new Class[0];
        _serialize = new SerializeObjectCopyStrategy();
        FINAL_IMMUTABLE_CLASSES = new HashSet(17);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$String == null ? (class$java$lang$String = ReflectiveObjectCopyStrategy.class$("java.lang.String")) : class$java$lang$String);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Byte == null ? (class$java$lang$Byte = ReflectiveObjectCopyStrategy.class$("java.lang.Byte")) : class$java$lang$Byte);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Short == null ? (class$java$lang$Short = ReflectiveObjectCopyStrategy.class$("java.lang.Short")) : class$java$lang$Short);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Integer == null ? (class$java$lang$Integer = ReflectiveObjectCopyStrategy.class$("java.lang.Integer")) : class$java$lang$Integer);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Long == null ? (class$java$lang$Long = ReflectiveObjectCopyStrategy.class$("java.lang.Long")) : class$java$lang$Long);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Float == null ? (class$java$lang$Float = ReflectiveObjectCopyStrategy.class$("java.lang.Float")) : class$java$lang$Float);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Double == null ? (class$java$lang$Double = ReflectiveObjectCopyStrategy.class$("java.lang.Double")) : class$java$lang$Double);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Character == null ? (class$java$lang$Character = ReflectiveObjectCopyStrategy.class$("java.lang.Character")) : class$java$lang$Character);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ReflectiveObjectCopyStrategy.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    private static final class ClassMetadata {
        Constructor m_noArgConstructor;
        Field[] m_declaredFields;
        boolean m_noArgConstructorAccessible;
        boolean m_fieldsAccessible;
        boolean m_hasNoArgConstructor = true;

        private ClassMetadata() {
        }
    }
}

