/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.states;

import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.ObjectModificationDefaultImpl;
import org.apache.ojb.odmg.ObjectEnvelope;
import org.apache.ojb.odmg.states.ModificationState;
import org.apache.ojb.odmg.states.StateNewDelete;
import org.apache.ojb.odmg.states.StateNewDirty;
import org.apache.ojb.odmg.states.StateOldClean;

public class StateNewClean
extends ModificationState {
    private static StateNewClean _instance = new StateNewClean();

    private StateNewClean() {
    }

    public static StateNewClean getInstance() {
        return _instance;
    }

    public ModificationState markClean() {
        return this;
    }

    public ModificationState markDelete() {
        return StateNewDelete.getInstance();
    }

    public ModificationState markDirty() {
        return StateNewDirty.getInstance();
    }

    public ModificationState markNew() {
        return this;
    }

    public ModificationState markOld() {
        return StateOldClean.getInstance();
    }

    public boolean needsInsert() {
        return true;
    }

    public void checkpoint(ObjectEnvelope mod, PersistenceBroker broker) throws PersistenceBrokerException {
        broker.store(mod.getObject(), ObjectModificationDefaultImpl.INSERT);
        mod.refreshObjectImage();
        mod.setModificationState(StateOldClean.getInstance());
    }

    public void commit(ObjectEnvelope mod, PersistenceBroker broker) throws PersistenceBrokerException {
        broker.store(mod.getObject(), ObjectModificationDefaultImpl.INSERT);
        mod.refreshObjectImage();
        mod.setModificationState(StateOldClean.getInstance());
    }

    public void rollback(ObjectEnvelope mod, PersistenceBroker broker) {
        this.removeFromCache(mod.getObject(), broker);
    }
}

