/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.odmg.locking.InMemoryLockMapImpl;
import org.apache.ojb.odmg.locking.LockEntry;

public class LockServerServlet
extends HttpServlet {
    private static int numRequests;
    private static InMemoryLockMapImpl lockmap;
    private static Throwable lastError;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setHeader("Pragma", "no-cache");
        PrintWriter out = response.getWriter();
        out.println("<html><head><title>OJB Distributed Locking Servlet Status Page</title>");
        out.println("</head><body><h1>OJB Distributed Locking Servlet</h1>");
        out.println("The servlet is running.<p>");
        if (lastError == null) {
            out.println("The LockServer is running.<p>");
            out.println("Persistent Locks: " + lockmap.getSize() + "<p>");
            out.println("Processed Lock Request: " + numRequests + "<p>");
        } else {
            out.println("<h2>The LockServer has a problem!</h2>");
            out.println("The error message is:<p>");
            out.println(lastError.getMessage() + "<p>");
            lastError.printStackTrace(out);
            lastError = null;
        }
        out.println("</body></html>");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ++numRequests;
        try {
            byte[] req = this.getRequestByteArray(request);
            byte selector = req[0];
            byte[] data = new byte[req.length - 1];
            System.arraycopy(req, 1, data, 0, data.length);
            Object result = null;
            switch (selector) {
                case 119: {
                    result = this.getWriter(data);
                    break;
                }
                case 114: {
                    result = this.getAllReaders(data);
                    break;
                }
                case 97: {
                    try {
                        result = this.addReader(data);
                    }
                    catch (Throwable t) {
                        result = Boolean.FALSE;
                    }
                    break;
                }
                case 101: {
                    try {
                        result = this.removeReader(data);
                    }
                    catch (Throwable t) {
                        result = Boolean.FALSE;
                    }
                    break;
                }
                case 109: {
                    try {
                        result = this.removeWriter(data);
                    }
                    catch (Throwable t) {
                        result = Boolean.FALSE;
                    }
                    break;
                }
                case 117: {
                    try {
                        result = this.upgradeLock(data);
                    }
                    catch (Throwable t) {
                        result = Boolean.FALSE;
                    }
                }
                case 115: {
                    try {
                        result = this.setWriter(data);
                    }
                    catch (Throwable t) {
                        result = Boolean.FALSE;
                    }
                    break;
                }
                case 104: {
                    try {
                        result = this.hasReadLock(data);
                    }
                    catch (Throwable t) {
                        result = Boolean.FALSE;
                    }
                    break;
                }
                default: {
                    result = new PersistenceBrokerException("unknown command:" + selector);
                }
            }
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)response.getOutputStream());
            oos.writeObject(result);
            oos.flush();
            oos.close();
        }
        catch (Throwable t) {
            lastError = t;
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    private LockEntry getWriter(byte[] data) throws IOException, ClassNotFoundException {
        Identity oid = (Identity)this.deserialize(data);
        LockEntry entry = lockmap.getWriter(oid);
        return entry;
    }

    private Collection getAllReaders(byte[] data) throws IOException, ClassNotFoundException {
        Identity oid = (Identity)this.deserialize(data);
        Collection readers = lockmap.getReaders(oid);
        return new ArrayList(readers);
    }

    private Boolean addReader(byte[] data) throws IOException, ClassNotFoundException {
        Boolean result = Boolean.TRUE;
        LockEntry lock = (LockEntry)this.deserialize(data);
        try {
            lockmap.addReaderInternal(lock);
        }
        catch (Throwable t) {
            result = Boolean.FALSE;
        }
        return result;
    }

    private Boolean removeReader(byte[] data) throws IOException, ClassNotFoundException {
        Boolean result = Boolean.TRUE;
        LockEntry lock = (LockEntry)this.deserialize(data);
        try {
            lockmap.removeReaderByLock(lock);
        }
        catch (Throwable t) {
            result = Boolean.FALSE;
        }
        return result;
    }

    private Boolean removeWriter(byte[] data) throws IOException, ClassNotFoundException {
        Boolean result = Boolean.TRUE;
        LockEntry lock = (LockEntry)this.deserialize(data);
        try {
            lockmap.removeWriter(lock);
        }
        catch (Throwable t) {
            result = Boolean.FALSE;
        }
        return result;
    }

    private Boolean upgradeLock(byte[] data) throws IOException, ClassNotFoundException {
        Boolean result = Boolean.TRUE;
        LockEntry lock = (LockEntry)this.deserialize(data);
        try {
            lockmap.upgradeLock(lock);
        }
        catch (Throwable t) {
            result = Boolean.FALSE;
        }
        return result;
    }

    private Boolean setWriter(byte[] data) throws IOException, ClassNotFoundException {
        Boolean result = Boolean.TRUE;
        LockEntry lock = (LockEntry)this.deserialize(data);
        try {
            lockmap.setWriterByLock(lock);
        }
        catch (Throwable t) {
            result = Boolean.FALSE;
        }
        return result;
    }

    private Boolean hasReadLock(byte[] data) throws IOException, ClassNotFoundException {
        Boolean result = Boolean.TRUE;
        LockEntry lock = (LockEntry)this.deserialize(data);
        try {
            lockmap.hasReadLock(lock);
        }
        catch (Throwable t) {
            result = Boolean.FALSE;
        }
        return result;
    }

    private Object deserialize(byte[] anArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(anArray);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object result = ois.readObject();
        ois.close();
        bais.close();
        return result;
    }

    private byte[] getRequestByteArray(HttpServletRequest request) throws IOException {
        ServletInputStream is = request.getInputStream();
        byte[] block = new byte[4096];
        byte[] req = null;
        int len = 0;
        len = is.read(block, 0, block.length);
        if (len <= 0) {
            return null;
        }
        req = new byte[len];
        System.arraycopy(block, 0, req, 0, len);
        while (len > 0 && (len = is.read(block, 0, block.length)) > 0) {
            byte[] fresh = new byte[req.length + len];
            System.arraycopy(req, 0, fresh, 0, req.length);
            System.arraycopy(block, 0, fresh, req.length, len);
            req = fresh;
        }
        return req;
    }

    static {
        lockmap = new InMemoryLockMapImpl();
        lastError = null;
    }
}

