/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionExt;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListEntry_2;
import org.apache.ojb.odmg.collections.DListIterator_2;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DArray;
import org.odmg.DCollection;
import org.odmg.DList;
import org.odmg.ODMGRuntimeException;
import org.odmg.QueryInvalidException;

public class DListImpl_2
extends AbstractList
implements DList,
DArray,
ManageableCollection,
PersistenceBrokerAware {
    private static final long serialVersionUID = -9219943066614026526L;
    private transient Logger log;
    private Integer id;
    private List elements = new ArrayList();
    private int size = 0;
    private PBKey pbKey;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DListImpl_2;

    public DListImpl_2() {
    }

    public DListImpl_2(PBKey pbKey) {
        this();
        this.pbKey = pbKey;
    }

    protected Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DListImpl_2 == null ? (class$org$apache$ojb$odmg$collections$DListImpl_2 = DListImpl_2.class$("org.apache.ojb.odmg.collections.DListImpl_2")) : class$org$apache$ojb$odmg$collections$DListImpl_2);
        }
        return this.log;
    }

    private DListEntry_2 prepareEntry(Object obj) {
        return new DListEntry_2(this, obj);
    }

    private boolean checkForOpenTransaction(TransactionExt tx) {
        boolean result = false;
        if (tx != null && tx.isOpen()) {
            result = true;
            if (this.pbKey == null) {
                this.pbKey = tx.getBroker().getPBKey();
            }
        }
        return result;
    }

    public PBKey getPBKey() {
        TransactionImpl tx;
        if (this.pbKey == null && (tx = TxManagerFactory.instance().getTransaction()) != null) {
            this.checkForOpenTransaction(tx);
        }
        return this.pbKey;
    }

    public void setPBKey(PBKey pbKey) {
        this.pbKey = pbKey;
    }

    public void add(int index, Object element) {
        DListEntry_2 entry = this.prepareEntry(element);
        this.elements.add(index, entry);
        ++this.size;
        TransactionImpl tx = TxManagerFactory.instance().getTransaction();
        if (this.checkForOpenTransaction(tx)) {
            tx.lock(this, 4);
            tx.lock(entry, 4);
            tx.lock(element, 1);
            entry.prepareForPersistency(tx.getBroker());
        }
        int offset = 0;
        try {
            offset = ((DListEntry_2)this.elements.get(index - 1)).getPosition();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        for (int i = offset; i < this.elements.size(); ++i) {
            entry = (DListEntry_2)this.elements.get(i);
            entry.setPosition(i);
        }
    }

    public Object remove(int index) {
        DListEntry_2 entry = (DListEntry_2)this.elements.get(index);
        TransactionImpl tx = TxManagerFactory.instance().getTransaction();
        if (this.checkForOpenTransaction(tx)) {
            tx.markDelete(entry);
        }
        --this.size;
        this.elements.remove(index);
        int offset = 0;
        try {
            offset = ((DListEntry_2)this.elements.get(index)).getPosition();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        for (int i = offset; i < this.elements.size(); ++i) {
            entry = (DListEntry_2)this.elements.get(i);
            entry.setPosition(i);
        }
        return entry.getRealSubject();
    }

    public DList concat(DList otherList) {
        DListImpl_2 result = new DListImpl_2(this.pbKey);
        result.addAll(this);
        result.addAll(otherList);
        return result;
    }

    public boolean existsElement(String predicate) throws QueryInvalidException {
        DList results = (DList)this.query(predicate);
        return results != null && results.size() != 0;
    }

    public Object get(int index) {
        DListEntry_2 entry = (DListEntry_2)this.elements.get(index);
        return entry.getRealSubject();
    }

    public List getElements() {
        return this.elements;
    }

    public Integer getId() {
        return this.id;
    }

    public Iterator iterator() {
        return new DListIterator_2(this);
    }

    public ListIterator listIterator() {
        return new DListIterator_2(this);
    }

    public ListIterator listIterator(int index) {
        return new DListIterator_2(this, index);
    }

    private Criteria getPkCriteriaForAllElements(PersistenceBroker brokerForClass) {
        try {
            Criteria crit = null;
            for (int i = 0; i < this.elements.size(); ++i) {
                DListEntry_2 entry = (DListEntry_2)this.elements.get(i);
                Object obj = entry.getRealSubject();
                ClassDescriptor cld = brokerForClass.getClassDescriptor(obj.getClass());
                FieldDescriptor[] pkFields = cld.getPkFields();
                ValueContainer[] pkValues = brokerForClass.serviceBrokerHelper().getKeyValues(cld, obj);
                Criteria criteria = new Criteria();
                for (int j = 0; j < pkFields.length; ++j) {
                    FieldDescriptor fld = pkFields[j];
                    criteria.addEqualTo(fld.getPersistentField().getName(), pkValues[j].getValue());
                }
                if (crit == null) {
                    crit = criteria;
                    continue;
                }
                crit.addOrCriteria(criteria);
            }
            return crit;
        }
        catch (PersistenceBrokerException e) {
            return null;
        }
    }

    private Class getElementsExtentClass(PersistenceBroker brokerForClass) throws PersistenceBrokerException {
        DListEntry_2 entry = (DListEntry_2)this.elements.get(0);
        Class<?> elementsClass = entry.getRealSubject().getClass();
        Class extentClass = brokerForClass.getTopLevelClass(elementsClass);
        return extentClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public DCollection query(String predicate) throws QueryInvalidException {
        void var8_13;
        String oql = "select all from java.lang.Object where " + predicate;
        OQLQueryImpl predicateQuery = new OQLQueryImpl(this.pbKey);
        predicateQuery.create(oql);
        Query pQ = predicateQuery.getQuery();
        Criteria pCrit = pQ.getCriteria();
        TransactionImpl tx = TxManagerFactory.instance().getTransaction();
        if (tx == null) {
            throw new QueryInvalidException("Need running transaction to do query");
        }
        PBCapsule handle = new PBCapsule(this.pbKey, tx);
        try {
            PersistenceBroker broker = handle.getBroker();
            Criteria allElementsCriteria = this.getPkCriteriaForAllElements(broker);
            allElementsCriteria.addAndCriteria(pCrit);
            Class clazz = null;
            try {
                clazz = this.getElementsExtentClass(broker);
            }
            catch (PersistenceBrokerException e) {
                throw new ODMGRuntimeException(e.getMessage());
            }
            QueryByCriteria q = new QueryByCriteria(clazz, allElementsCriteria);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug(((Object)q).toString());
            }
            DList result = null;
            try {
                result = (DList)((Object)broker.getCollectionByQuery(class$org$apache$ojb$odmg$collections$DListImpl_2 == null ? (class$org$apache$ojb$odmg$collections$DListImpl_2 = DListImpl_2.class$("org.apache.ojb.odmg.collections.DListImpl_2")) : class$org$apache$ojb$odmg$collections$DListImpl_2, q));
            }
            catch (PersistenceBrokerException e) {
                this.getLog().error("Query failed", (Throwable)((Object)e));
                throw new OJBRuntimeException((Throwable)((Object)e));
            }
        }
        finally {
            if (handle != null) {
                handle.destroy();
            }
        }
        return var8_13;
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this);
        buf.append("id", (Object)this.id);
        buf.append("pbKey", (Object)this.pbKey);
        buf.append("size", this.size);
        buf.append((Object)"[containing elements: ");
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            buf.append((Object)(obj != null ? obj.toString() : null));
        }
        buf.append((Object)"]");
        return buf.toString();
    }

    public Iterator select(String predicate) throws QueryInvalidException {
        return this.query(predicate).iterator();
    }

    public Object selectElement(String predicate) throws QueryInvalidException {
        return ((DList)this.query(predicate)).get(0);
    }

    public int size() {
        return this.elements.size();
    }

    public void ojbAdd(Object anObject) {
        ++this.size;
        DListEntry_2 entry = this.prepareEntry(anObject);
        entry.setPosition(this.elements.size());
        this.elements.add(entry);
    }

    public void ojbAddAll(ManageableCollection otherCollection) {
        Iterator it = otherCollection.ojbIterator();
        while (it.hasNext()) {
            this.ojbAdd(it.next());
        }
    }

    public void afterStore(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public Iterator ojbIterator() {
        return this.iterator();
    }

    public void resize(int newSize) {
    }

    public void setElements(List elements) {
        this.elements = elements;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void beforeInsert(PersistenceBroker broker) throws PersistenceBrokerException {
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            DListEntry_2 entry = (DListEntry_2)it.next();
            entry.prepareForPersistency(broker);
        }
    }

    public void beforeUpdate(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void beforeDelete(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterUpdate(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterInsert(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterDelete(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterLookup(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

