/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class SequenceManagerNativeImpl
extends AbstractSequenceManager {
    private Log log = LogFactory.getLog((Class)(class$org$apache$ojb$broker$util$sequence$SequenceManagerNativeImpl == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerNativeImpl = SequenceManagerNativeImpl.class$("org.apache.ojb.broker.util.sequence.SequenceManagerNativeImpl")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerNativeImpl));
    private long tempKey = -1L;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerNativeImpl;

    public SequenceManagerNativeImpl(PersistenceBroker broker) {
        super(broker);
    }

    public void afterStore(JdbcAccess dbAccess, ClassDescriptor cld, Object obj) throws SequenceManagerException {
        FieldDescriptor identityField = this.extractIdentityColumnField(cld);
        if (identityField != null) {
            this.ifNotReadOnlyFail(identityField);
            long newId = this.getLastInsert(cld, identityField);
            this.setFieldValue(obj, identityField, new Long(newId));
        }
    }

    private FieldDescriptor extractIdentityColumnField(ClassDescriptor cld) {
        FieldDescriptor[] pkFields = cld.getPkFields();
        for (int i = 0; i < pkFields.length; ++i) {
            if (!pkFields[i].isAutoIncrement() || !pkFields[i].isAccessReadOnly()) continue;
            return pkFields[i];
        }
        return null;
    }

    private void ifNotReadOnlyFail(FieldDescriptor field) throws SequenceManagerException {
        if (!field.isAccessReadOnly()) {
            throw new SequenceManagerException("Can't find Identity column: Identity columns/fields need to be declared as 'autoincrement' with 'readonly' access in field-descriptor");
        }
    }

    public void setReferenceFKs(Object obj, ClassDescriptor cld) throws SequenceManagerException {
        FieldDescriptor field = this.extractIdentityColumnField(cld);
        if (field != null) {
            Vector objectReferenceDescriptors = cld.getObjectReferenceDescriptors();
            Iterator i = objectReferenceDescriptors.iterator();
            while (i.hasNext()) {
                ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
                Object ref = rds.getPersistentField().get(obj);
                if (ref == null) continue;
                this.assertFkAssignment(obj, ref, rds);
            }
        }
    }

    private void assertFkAssignment(Object obj, Object ref, ObjectReferenceDescriptor rds) {
        ValueContainer[] refPkValues;
        Object realObj = ProxyHelper.getRealObject(obj);
        Class<?> objClass = realObj.getClass();
        ClassDescriptor objCld = this.getBrokerForClass().getDescriptorRepository().getDescriptorFor(objClass);
        FieldDescriptor[] objFkFields = rds.getForeignKeyFieldDescriptors(objCld);
        if (objFkFields == null) {
            throw new PersistenceBrokerException("No ForeignKeyFields !");
        }
        if (ref == null) {
            refPkValues = new ValueContainer[objFkFields.length];
        } else {
            Class refClass = ProxyHelper.getRealClass(ref);
            ClassDescriptor refCld = this.getBrokerForClass().getDescriptorRepository().getDescriptorFor(refClass);
            refPkValues = this.getBrokerForClass().serviceBrokerHelper().getKeyValues(refCld, ref, false);
        }
        for (int i = 0; i < objFkFields.length; ++i) {
            objFkFields[i].getPersistentField().set(realObj, refPkValues[i].getValue());
        }
    }

    /*
     * Loose catch block
     */
    private long getLastInsert(ClassDescriptor cld, FieldDescriptor field) throws SequenceManagerException {
        long newId;
        block13: {
            FieldDescriptor fd = field;
            newId = 0L;
            Statement stmt = null;
            if (fd != null) {
                block12: {
                    stmt = this.getBrokerForClass().serviceConnectionManager().getConnection().createStatement();
                    ResultSet rs = stmt.executeQuery(this.lastInsertSelect(cld.getFullTableName()));
                    if (!rs.next()) {
                        throw new SequenceManagerException("Could not find native identifier");
                    }
                    newId = rs.getLong(1);
                    rs.close();
                    if (!this.log.isDebugEnabled()) break block12;
                    this.log.debug((Object)("After store - newid=" + newId));
                }
                Object var9_8 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    break block13;
                }
                catch (SQLException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Threw SQLException while in getLastInsert and closing stmt", (Throwable)e);
                    }
                    break block13;
                }
                {
                    catch (Exception e) {
                        throw new SequenceManagerException(e);
                    }
                }
                catch (Throwable throwable) {
                    block14: {
                        Object var9_9 = null;
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException e) {
                            if (!this.log.isDebugEnabled()) break block14;
                            this.log.debug((Object)"Threw SQLException while in getLastInsert and closing stmt", (Throwable)e);
                        }
                    }
                    throw throwable;
                }
            }
            throw new SequenceManagerException("No autoincrement field declared, please check repository for " + cld);
        }
        return newId;
    }

    protected String lastInsertSelect(String tableName) {
        return this.getBrokerForClass().serviceConnectionManager().getSupportedPlatform().getLastInsertIdentityQuery(tableName);
    }

    private void setFieldValue(Object obj, FieldDescriptor field, Long identifier) throws SequenceManagerException {
        Object result = field.getJdbcType().sequenceKeyConversion(identifier);
        result = field.getFieldConversion().sqlToJava(result);
        PersistentField pf = field.getPersistentField();
        pf.set(obj, result);
    }

    protected long getUniqueLong(FieldDescriptor field) throws SequenceManagerException {
        return --this.tempKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

