/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.JdbcType;
import org.apache.ojb.broker.platforms.Oracle9iLobHandler;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformOracleImpl;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.JdbcTypesHelper;

public class PlatformOracle9iImpl
extends PlatformOracleImpl {
    protected static final int STATEMENT_CACHE_SIZE = 100;
    protected static final int ROW_PREFETCH_SIZE = 100;
    protected static final int STATEMENTS_PER_BATCH = 20;
    protected static Map m_batchStatementsInProgress = Collections.synchronizedMap(new WeakHashMap(20));
    protected static final Class[] PARAM_TYPE_INTEGER = new Class[]{Integer.TYPE};
    protected static final Class[] PARAM_TYPE_BOOLEAN = new Class[]{Boolean.TYPE};
    protected static final Class[] PARAM_TYPE_STRING = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PlatformOracle9iImpl.class$("java.lang.String")) : class$java$lang$String};
    protected static final Object[] PARAM_STATEMENT_CACHE_SIZE = new Object[]{new Integer(100)};
    protected static final Object[] PARAM_ROW_PREFETCH_SIZE = new Object[]{new Integer(100)};
    protected static final Object[] PARAM_STATEMENT_BATCH_SIZE = new Object[]{new Integer(20)};
    protected static final Object[] PARAM_BOOLEAN_TRUE = new Object[]{Boolean.TRUE};
    protected static final JdbcType BASE_CLOB = JdbcTypesHelper.getJdbcTypeByName("clob");
    protected static final JdbcType BASE_BLOB = JdbcTypesHelper.getJdbcTypeByName("blob");
    static /* synthetic */ Class class$java$lang$String;

    public void initializeJdbcConnection(JdbcConnectionDescriptor jcd, Connection conn) throws PlatformException {
        boolean statementCachingSupported;
        super.initializeJdbcConnection(jcd, conn);
        Method methodSetStatementCacheSize = ClassHelper.getMethod(conn, "setStatementCacheSize", PARAM_TYPE_INTEGER);
        Method methodSetImplicitCachingEnabled = ClassHelper.getMethod(conn, "setImplicitCachingEnabled", PARAM_TYPE_BOOLEAN);
        boolean bl = statementCachingSupported = methodSetStatementCacheSize != null && methodSetImplicitCachingEnabled != null;
        if (statementCachingSupported) {
            try {
                methodSetStatementCacheSize.invoke((Object)conn, PARAM_STATEMENT_CACHE_SIZE);
                methodSetImplicitCachingEnabled.invoke((Object)conn, PARAM_BOOLEAN_TRUE);
            }
            catch (Exception e) {
                throw new PlatformException(e.getLocalizedMessage(), e);
            }
        }
    }

    public void afterStatementCreate(Statement stmt) throws PlatformException {
        boolean rowPrefetchingSupported;
        super.afterStatementCreate(stmt);
        Method methodSetRowPrefetch = ClassHelper.getMethod(stmt, "setRowPrefetch", PARAM_TYPE_INTEGER);
        boolean bl = rowPrefetchingSupported = methodSetRowPrefetch != null;
        if (rowPrefetchingSupported) {
            try {
                methodSetRowPrefetch.invoke((Object)stmt, PARAM_ROW_PREFETCH_SIZE);
            }
            catch (Exception e) {
                throw new PlatformException(e.getLocalizedMessage(), e);
            }
        }
    }

    public void beforeBatch(PreparedStatement stmt) throws PlatformException {
        boolean statementBatchingSupported;
        Method methodSetExecuteBatch = ClassHelper.getMethod(stmt, "setExecuteBatch", PARAM_TYPE_INTEGER);
        Method methodSendBatch = ClassHelper.getMethod(stmt, "sendBatch", null);
        boolean bl = statementBatchingSupported = methodSetExecuteBatch != null && methodSendBatch != null;
        if (statementBatchingSupported) {
            try {
                methodSetExecuteBatch.invoke((Object)stmt, PARAM_STATEMENT_BATCH_SIZE);
                m_batchStatementsInProgress.put(stmt, methodSendBatch);
            }
            catch (Exception e) {
                throw new PlatformException(e.getLocalizedMessage(), e);
            }
        } else {
            super.beforeBatch(stmt);
        }
    }

    public void addBatch(PreparedStatement stmt) throws PlatformException {
        boolean statementBatchingSupported = m_batchStatementsInProgress.containsKey(stmt);
        if (statementBatchingSupported) {
            try {
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new PlatformException(e.getLocalizedMessage(), e);
            }
        } else {
            super.addBatch(stmt);
        }
    }

    public int[] executeBatch(PreparedStatement stmt) throws PlatformException {
        Method methodSendBatch = (Method)m_batchStatementsInProgress.remove(stmt);
        boolean statementBatchingSupported = methodSendBatch != null;
        int[] retval = null;
        if (statementBatchingSupported) {
            try {
                methodSendBatch.invoke((Object)stmt, null);
            }
            catch (Exception e) {
                throw new PlatformException(e.getLocalizedMessage(), e);
            }
        } else {
            retval = super.executeBatch(stmt);
        }
        return retval;
    }

    public void setObjectForStatement(PreparedStatement ps, int index, Object value, int sqlType) throws SQLException {
        boolean blobHandlingSupported = false;
        boolean clobHandlingSupported = false;
        Method methodSetBlob = null;
        Method methodSetClob = null;
        if (sqlType == 2005) {
            try {
                Class clobClass = ClassHelper.getClass("oracle.sql.CLOB", false);
                methodSetClob = ClassHelper.getMethod(ps, "setCLOB", new Class[]{Integer.TYPE, clobClass});
                clobHandlingSupported = methodSetClob != null;
            }
            catch (Exception ignore) {}
        } else if (sqlType == 2004) {
            try {
                Class blobClass = ClassHelper.getClass("oracle.sql.BLOB", false);
                methodSetBlob = ClassHelper.getMethod(ps, "setBLOB", new Class[]{Integer.TYPE, blobClass});
                blobHandlingSupported = methodSetBlob != null;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if ((sqlType == -3 || sqlType == -4) && value instanceof byte[]) {
            byte[] buf = (byte[])value;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buf);
            super.changePreparedStatementResultSetType(ps);
            ps.setBinaryStream(index, (InputStream)inputStream, buf.length);
        } else if (value instanceof Double) {
            ps.setDouble(index, (Double)value);
        } else if (sqlType == -5 && value instanceof Integer) {
            ps.setLong(index, ((Integer)value).intValue());
        } else if (sqlType == 4 && value instanceof Long) {
            ps.setLong(index, (Long)value);
        } else if (sqlType == 2005 && clobHandlingSupported && value instanceof String) {
            try {
                Object clob = Oracle9iLobHandler.createCLOBFromString(ps.getConnection(), (String)value);
                methodSetClob.invoke((Object)ps, new Integer(index), clob);
            }
            catch (Exception e) {
                throw new SQLException(e.getLocalizedMessage());
            }
        } else if (sqlType == 2004 && blobHandlingSupported && value instanceof byte[]) {
            try {
                Object blob = Oracle9iLobHandler.createBLOBFromByteArray(ps.getConnection(), (byte[])value);
                methodSetBlob.invoke((Object)ps, new Integer(index), blob);
            }
            catch (Exception e) {
                throw new SQLException(e.getLocalizedMessage());
            }
        } else {
            super.setObjectForStatement(ps, index, value, sqlType);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

