/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.util.HashMap;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.platforms.PlatformDefaultImpl;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PlatformFactory {
    private static HashMap platforms = new HashMap();

    public static Platform getPlatformFor(JdbcConnectionDescriptor jcd) {
        String dbms = jcd.getDbms();
        Platform result = null;
        String platformName = null;
        result = (Platform)PlatformFactory.getPlatforms().get(dbms);
        if (result == null) {
            try {
                platformName = PlatformFactory.getClassnameFor(dbms);
                Class<?> platformClass = Class.forName(platformName);
                result = (Platform)platformClass.newInstance();
            }
            catch (Throwable t) {
                LoggerFactory.getDefaultLogger().warn("[PlatformFactory] problems with platform " + platformName + ": " + t.getMessage());
                LoggerFactory.getDefaultLogger().warn("[PlatformFactory] OJB will use PlatformDefaultImpl instead");
                result = new PlatformDefaultImpl();
            }
            PlatformFactory.getPlatforms().put(dbms, result);
        }
        return result;
    }

    private static String getClassnameFor(String platform) {
        String pf = "Default";
        if (platform != null) {
            pf = platform;
        }
        return "org.apache.ojb.broker.platforms.Platform" + pf.substring(0, 1).toUpperCase() + pf.substring(1) + "Impl";
    }

    private static HashMap getPlatforms() {
        return platforms;
    }
}

