/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import org.apache.ojb.broker.accesslayer.QueryCustomizer;
import org.apache.ojb.broker.metadata.AnonymousFieldDescriptor;
import org.apache.ojb.broker.metadata.AnonymousObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.ArgumentDescriptor;
import org.apache.ojb.broker.metadata.AttributeContainer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DeleteProcedureDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.IndexDescriptor;
import org.apache.ojb.broker.metadata.InsertProcedureDescriptor;
import org.apache.ojb.broker.metadata.IsolationLevels;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.ObjectCacheDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.ProcedureDescriptor;
import org.apache.ojb.broker.metadata.RepositoryElements;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.UpdateProcedureDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.AnonymousPersistentFieldHelper;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldFactory;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryXmlHandler
extends DefaultHandler
implements RepositoryElements,
IsolationLevels {
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$RepositoryXmlHandler == null ? (class$org$apache$ojb$broker$metadata$RepositoryXmlHandler = RepositoryXmlHandler.class$("org.apache.ojb.broker.metadata.RepositoryXmlHandler")) : class$org$apache$ojb$broker$metadata$RepositoryXmlHandler);
    private DescriptorRepository m_repository;
    private ClassDescriptor m_CurrentCLD;
    private ProcedureDescriptor m_CurrentProcedure;
    private FieldDescriptor m_CurrentFLD;
    private ObjectReferenceDescriptor m_CurrentORD;
    private CollectionDescriptor m_CurrentCOD;
    private IndexDescriptor m_CurrentIndexDescriptor;
    private String m_CurrentString;
    private AttributeContainer m_CurrentAttrContainer;
    private int defIsoLevel = 0;
    private int defProxyPrefetchingLimit = 50;
    private int m_lastId;
    private RepositoryTags tags = RepositoryTags.getInstance();
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$RepositoryXmlHandler;

    private int getLiteralId(String literal) throws MetadataException {
        try {
            return this.tags.getIdByTag(literal);
        }
        catch (NullPointerException t) {
            throw new MetadataException("Found Unknown literal '" + literal + "' in the repository file. Check repository file or/and RepositoryTags.java", t);
        }
    }

    public RepositoryXmlHandler(DescriptorRepository dr) {
        if (dr == null) {
            throw new MetadataException("Given DescriptorRepository argument was null");
        }
        this.m_repository = dr;
    }

    public void startDocument() {
        this.logger.debug("startDoc");
    }

    public void endDocument() {
        AnonymousPersistentFieldHelper.computeInheritedPersistentFields(this.m_repository);
        this.logger.debug("endDoc");
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        boolean isDebug = this.logger.isDebugEnabled();
        this.m_CurrentString = null;
        try {
            switch (this.getLiteralId(qName)) {
                case 0: {
                    if (isDebug) {
                        this.logger.debug(" > " + this.tags.getTagById(0));
                    }
                    this.m_CurrentAttrContainer = this.m_repository;
                    String defIso = atts.getValue(this.tags.getTagById(34));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(34) + ": " + defIso);
                    }
                    if (defIso != null) {
                        this.defIsoLevel = this.getIsoLevel(defIso);
                    }
                    String proxyPrefetchingLimit = atts.getValue(this.tags.getTagById(114));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(114) + ": " + proxyPrefetchingLimit);
                    }
                    if (proxyPrefetchingLimit != null) {
                        this.defProxyPrefetchingLimit = Integer.parseInt(proxyPrefetchingLimit);
                    }
                    String version = atts.getValue(this.tags.getTagById(67));
                    if (DescriptorRepository.getVersion().equals(version)) {
                        if (!isDebug) break;
                        this.logger.debug("     " + this.tags.getTagById(67) + ": " + version);
                        break;
                    }
                    throw new MetadataException("Repository version does not match. expected " + DescriptorRepository.getVersion() + " but found: " + version + ". Please update your repository.dtd and your repository.xml" + " version attribute entry");
                }
                case 12: {
                    String acceptLocks;
                    if (isDebug) {
                        this.logger.debug("  > " + this.tags.getTagById(12));
                    }
                    this.m_CurrentCLD = new ClassDescriptor(this.m_repository);
                    this.m_CurrentAttrContainer = this.m_CurrentCLD;
                    String isoLevel = atts.getValue(this.tags.getTagById(34));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(34) + ": " + isoLevel);
                    }
                    this.m_CurrentCLD.setIsolationLevel(this.getIsoLevel(isoLevel));
                    String classname = atts.getValue(this.tags.getTagById(13));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(13) + ": " + classname);
                    }
                    try {
                        this.m_CurrentCLD.setClassOfObject(ClassHelper.getClass(classname));
                        this.m_repository.put(classname, this.m_CurrentCLD);
                    }
                    catch (ClassNotFoundException e) {
                        this.m_CurrentCLD = null;
                        throw new MetadataException("Class " + classname + " could not be found" + " in the classpath. This could cause unexpected behaviour of OJB," + " please remove or comment out this class descriptor" + " in the repository.xml file.", e);
                    }
                    String schema = atts.getValue(this.tags.getTagById(5));
                    if (schema != null) {
                        if (isDebug) {
                            this.logger.debug("     " + this.tags.getTagById(5) + ": " + schema);
                        }
                        this.m_CurrentCLD.setSchema(schema);
                    }
                    String proxy = atts.getValue(this.tags.getTagById(35));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(35) + ": " + proxy);
                    }
                    if (proxy != null) {
                        if (proxy.equalsIgnoreCase("dynamic")) {
                            this.m_CurrentCLD.setProxyClassName("dynamic");
                        } else {
                            this.m_CurrentCLD.setProxyClassName(proxy);
                        }
                    }
                    String proxyPrefetchingLimit = atts.getValue(this.tags.getTagById(114));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(114) + ": " + proxyPrefetchingLimit);
                    }
                    if (proxyPrefetchingLimit == null) {
                        this.m_CurrentCLD.setProxyPrefetchingLimit(this.defProxyPrefetchingLimit);
                    } else {
                        this.m_CurrentCLD.setProxyPrefetchingLimit(Integer.parseInt(proxyPrefetchingLimit));
                    }
                    String table = atts.getValue(this.tags.getTagById(14));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(14) + ": " + table);
                    }
                    this.m_CurrentCLD.setTableName(table);
                    if (table == null) {
                        this.m_CurrentCLD.setIsInterface(true);
                    }
                    String rowreader = atts.getValue(this.tags.getTagById(32));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(32) + ": " + rowreader);
                    }
                    if (rowreader != null) {
                        this.m_CurrentCLD.setRowReader(rowreader);
                    }
                    String extendsAtt = atts.getValue(this.tags.getTagById(76));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(76) + ": " + extendsAtt);
                    }
                    if (extendsAtt != null) {
                        this.m_CurrentCLD.setSuperClass(extendsAtt);
                    }
                    if ((acceptLocks = atts.getValue(this.tags.getTagById(78))) == null) {
                        acceptLocks = "true";
                    }
                    this.logger.debug("     " + this.tags.getTagById(78) + ": " + acceptLocks);
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(78) + ": " + acceptLocks);
                    }
                    boolean b = Boolean.valueOf(acceptLocks);
                    this.m_CurrentCLD.setAcceptLocks(b);
                    String initializationMethod = atts.getValue(this.tags.getTagById(93));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(93) + ": " + initializationMethod);
                    }
                    if (initializationMethod != null) {
                        this.m_CurrentCLD.setInitializationMethod(initializationMethod);
                    }
                    String factoryClass = atts.getValue(this.tags.getTagById(100));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(100) + ": " + factoryClass);
                    }
                    if (factoryClass != null) {
                        this.m_CurrentCLD.setFactoryClass(factoryClass);
                    }
                    String factoryMethod = atts.getValue(this.tags.getTagById(101));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(101) + ": " + factoryMethod);
                    }
                    if (factoryMethod != null) {
                        this.m_CurrentCLD.setFactoryMethod(factoryMethod);
                    }
                    String refresh = atts.getValue(this.tags.getTagById(47));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(47) + ": " + refresh);
                    }
                    b = Boolean.valueOf(refresh);
                    this.m_CurrentCLD.setAlwaysRefresh(b);
                    String pfClassName = atts.getValue("persistent-field-class");
                    if (isDebug) {
                        this.logger.debug("     persistent-field-class: " + pfClassName);
                    }
                    this.m_CurrentCLD.setPersistentFieldClassName(pfClassName);
                    break;
                }
                case 113: {
                    if (this.m_CurrentCLD == null) break;
                    String className = atts.getValue(this.tags.getTagById(13));
                    if (this.checkString(className)) {
                        if (isDebug) {
                            this.logger.debug("     > " + this.tags.getTagById(113));
                        }
                        ObjectCacheDescriptor ocd = new ObjectCacheDescriptor();
                        this.m_CurrentAttrContainer = ocd;
                        ocd.setObjectCache(ClassHelper.getClass(className));
                        if (this.m_CurrentCLD != null) {
                            this.m_CurrentCLD.setObjectCacheDescriptor(ocd);
                        }
                        if (isDebug) {
                            this.logger.debug("     " + this.tags.getTagById(13) + ": " + className);
                        }
                    }
                    break;
                }
                case 33: {
                    String classname = atts.getValue("class-ref");
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(33) + ": " + classname);
                    }
                    this.m_CurrentCLD.addExtentClass(classname);
                    break;
                }
                case 15: {
                    String scale;
                    String precision;
                    String length;
                    String strId;
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(15));
                    }
                    this.m_lastId = (strId = atts.getValue(this.tags.getTagById(69))) == null ? this.m_lastId + 1 : Integer.parseInt(strId);
                    String strAccess = atts.getValue(this.tags.getTagById(99));
                    this.m_CurrentFLD = "anonymous".equalsIgnoreCase(strAccess) ? new AnonymousFieldDescriptor(this.m_CurrentCLD, this.m_lastId) : new FieldDescriptor(this.m_CurrentCLD, this.m_lastId);
                    this.m_CurrentFLD.setAccess(strAccess);
                    this.m_CurrentCLD.addFieldDescriptor(this.m_CurrentFLD);
                    this.m_CurrentAttrContainer = this.m_CurrentFLD;
                    String fieldName = atts.getValue(this.tags.getTagById(16));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(16) + ": " + fieldName);
                    }
                    if ("anonymous".equalsIgnoreCase(strAccess)) {
                        AnonymousFieldDescriptor anonymous = (AnonymousFieldDescriptor)this.m_CurrentFLD;
                        anonymous.setPersistentField(null, fieldName);
                    } else {
                        String classname = this.m_CurrentCLD.getClassNameOfObject();
                        PersistentField pf = PersistentFieldFactory.createPersistentField(this.m_CurrentCLD.getPersistentFieldClassName(), ClassHelper.getClass(classname), fieldName);
                        this.m_CurrentFLD.setPersistentField(pf);
                    }
                    String columnName = atts.getValue(this.tags.getTagById(17));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(17) + ": " + columnName);
                    }
                    this.m_CurrentFLD.setColumnName(columnName);
                    String jdbcType = atts.getValue(this.tags.getTagById(18));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(18) + ": " + jdbcType);
                    }
                    this.m_CurrentFLD.setColumnType(jdbcType);
                    String primaryKey = atts.getValue(this.tags.getTagById(19));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(19) + ": " + primaryKey);
                    }
                    boolean b = Boolean.valueOf(primaryKey);
                    this.m_CurrentFLD.setPrimaryKey(b);
                    String nullable = atts.getValue(this.tags.getTagById(50));
                    if (nullable != null) {
                        if (isDebug) {
                            this.logger.debug("     " + this.tags.getTagById(50) + ": " + nullable);
                        }
                        b = Boolean.valueOf(nullable) == false;
                        this.m_CurrentFLD.setRequired(b);
                    }
                    String indexed = atts.getValue(this.tags.getTagById(51));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(51) + ": " + indexed);
                    }
                    b = Boolean.valueOf(indexed);
                    this.m_CurrentFLD.setIndexed(b);
                    String autoincrement = atts.getValue(this.tags.getTagById(31));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(31) + ": " + autoincrement);
                    }
                    b = Boolean.valueOf(autoincrement);
                    this.m_CurrentFLD.setAutoIncrement(b);
                    String sequenceName = atts.getValue(this.tags.getTagById(77));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(77) + ": " + sequenceName);
                    }
                    this.m_CurrentFLD.setSequenceName(sequenceName);
                    String locking = atts.getValue(this.tags.getTagById(46));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(46) + ": " + locking);
                    }
                    b = Boolean.valueOf(locking);
                    this.m_CurrentFLD.setLocking(b);
                    String updateLock = atts.getValue(this.tags.getTagById(98));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(98) + ": " + updateLock);
                    }
                    b = Boolean.valueOf(updateLock);
                    this.m_CurrentFLD.setUpdateLock(b);
                    String fieldConversion = atts.getValue(this.tags.getTagById(30));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(30) + ": " + fieldConversion);
                    }
                    if (fieldConversion != null) {
                        this.m_CurrentFLD.setFieldConversionClassName(fieldConversion);
                    }
                    if ((length = atts.getValue(this.tags.getTagById(52))) != null) {
                        int i = Integer.parseInt(length);
                        if (isDebug) {
                            this.logger.debug("     " + this.tags.getTagById(52) + ": " + i);
                        }
                        this.m_CurrentFLD.setLength(i);
                        this.m_CurrentFLD.setLengthSpecified(true);
                    }
                    if ((precision = atts.getValue(this.tags.getTagById(53))) != null) {
                        int i = Integer.parseInt(precision);
                        if (isDebug) {
                            this.logger.debug("     " + this.tags.getTagById(53) + ": " + i);
                        }
                        this.m_CurrentFLD.setPrecision(i);
                        this.m_CurrentFLD.setPrecisionSpecified(true);
                    }
                    if ((scale = atts.getValue(this.tags.getTagById(54))) == null) break;
                    int i = Integer.parseInt(scale);
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(54) + ": " + i);
                    }
                    this.m_CurrentFLD.setScale(i);
                    this.m_CurrentFLD.setScaleSpecified(true);
                    break;
                }
                case 20: {
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(20));
                    }
                    name = atts.getValue(this.tags.getTagById(16));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(16) + ": " + name);
                    }
                    String classRef = atts.getValue(this.tags.getTagById(22));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(22) + ": " + classRef);
                    }
                    ObjectReferenceDescriptor ord = null;
                    if (name.equals("super")) {
                        this.checkThis(classRef);
                        AnonymousObjectReferenceDescriptor aord = new AnonymousObjectReferenceDescriptor(this.m_CurrentCLD);
                        aord.setPersistentField(null, "super");
                        ord = aord;
                    } else {
                        ord = new ObjectReferenceDescriptor(this.m_CurrentCLD);
                        PersistentField pf = PersistentFieldFactory.createPersistentField(this.m_CurrentCLD.getPersistentFieldClassName(), this.m_CurrentCLD.getClassOfObject(), name);
                        ord.setPersistentField(pf);
                    }
                    this.m_CurrentORD = ord;
                    this.m_CurrentCLD.addObjectReferenceDescriptor(this.m_CurrentORD);
                    this.m_CurrentORD.setItemClass(ClassHelper.getClass(classRef));
                    this.m_CurrentAttrContainer = this.m_CurrentORD;
                    String proxy = atts.getValue(this.tags.getTagById(48));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(48) + ": " + proxy);
                    }
                    boolean b = Boolean.valueOf(proxy);
                    this.m_CurrentORD.setLazy(b);
                    String proxyPrefetchingLimit = atts.getValue(this.tags.getTagById(114));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(114) + ": " + proxyPrefetchingLimit);
                    }
                    if (proxyPrefetchingLimit == null) {
                        this.m_CurrentORD.setProxyPrefetchingLimit(this.defProxyPrefetchingLimit);
                    } else {
                        this.m_CurrentORD.setProxyPrefetchingLimit(Integer.parseInt(proxyPrefetchingLimit));
                    }
                    String refresh = atts.getValue(this.tags.getTagById(47));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(47) + ": " + refresh);
                    }
                    b = Boolean.valueOf(refresh);
                    this.m_CurrentORD.setRefresh(b);
                    String autoRetrieve = atts.getValue(this.tags.getTagById(24));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(24) + ": " + autoRetrieve);
                    }
                    b = Boolean.valueOf(autoRetrieve);
                    this.m_CurrentORD.setCascadeRetrieve(b);
                    String autoUpdate = atts.getValue(this.tags.getTagById(25));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(25) + ": " + autoUpdate);
                    }
                    if (autoUpdate != null) {
                        this.m_CurrentORD.setCascadingStore(autoUpdate);
                    }
                    String autoDelete = atts.getValue(this.tags.getTagById(26));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(26) + ": " + autoDelete);
                    }
                    if (autoDelete != null) {
                        this.m_CurrentORD.setCascadingDelete(autoDelete);
                    }
                    String otmDependent = atts.getValue(this.tags.getTagById(102));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(102) + ": " + otmDependent);
                    }
                    b = Boolean.valueOf(otmDependent);
                    this.m_CurrentORD.setOtmDependent(b);
                    break;
                }
                case 49: {
                    String fieldIdRef;
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(49));
                    }
                    if ((fieldIdRef = atts.getValue(this.tags.getTagById(70))) != null) {
                        if (isDebug) {
                            this.logger.debug("      " + this.tags.getTagById(70) + ": " + fieldIdRef);
                        }
                        try {
                            int fieldId = Integer.parseInt(fieldIdRef);
                            this.m_CurrentORD.addForeignKeyField(fieldId);
                            break;
                        }
                        catch (NumberFormatException rex) {
                            throw new MetadataException(this.tags.getTagById(70) + " attribute must be an int. Found: " + fieldIdRef + ". Please check your repository file.", rex);
                        }
                    }
                    String fieldRef = atts.getValue(this.tags.getTagById(84));
                    if (isDebug) {
                        this.logger.debug("      " + this.tags.getTagById(84) + ": " + fieldRef);
                    }
                    this.m_CurrentORD.addForeignKeyField(fieldRef);
                    break;
                }
                case 27: {
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(27));
                    }
                    this.m_CurrentCOD = new CollectionDescriptor(this.m_CurrentCLD);
                    this.m_CurrentAttrContainer = this.m_CurrentCOD;
                    name = atts.getValue(this.tags.getTagById(16));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(16) + ": " + name);
                    }
                    PersistentField pf = PersistentFieldFactory.createPersistentField(this.m_CurrentCLD.getPersistentFieldClassName(), this.m_CurrentCLD.getClassOfObject(), name);
                    this.m_CurrentCOD.setPersistentField(pf);
                    String collectionClassName = atts.getValue(this.tags.getTagById(37));
                    if (collectionClassName != null) {
                        if (isDebug) {
                            this.logger.debug("     " + this.tags.getTagById(37) + ": " + collectionClassName);
                        }
                        this.m_CurrentCOD.setCollectionClass(ClassHelper.getClass(collectionClassName));
                    }
                    String elementClassRef = atts.getValue(this.tags.getTagById(29));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(29) + ": " + elementClassRef);
                    }
                    if (elementClassRef != null) {
                        this.m_CurrentCOD.setItemClass(ClassHelper.getClass(elementClassRef));
                    }
                    String orderby = atts.getValue(this.tags.getTagById(36));
                    String sort = atts.getValue(this.tags.getTagById(3));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(3) + ": " + orderby + ", " + sort);
                    }
                    if (orderby != null) {
                        this.m_CurrentCOD.addOrderBy(orderby, "ASC".equalsIgnoreCase(sort));
                    }
                    String indirectionTable = atts.getValue(this.tags.getTagById(39));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(39) + ": " + indirectionTable);
                    }
                    this.m_CurrentCOD.setIndirectionTable(indirectionTable);
                    String proxy = atts.getValue(this.tags.getTagById(48));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(48) + ": " + proxy);
                    }
                    boolean b = Boolean.valueOf(proxy);
                    this.m_CurrentCOD.setLazy(b);
                    String proxyPrefetchingLimit = atts.getValue(this.tags.getTagById(114));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(114) + ": " + proxyPrefetchingLimit);
                    }
                    if (proxyPrefetchingLimit == null) {
                        this.m_CurrentCOD.setProxyPrefetchingLimit(this.defProxyPrefetchingLimit);
                    } else {
                        this.m_CurrentCOD.setProxyPrefetchingLimit(Integer.parseInt(proxyPrefetchingLimit));
                    }
                    String refresh = atts.getValue(this.tags.getTagById(47));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(47) + ": " + refresh);
                    }
                    b = Boolean.valueOf(refresh);
                    this.m_CurrentCOD.setRefresh(b);
                    String autoRetrieve = atts.getValue(this.tags.getTagById(24));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(24) + ": " + autoRetrieve);
                    }
                    b = Boolean.valueOf(autoRetrieve);
                    this.m_CurrentCOD.setCascadeRetrieve(b);
                    String autoUpdate = atts.getValue(this.tags.getTagById(25));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(25) + ": " + autoUpdate);
                    }
                    if (autoUpdate != null) {
                        this.m_CurrentCOD.setCascadingStore(autoUpdate);
                    }
                    String autoDelete = atts.getValue(this.tags.getTagById(26));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(26) + ": " + autoDelete);
                    }
                    if (autoDelete != null) {
                        this.m_CurrentCOD.setCascadingDelete(autoDelete);
                    }
                    String otmDependent = atts.getValue(this.tags.getTagById(102));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(102) + ": " + otmDependent);
                    }
                    b = Boolean.valueOf(otmDependent);
                    this.m_CurrentCOD.setOtmDependent(b);
                    this.m_CurrentCLD.addCollectionDescriptor(this.m_CurrentCOD);
                    break;
                }
                case 36: {
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(36));
                    }
                    name = atts.getValue(this.tags.getTagById(16));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(16) + ": " + name);
                    }
                    String sort = atts.getValue(this.tags.getTagById(3));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(3) + ": " + name + ", " + sort);
                    }
                    this.m_CurrentCOD.addOrderBy(name, "ASC".equalsIgnoreCase(sort));
                    break;
                }
                case 38: {
                    String fieldIdRef;
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(38));
                    }
                    if ((fieldIdRef = atts.getValue(this.tags.getTagById(70))) != null) {
                        if (isDebug) {
                            this.logger.debug("      " + this.tags.getTagById(70) + ": " + fieldIdRef);
                        }
                        try {
                            int fieldId = Integer.parseInt(fieldIdRef);
                            this.m_CurrentCOD.addForeignKeyField(fieldId);
                            break;
                        }
                        catch (NumberFormatException rex) {
                            throw new MetadataException(this.tags.getTagById(70) + " attribute must be an int. Found: " + fieldIdRef + " Please check your repository file.", rex);
                        }
                    }
                    String fieldRef = atts.getValue(this.tags.getTagById(84));
                    if (isDebug) {
                        this.logger.debug("      " + this.tags.getTagById(84) + ": " + fieldRef);
                    }
                    this.m_CurrentCOD.addForeignKeyField(fieldRef);
                    break;
                }
                case 41: {
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(41));
                    }
                    String column = atts.getValue("column");
                    if (isDebug) {
                        this.logger.debug("      column: " + column);
                    }
                    this.m_CurrentCOD.addFkToThisClass(column);
                    break;
                }
                case 40: {
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(40));
                    }
                    String column = atts.getValue("column");
                    if (isDebug) {
                        this.logger.debug("      column: " + column);
                    }
                    this.m_CurrentCOD.addFkToItemClass(column);
                    break;
                }
                case 71: {
                    String attributeName = atts.getValue(this.tags.getTagById(72));
                    String attributeValue = atts.getValue(this.tags.getTagById(73));
                    if (this.m_CurrentAttrContainer == null) break;
                    if (isDebug) {
                        this.logger.debug("      > " + this.tags.getTagById(71));
                    }
                    if (isDebug) {
                        this.logger.debug("       " + this.tags.getTagById(72) + ": " + attributeName);
                    }
                    if (isDebug) {
                        this.logger.debug("       " + this.tags.getTagById(73) + ": " + attributeValue);
                    }
                    this.m_CurrentAttrContainer.addAttribute(attributeName, attributeValue);
                    break;
                }
                case 92: {
                    String className = atts.getValue("class");
                    if (className == null) break;
                    if (isDebug) {
                        this.logger.debug("     class: " + className);
                    }
                    QueryCustomizer queryCust = (QueryCustomizer)ClassHelper.newInstance(className);
                    this.m_CurrentAttrContainer = queryCust;
                    this.m_CurrentCOD.setQueryCustomizer(queryCust);
                    break;
                }
                case 94: {
                    this.m_CurrentIndexDescriptor = new IndexDescriptor();
                    this.m_CurrentIndexDescriptor.setName(atts.getValue(this.tags.getTagById(97)));
                    this.m_CurrentIndexDescriptor.setUnique(Boolean.valueOf(atts.getValue(this.tags.getTagById(96))));
                    break;
                }
                case 95: {
                    this.m_CurrentIndexDescriptor.getIndexColumns().add(atts.getValue(this.tags.getTagById(97)));
                    break;
                }
                case 103: {
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(103));
                    }
                    String procName = atts.getValue(this.tags.getTagById(97));
                    String includeAllFields = atts.getValue(this.tags.getTagById(109));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(97) + ": " + procName);
                    }
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(109) + ": " + includeAllFields);
                    }
                    InsertProcedureDescriptor proc = new InsertProcedureDescriptor(this.m_CurrentCLD, procName, Boolean.valueOf(includeAllFields));
                    this.m_CurrentProcedure = proc;
                    String returnFieldRefName = atts.getValue(this.tags.getTagById(108));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(108) + ": " + returnFieldRefName);
                    }
                    proc.setReturnValueFieldRef(returnFieldRefName);
                    break;
                }
                case 104: {
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(104));
                    }
                    String procName = atts.getValue(this.tags.getTagById(97));
                    String includeAllFields = atts.getValue(this.tags.getTagById(109));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(97) + ": " + procName);
                    }
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(109) + ": " + includeAllFields);
                    }
                    UpdateProcedureDescriptor proc = new UpdateProcedureDescriptor(this.m_CurrentCLD, procName, Boolean.valueOf(includeAllFields));
                    this.m_CurrentProcedure = proc;
                    String returnFieldRefName = atts.getValue(this.tags.getTagById(108));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(108) + ": " + returnFieldRefName);
                    }
                    proc.setReturnValueFieldRef(returnFieldRefName);
                    break;
                }
                case 105: {
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(104));
                    }
                    String procName = atts.getValue(this.tags.getTagById(97));
                    String includeAllPkFields = atts.getValue(this.tags.getTagById(110));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(97) + ": " + procName);
                    }
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(110) + ": " + includeAllPkFields);
                    }
                    DeleteProcedureDescriptor proc = new DeleteProcedureDescriptor(this.m_CurrentCLD, procName, Boolean.valueOf(includeAllPkFields));
                    this.m_CurrentProcedure = proc;
                    String returnFieldRefName = atts.getValue(this.tags.getTagById(108));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(108) + ": " + returnFieldRefName);
                    }
                    proc.setReturnValueFieldRef(returnFieldRefName);
                    break;
                }
                case 106: {
                    String value = null;
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(106));
                    }
                    ArgumentDescriptor arg = new ArgumentDescriptor(this.m_CurrentProcedure);
                    value = atts.getValue(this.tags.getTagById(112));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(112) + ": " + value);
                    }
                    arg.setValue(value);
                    this.m_CurrentProcedure.addArgument(arg);
                    break;
                }
                case 107: {
                    if (isDebug) {
                        this.logger.debug("    > " + this.tags.getTagById(107));
                    }
                    ArgumentDescriptor arg = new ArgumentDescriptor(this.m_CurrentProcedure);
                    String fieldRefName = atts.getValue(this.tags.getTagById(84));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(84) + ": " + fieldRefName);
                    }
                    String returnValue = atts.getValue(this.tags.getTagById(111));
                    if (isDebug) {
                        this.logger.debug("     " + this.tags.getTagById(111) + ": " + returnValue);
                    }
                    if (fieldRefName != null && fieldRefName.trim().length() != 0) {
                        arg.setValue(fieldRefName, Boolean.valueOf(returnValue));
                    }
                    this.m_CurrentProcedure.addArgument(arg);
                    break;
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof MetadataException) {
                throw (MetadataException)((Object)ex);
            }
            throw new MetadataException("Exception when reading metadata information, please check your repository.xml file", ex);
        }
    }

    public void endElement(String uri, String name, String qName) {
        boolean isDebug = this.logger.isDebugEnabled();
        try {
            switch (this.getLiteralId(qName)) {
                case 0: {
                    if (isDebug) {
                        this.logger.debug(" < " + this.tags.getTagById(0));
                    }
                    this.m_CurrentAttrContainer = null;
                    this.m_CurrentCLD = null;
                    break;
                }
                case 12: {
                    if (isDebug) {
                        this.logger.debug("  < " + this.tags.getTagById(12));
                    }
                    this.m_CurrentCLD = null;
                    this.m_CurrentAttrContainer = null;
                    break;
                }
                case 113: {
                    if (this.m_CurrentAttrContainer != null && isDebug) {
                        this.logger.debug("     < " + this.tags.getTagById(113));
                    }
                    this.m_CurrentAttrContainer = this.m_CurrentCLD;
                    break;
                }
                case 33: {
                    break;
                }
                case 15: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(15));
                    }
                    this.m_CurrentFLD = null;
                    this.m_CurrentAttrContainer = this.m_CurrentCLD;
                    break;
                }
                case 20: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(20));
                    }
                    this.m_CurrentORD = null;
                    this.m_CurrentAttrContainer = this.m_CurrentCLD;
                    break;
                }
                case 49: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(49));
                    }
                    break;
                }
                case 27: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(27));
                    }
                    this.m_CurrentCOD = null;
                    this.m_CurrentAttrContainer = this.m_CurrentCLD;
                    break;
                }
                case 38: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(38));
                    }
                    break;
                }
                case 36: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(36));
                    }
                    break;
                }
                case 41: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(41));
                    }
                    break;
                }
                case 40: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(40));
                    }
                    break;
                }
                case 71: {
                    if (this.m_CurrentAttrContainer != null && isDebug) {
                        this.logger.debug("      < " + this.tags.getTagById(71));
                    }
                    break;
                }
                case 75: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(75));
                    }
                    break;
                }
                case 92: {
                    this.m_CurrentAttrContainer = this.m_CurrentCOD;
                    break;
                }
                case 94: {
                    this.m_CurrentCLD.getIndexes().add(this.m_CurrentIndexDescriptor);
                    this.m_CurrentIndexDescriptor = null;
                    break;
                }
                case 95: {
                    break;
                }
                case 103: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(103));
                    }
                    this.m_CurrentCLD.setInsertProcedure((InsertProcedureDescriptor)this.m_CurrentProcedure);
                    this.m_CurrentProcedure = null;
                    break;
                }
                case 104: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(104));
                    }
                    this.m_CurrentCLD.setUpdateProcedure((UpdateProcedureDescriptor)this.m_CurrentProcedure);
                    this.m_CurrentProcedure = null;
                    break;
                }
                case 105: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(105));
                    }
                    this.m_CurrentCLD.setDeleteProcedure((DeleteProcedureDescriptor)this.m_CurrentProcedure);
                    this.m_CurrentProcedure = null;
                    break;
                }
                case 106: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(106));
                    }
                    break;
                }
                case 107: {
                    if (isDebug) {
                        this.logger.debug("    < " + this.tags.getTagById(107));
                    }
                    break;
                }
                default: {
                    this.logger.debug("Ignoring unused Element " + qName);
                    break;
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof MetadataException) {
                throw (MetadataException)((Object)ex);
            }
            throw new MetadataException("Exception when reading metadata information, please check your repository.xml file", ex);
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.m_CurrentString = this.m_CurrentString == null ? new String(ch, start, length) : this.m_CurrentString + new String(ch, start, length);
    }

    public void error(SAXParseException e) throws SAXException {
        this.logger.error(e);
        throw e;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.logger.fatal(e);
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        this.logger.warn(e);
        throw e;
    }

    private int getIsoLevel(String isoLevel) {
        if (isoLevel == null) {
            this.logger.debug("isolation level is 'null', using default isolation level: " + this.defIsoLevel);
            return this.defIsoLevel;
        }
        if (isoLevel.equalsIgnoreCase("read-uncommitted")) {
            return 0;
        }
        if (isoLevel.equalsIgnoreCase("read-committed")) {
            return 1;
        }
        if (isoLevel.equalsIgnoreCase("repeatable-read")) {
            return 2;
        }
        if (isoLevel.equalsIgnoreCase("serializable")) {
            return 3;
        }
        if (isoLevel.equalsIgnoreCase("optimistic")) {
            return 4;
        }
        this.logger.warn("unknown isolation-level: " + isoLevel + " using default isolation level: " + this.defIsoLevel);
        return this.defIsoLevel;
    }

    private boolean checkString(String str) {
        return str != null && !str.trim().equals("");
    }

    private void checkThis(String classRef) {
        Class actualClass = this.m_CurrentCLD.getClassOfObject();
        String superClass = actualClass.getSuperclass().getName();
        if (superClass.equals(classRef)) {
            if (null != this.m_CurrentCLD.getBaseClass()) {
                throw new MetadataException("Multiple anonymous reference descriptor not authorized in " + actualClass.getName());
            }
        } else {
            if (superClass.equalsIgnoreCase(classRef)) {
                throw new MetadataException("Classes name are case sensitive: super class of " + actualClass.getName() + " is " + superClass + " not " + classRef);
            }
            throw new MetadataException("Class " + classRef + " is not a superclass of class " + actualClass.getName());
        }
        this.m_CurrentCLD.setBaseClass(superClass);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

