/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.AbstractMetaCache;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheFactory;
import org.apache.ojb.broker.metadata.ObjectCacheDescriptor;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class CacheDistributor
extends AbstractMetaCache {
    private static Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$cache$CacheDistributor == null ? (class$org$apache$ojb$broker$cache$CacheDistributor = CacheDistributor.class$("org.apache.ojb.broker.cache.CacheDistributor")) : class$org$apache$ojb$broker$cache$CacheDistributor);
    private static final String DESCRIPTOR_BASED_CACHES = "descriptorBasedCaches";
    private Map caches = new HashMap();
    private ObjectCache defaultCache;
    private PersistenceBroker broker;
    private boolean descriptorBasedCaches;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$CacheDistributor;

    public CacheDistributor(PersistenceBroker broker, ObjectCache defaultCache) {
        this.broker = broker;
        this.defaultCache = defaultCache;
        this.descriptorBasedCaches = OjbConfigurator.getInstance().getConfigurationFor(null).getBoolean(DESCRIPTOR_BASED_CACHES, false);
        logger.info("Use property 'descriptorBasedCaches' is set '" + this.descriptorBasedCaches + "'");
    }

    private ObjectCache prepareAndAddCache(PersistenceBroker aBroker, ObjectCacheDescriptor ocd, Object key) {
        ObjectCache cache;
        if (this.caches.containsKey(key)) {
            logger.info("Contains key '" + key + "', do not create new ObjectCache implementation");
            cache = (ObjectCache)this.caches.get(key);
        } else {
            logger.info("Create new ObjectCacheImplementation for '" + key + "'");
            cache = this.createObjectCache(aBroker, ocd);
            this.caches.put(key, cache);
        }
        return cache;
    }

    private ObjectCache createObjectCache(PersistenceBroker aBroker, ObjectCacheDescriptor ocd) {
        ObjectCache cache = null;
        try {
            cache = ObjectCacheFactory.getInstance().createNewCacheInstance(ocd.getObjectCache(), aBroker, ocd.getConfigurationProperties());
        }
        catch (Exception e) {
            logger.error("Can not create ObjectCache instance using " + ocd.getObjectCache() + ", use default cache instead", e);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.defaultCache.clear();
        Map map = this.caches;
        synchronized (map) {
            Iterator it = this.caches.values().iterator();
            ObjectCache oc = null;
            while (it.hasNext()) {
                oc = (ObjectCache)it.next();
                oc.clear();
            }
            this.caches.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectCache getCache(Identity oid, Object obj, int callingMethod) {
        boolean connectionLevel = false;
        ObjectCache retval = null;
        ObjectCacheDescriptor ocd = this.searchInClassDescriptor(oid);
        if (ocd == null) {
            ocd = this.searchInJdbcConnectionDescriptor();
            connectionLevel = true;
        }
        if (ocd == null) {
            retval = this.defaultCache;
        } else if (!connectionLevel) {
            if (!this.descriptorBasedCaches) {
                Map map = this.caches;
                synchronized (map) {
                    retval = this.lookupCache(oid.getObjectsRealClass());
                    if (retval == null && oid.getObjectsRealClass() != null && callingMethod == 1) {
                        retval = this.prepareAndAddCache(this.broker, ocd, oid.getObjectsRealClass());
                    }
                }
            } else {
                Map map = this.caches;
                synchronized (map) {
                    retval = this.lookupCache(ocd);
                    if (retval == null && callingMethod == 1) {
                        retval = this.prepareAndAddCache(this.broker, ocd, ocd);
                    }
                }
            }
        } else {
            String jcdAlias = this.broker.serviceConnectionManager().getConnectionDescriptor().getJcdAlias();
            Map map = this.caches;
            synchronized (map) {
                retval = this.lookupCache(jcdAlias);
                if (retval == null && callingMethod == 1) {
                    retval = this.prepareAndAddCache(this.broker, ocd, jcdAlias);
                }
            }
        }
        return retval;
    }

    private ObjectCache lookupCache(Object key) {
        return (ObjectCache)this.caches.get(key);
    }

    protected ObjectCacheDescriptor searchInClassDescriptor(Identity oid) {
        return oid.getObjectsRealClass() != null ? this.broker.getClassDescriptor(oid.getObjectsRealClass()).getObjectCacheDescriptor() : null;
    }

    protected ObjectCacheDescriptor searchInJdbcConnectionDescriptor() {
        return this.broker.serviceConnectionManager().getConnectionDescriptor().getObjectCacheDescriptor();
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        return buf.append("Associated PB", (Object)this.broker).append("Used default cache", (Object)this.defaultCache).append("Mapped caches", (Object)this.caches).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

