/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.RsIterator;
import org.apache.ojb.broker.accesslayer.RsQueryObject;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.query.ReportQuery;
import org.apache.ojb.broker.util.JdbcTypesHelper;

public class ReportQueryRsIterator
extends RsIterator {
    private int m_attributeCount;
    private int[] m_jdbcTypes;

    public ReportQueryRsIterator(RsQueryObject queryObject, PersistenceBrokerImpl broker) {
        super(queryObject, broker);
        try {
            ReportQuery q = (ReportQuery)((Object)queryObject.getQuery());
            this.m_attributeCount = q.getAttributes().length;
            this.init_jdbcTypes();
        }
        catch (SQLException e) {
            this.releaseDbResources();
            throw new PersistenceBrokerException(e);
        }
    }

    private void init_jdbcTypes() throws SQLException {
        ReportQuery q = (ReportQuery)((Object)this.getQueryObject().getQuery());
        this.m_jdbcTypes = new int[this.m_attributeCount];
        if (q.getJdbcTypes() != null) {
            this.m_jdbcTypes = q.getJdbcTypes();
        } else {
            ResultSetMetaData rsMetaData = this.getRsAndStmt().m_rs.getMetaData();
            for (int i = 0; i < this.m_attributeCount; ++i) {
                this.m_jdbcTypes[i] = rsMetaData.getColumnType(i + 1);
            }
        }
    }

    protected Object getObjectFromResultSet() throws PersistenceBrokerException {
        Object[] result = new Object[this.m_attributeCount];
        for (int i = 0; i < this.m_attributeCount; ++i) {
            try {
                int jdbcType = this.m_jdbcTypes[i];
                result[i] = JdbcTypesHelper.getObjectFromColumn(this.getRsAndStmt().m_rs, new Integer(jdbcType), i + 1);
                continue;
            }
            catch (SQLException e) {
                throw new PersistenceBrokerException(e);
            }
        }
        return result;
    }
}

