/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.CollectionPrefetcher;
import org.apache.ojb.broker.accesslayer.MtoNCollectionPrefetcher;
import org.apache.ojb.broker.accesslayer.ReferencePrefetcher;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcher;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;

public class RelationshipPrefetcherFactory {
    public static RelationshipPrefetcher createRelationshipPrefetcher(PersistenceBrokerImpl aBroker, ObjectReferenceDescriptor ord) {
        if (ord instanceof CollectionDescriptor) {
            CollectionDescriptor cds = (CollectionDescriptor)ord;
            if (cds.isMtoNRelation()) {
                return new MtoNCollectionPrefetcher(aBroker, cds);
            }
            return new CollectionPrefetcher(aBroker, cds);
        }
        return new ReferencePrefetcher(aBroker, ord);
    }

    public static RelationshipPrefetcher createRelationshipPrefetcher(PersistenceBrokerImpl aBroker, ClassDescriptor anOwnerCld, String aRelationshipName) {
        ObjectReferenceDescriptor ord = anOwnerCld.getCollectionDescriptorByName(aRelationshipName);
        if (ord == null && (ord = anOwnerCld.getObjectReferenceDescriptorByName(aRelationshipName)) == null) {
            throw new PersistenceBrokerException("Relationship not found: " + aRelationshipName);
        }
        return RelationshipPrefetcherFactory.createRelationshipPrefetcher(aBroker, ord);
    }
}

