/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.preference.impl;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.portlet.PreferencesValidator;
import org.apache.jetspeed.om.common.preference.PreferenceSetComposite;
import org.apache.jetspeed.om.preference.impl.PrefsPreference;
import org.apache.pluto.om.common.Preference;

public class PrefsPreferenceSetImpl
implements PreferenceSetComposite {
    protected Preferences prefsRootNode;
    protected PreferencesValidator validator;

    public PrefsPreferenceSetImpl(Preferences prefsRootNode) throws BackingStoreException {
        this.prefsRootNode = prefsRootNode;
    }

    public Set getNames() {
        try {
            return new HashSet<String>(Arrays.asList(this.prefsRootNode.childrenNames()));
        }
        catch (BackingStoreException e) {
            String msg = "Preference backing store failed: " + e.toString();
            IllegalStateException ise = new IllegalStateException(msg);
            ise.initCause(e);
            throw ise;
        }
    }

    public void setPreferenceValidator(PreferencesValidator validator) {
        this.validator = validator;
    }

    public Preference get(String key) {
        try {
            if (this.prefsRootNode.nodeExists(key)) {
                return new PrefsPreference(this.prefsRootNode.node(key), key);
            }
            return null;
        }
        catch (IllegalStateException ise) {
            return null;
        }
        catch (BackingStoreException e) {
            String msg = "Preference backing store failed: " + e.toString();
            IllegalStateException ise = new IllegalStateException(msg);
            ise.initCause(e);
            throw ise;
        }
    }

    public PreferencesValidator getPreferencesValidator() {
        return this.validator;
    }

    public Preference add(String name, List values) {
        Iterator valuesItr = values.iterator();
        PrefsPreference pref = new PrefsPreference(this.prefsRootNode.node(name), name);
        while (valuesItr.hasNext()) {
            pref.addValue((String)valuesItr.next());
        }
        return pref;
    }

    public void remove(Preference pref) {
        this.remove(pref.getName());
    }

    public Preference remove(String key) {
        try {
            if (this.prefsRootNode.nodeExists(key)) {
                Preferences nodeToRemove = this.prefsRootNode.node(key);
                PrefsPreference pref = new PrefsPreference(nodeToRemove, key);
                nodeToRemove.removeNode();
                return pref;
            }
            return null;
        }
        catch (BackingStoreException e) {
            String msg = "Preference backing store failed: " + e.toString();
            IllegalStateException ise = new IllegalStateException(msg);
            ise.initCause(e);
            throw ise;
        }
    }

    public void flush() throws BackingStoreException {
        this.prefsRootNode.flush();
    }

    public void clear() throws BackingStoreException {
        this.prefsRootNode.removeNode();
    }

    public int size() {
        try {
            return this.prefsRootNode.childrenNames().length;
        }
        catch (IllegalStateException ise) {
            return 0;
        }
        catch (BackingStoreException e) {
            IllegalStateException ise = new IllegalStateException(e.toString());
            ise.initCause(e);
            throw ise;
        }
    }

    public Iterator iterator() {
        return new PortletPrefsIterator();
    }

    protected class PortletPrefsIterator
    implements Iterator {
        int beginSize;
        int pointer;
        String[] childrenNames;
        protected PrefsPreference currentPref;

        protected PortletPrefsIterator() {
            try {
                this.beginSize = PrefsPreferenceSetImpl.this.size();
                this.childrenNames = PrefsPreferenceSetImpl.this.prefsRootNode.childrenNames();
                this.pointer = 0;
            }
            catch (IllegalStateException ise) {
                this.childrenNames = new String[0];
            }
            catch (BackingStoreException e) {
                String msg = "Preference backing store failed: " + e.toString();
                IllegalStateException ise = new IllegalStateException(msg);
                ise.initCause(e);
                throw ise;
            }
        }

        public boolean hasNext() {
            if (this.beginSize != PrefsPreferenceSetImpl.this.size()) {
                throw new ConcurrentModificationException("Underlying PreferenceSet has changed.");
            }
            return this.pointer < this.beginSize;
        }

        public Object next() {
            if (this.beginSize != PrefsPreferenceSetImpl.this.size()) {
                throw new ConcurrentModificationException("Underlying PreferenceSet has changed.");
            }
            this.currentPref = (PrefsPreference)PrefsPreferenceSetImpl.this.get(this.childrenNames[this.pointer]);
            ++this.pointer;
            return this.currentPref;
        }

        public void remove() {
            if (this.currentPref == null) {
                throw new IllegalStateException(" next() must be called at least once before invoking remove().");
            }
            PrefsPreferenceSetImpl.this.remove((Preference)this.currentPref);
            this.beginSize = PrefsPreferenceSetImpl.this.size();
        }
    }
}

