/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.om.common.MutableLanguage;
import org.apache.jetspeed.om.common.Support;
import org.apache.jetspeed.om.impl.LanguageImpl;
import org.apache.pluto.om.common.Language;
import org.apache.pluto.om.common.LanguageSet;

public class LanguageSetImpl
implements LanguageSet,
Serializable,
Support {
    private ClassLoader classLoader = null;
    private String resources;
    protected Collection innerCollection;

    public LanguageSetImpl(Collection collection) {
        this.innerCollection = collection;
    }

    public LanguageSetImpl() {
        this(new ArrayList());
    }

    public Iterator iterator() {
        return this.innerCollection.iterator();
    }

    public Iterator getLocales() {
        HashSet<Locale> localSet = new HashSet<Locale>();
        Iterator itr = this.innerCollection.iterator();
        while (itr.hasNext()) {
            Language lang = (Language)itr.next();
            localSet.add(lang.getLocale());
        }
        return localSet.iterator();
    }

    public Language get(Locale locale) {
        Object fallBack = null;
        Iterator searchItr = this.innerCollection.iterator();
        while (searchItr.hasNext()) {
            Language lang = (Language)searchItr.next();
            if (lang.getLocale().equals(locale)) {
                if (this.resources != null) {
                    LanguageImpl language = (LanguageImpl)this.createLanguage(lang.getLocale(), this.loadResourceBundle(lang.getLocale()), "", "", "");
                    language.setTitle(lang.getTitle());
                    language.setShortTitle(lang.getShortTitle());
                    language.setKeywords(StringUtils.join((Iterator)lang.getKeywords(), (String)","));
                    return language;
                }
                return lang;
            }
            if (!lang.getLocale().getLanguage().equals(locale.getLanguage())) continue;
            fallBack = lang;
        }
        if (fallBack != null && this.resources != null) {
            LanguageImpl language = (LanguageImpl)this.createLanguage(fallBack.getLocale(), this.loadResourceBundle(fallBack.getLocale()), "", "", "");
            language.setTitle(fallBack.getTitle());
            language.setShortTitle(fallBack.getShortTitle());
            language.setKeywords(StringUtils.join((Iterator)fallBack.getKeywords(), (String)","));
            fallBack = language;
        }
        if (fallBack == null) {
            if (!this.getDefaultLocale().equals(locale)) {
                Language defaultLang = this.get(this.getDefaultLocale());
                fallBack = new LanguageImpl(locale, this.loadResourceBundle(locale), defaultLang.getTitle(), defaultLang.getShortTitle(), StringUtils.join((Iterator)defaultLang.getKeywords(), (String)","));
            } else {
                fallBack = new LanguageImpl(locale, this.loadResourceBundle(locale), "", "", "");
            }
            this.innerCollection.add(fallBack);
        }
        return fallBack;
    }

    public Locale getDefaultLocale() {
        return Locale.ENGLISH;
    }

    public boolean add(Object o) {
        if (o instanceof Language) {
            Language language = (Language)o;
            if (language.getLocale() == null) {
                ((MutableLanguage)o).setLocale(this.getDefaultLocale());
            }
            Iterator ite = this.innerCollection.iterator();
            while (ite.hasNext()) {
                Language lang = (Language)ite.next();
                if (!lang.getLocale().equals(language.getLocale())) continue;
                this.innerCollection.remove(lang);
                return this.innerCollection.add(o);
            }
            return this.innerCollection.add(o);
        }
        return false;
    }

    public boolean remove(Object o) {
        if (o instanceof Language) {
            Language language = (Language)o;
            Iterator ite = this.innerCollection.iterator();
            while (ite.hasNext()) {
                Language lang = (Language)ite.next();
                if (!lang.getLocale().equals(language.getLocale())) continue;
                return this.innerCollection.remove(lang);
            }
        }
        return false;
    }

    public Collection getInnerCollection() {
        return this.innerCollection;
    }

    public void setInnerCollection(Collection collection) {
        this.innerCollection = collection;
    }

    public int size() {
        return this.innerCollection.size();
    }

    public void setResources(String string) {
        this.resources = string;
    }

    public void postLoad(Object parameter) throws Exception {
        String title = "";
        String shortTitle = "";
        String keywords = "";
        Language defaultLang = this.get(this.getDefaultLocale());
        if (defaultLang != null) {
            title = defaultLang.getTitle();
            shortTitle = defaultLang.getShortTitle();
            keywords = StringUtils.join((Iterator)defaultLang.getKeywords(), (String)",");
        }
        ResourceBundle defaultResource = this.loadResourceBundle(this.getDefaultLocale());
        Iterator iter = ((Collection)parameter).iterator();
        while (iter.hasNext()) {
            Locale locale = (Locale)iter.next();
            ResourceBundle resource = this.loadResourceBundle(locale);
            if (resource == null) {
                resource = defaultResource;
            }
            Language language = this.createLanguage(locale, resource, title, shortTitle, keywords);
            this.add(language);
        }
        Language language = this.createLanguage(this.getDefaultLocale(), defaultResource, title, shortTitle, keywords);
        this.add(language);
    }

    protected ResourceBundle loadResourceBundle(Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            if (this.resources != null) {
                resourceBundle = this.classLoader != null ? ResourceBundle.getBundle(this.resources, locale, this.classLoader) : ResourceBundle.getBundle(this.resources, locale, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (MissingResourceException x) {
            return null;
        }
        return resourceBundle;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    private Language createLanguage(Locale locale, ResourceBundle bundle, String title, String shortTitle, String keywords) {
        LanguageImpl lang = new LanguageImpl(locale, bundle, title, shortTitle, keywords);
        return lang;
    }
}

