/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.portletentity;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.components.persistence.store.PersistenceStore;
import org.apache.jetspeed.components.persistence.store.PersistenceStoreRuntimeExcpetion;
import org.apache.jetspeed.components.persistence.store.RemovalAware;
import org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.MutablePortletEntity;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.om.common.portlet.PrincipalAware;
import org.apache.jetspeed.om.preference.impl.PrefsPreference;
import org.apache.jetspeed.om.preference.impl.PrefsPreferenceSetImpl;
import org.apache.jetspeed.om.window.impl.PortletWindowListImpl;
import org.apache.jetspeed.util.JetspeedObjectID;
import org.apache.pluto.om.common.Description;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.window.PortletWindowList;
import org.apache.pluto.util.StringUtils;

public class PortletEntityImpl
implements MutablePortletEntity,
PrincipalAware,
RemovalAware {
    private long oid;
    private long portletId;
    private JetspeedObjectID id;
    protected static PortletEntityAccessComponent pac;
    private static final Log log;
    protected List originalPreferences;
    protected ThreadLocal preferenceSetRef = new ThreadLocal();
    protected Map originalValues;
    private PortletApplicationEntity applicationEntity = null;
    private PortletWindowList portletWindows = new PortletWindowListImpl();
    private PortletEntity modifiedObject = null;
    private PortletDefinitionComposite portletDefinition = null;
    protected String portletName;
    protected String appName;
    private boolean dirty = false;
    protected ThreadLocal principalRef = new ThreadLocal();
    public static final String NO_PRINCIPAL = "no-principal";
    static /* synthetic */ Class class$org$apache$jetspeed$components$portletentity$PortletEntityImpl;

    public ObjectID getId() {
        return this.id;
    }

    public long getOid() {
        return this.oid;
    }

    public void setId(String id) {
        this.id = JetspeedObjectID.createFromString((String)id);
    }

    public PreferenceSet getPreferenceSet() {
        PrefsPreferenceSetImpl preferenceSet = (PrefsPreferenceSetImpl)this.preferenceSetRef.get();
        try {
            if (preferenceSet == null || !this.dirty) {
                Principal currentUser = this.getPrincipal();
                if (currentUser == null) {
                    currentUser = new PortletEntityUserPrincipal(NO_PRINCIPAL);
                }
                String prefNodePath = "portlet_entity/" + this.getId() + "/" + currentUser.getName() + "/" + "preferences";
                Preferences prefNode = Preferences.userRoot().node(prefNodePath);
                preferenceSet = new PrefsPreferenceSetImpl(prefNode);
                this.preferenceSetRef.set(preferenceSet);
                this.backupValues((PreferenceSet)preferenceSet);
                this.dirty = true;
            }
        }
        catch (BackingStoreException e) {
            String msg = "Preference backing store failed: " + e.toString();
            IllegalStateException ise = new IllegalStateException(msg);
            ise.initCause(e);
            throw ise;
        }
        return preferenceSet;
    }

    protected void backupValues(PreferenceSet preferenceSet) {
        this.originalValues = new HashMap();
        Iterator itr = preferenceSet.iterator();
        while (itr.hasNext()) {
            PrefsPreference pref = (PrefsPreference)itr.next();
            String[] currentValues = pref.getValueArray();
            String[] backUp = new String[currentValues.length];
            System.arraycopy(currentValues, 0, backUp, 0, currentValues.length);
            this.originalValues.put(pref.getName(), backUp);
        }
    }

    public PortletDefinition getPortletDefinition() {
        return this.portletDefinition;
    }

    public PortletApplicationEntity getPortletApplicationEntity() {
        return this.applicationEntity;
    }

    public PortletWindowList getPortletWindowList() {
        return this.portletWindows;
    }

    public void store() throws IOException {
        if (pac == null) {
            throw new IllegalStateException("You must call PortletEntityImpl.setPorteltEntityDao() before invoking PortletEntityImpl.store().");
        }
        PreferenceSet preferenceSet = (PreferenceSet)this.preferenceSetRef.get();
        pac.storePreferenceSet(preferenceSet, (PortletEntity)this);
        this.dirty = false;
        if (preferenceSet != null) {
            this.backupValues(preferenceSet);
        }
    }

    public void reset() throws IOException {
        PrefsPreferenceSetImpl preferenceSet = (PrefsPreferenceSetImpl)this.preferenceSetRef.get();
        try {
            if (this.originalValues != null && preferenceSet != null) {
                Iterator prefs = preferenceSet.iterator();
                while (prefs.hasNext()) {
                    PrefsPreference pref = (PrefsPreference)prefs.next();
                    if (this.originalValues.containsKey(pref.getName())) {
                        pref.setValues((String[])this.originalValues.get(pref.getName()));
                    } else {
                        preferenceSet.remove((Preference)pref);
                    }
                    preferenceSet.flush();
                }
                Iterator keys = this.originalValues.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (preferenceSet.get(key) != null) continue;
                    preferenceSet.add(key, Arrays.asList((String[])this.originalValues.get(key)));
                }
            }
            this.dirty = false;
            this.backupValues((PreferenceSet)preferenceSet);
        }
        catch (BackingStoreException e) {
            String msg = "Preference backing store failed: " + e.toString();
            IOException ioe = new IOException(msg);
            ioe.initCause(e);
            throw ioe;
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer(1000);
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append(this.getClass().toString());
        buffer.append(":");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("{");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("id='");
        buffer.append(this.oid);
        buffer.append("'");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("definition-id='");
        if (this.portletDefinition != null) {
            buffer.append(this.portletDefinition.getId().toString());
        } else {
            buffer.append("null");
        }
        buffer.append("'");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("}");
        return buffer.toString();
    }

    public Description getDescription(Locale arg0) {
        return this.portletDefinition.getDescription(arg0);
    }

    public void setPortletDefinition(PortletDefinition composite) {
        this.portletDefinition = (PortletDefinitionComposite)composite;
        this.appName = ((MutablePortletApplication)this.portletDefinition.getPortletApplicationDefinition()).getName();
        this.portletName = this.portletDefinition.getName();
    }

    public Principal getPrincipal() {
        return (Principal)this.principalRef.get();
    }

    protected void setPrincipal(Principal principal) {
        this.principalRef.set(principal);
    }

    public void postRemoval(PersistenceStore store) {
    }

    public void preRemoval(PersistenceStore store) {
        String rootForEntity = "portlet_entity/" + this.getId();
        try {
            if (Preferences.userRoot().nodeExists(rootForEntity)) {
                Preferences.userRoot().node(rootForEntity).removeNode();
            }
        }
        catch (BackingStoreException e) {
            throw new PersistenceStoreRuntimeExcpetion(e.toString(), (Throwable)e);
        }
    }

    public String getPortletUniqueName() {
        return this.appName + "::" + this.portletName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = LogFactory.getLog((Class)(class$org$apache$jetspeed$components$portletentity$PortletEntityImpl == null ? (class$org$apache$jetspeed$components$portletentity$PortletEntityImpl = PortletEntityImpl.class$("org.apache.jetspeed.components.portletentity.PortletEntityImpl")) : class$org$apache$jetspeed$components$portletentity$PortletEntityImpl));
    }

    class PortletEntityUserPrincipal
    implements Principal {
        String name;

        protected PortletEntityUserPrincipal(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof PortletEntityUserPrincipal) {
                PortletEntityUserPrincipal p = (PortletEntityUserPrincipal)obj;
                return this.name != null && p.name != null && this.name.equals(p.name);
            }
            return false;
        }

        public int hashCode() {
            if (this.name != null) {
                return (this.getClass().getName() + ":" + this.name).hashCode();
            }
            return -1;
        }

        public String toString() {
            return this.name;
        }
    }
}

