/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.portletentity;

import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.components.persistence.store.Filter;
import org.apache.jetspeed.components.persistence.store.LockFailedException;
import org.apache.jetspeed.components.persistence.store.PersistenceStore;
import org.apache.jetspeed.components.persistence.store.Transaction;
import org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent;
import org.apache.jetspeed.components.portletentity.PortletEntityImpl;
import org.apache.jetspeed.components.portletentity.PortletEntityNotDeletedException;
import org.apache.jetspeed.components.portletentity.PortletEntityNotGeneratedException;
import org.apache.jetspeed.components.portletentity.PortletEntityNotStoredException;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.om.common.portlet.MutablePortletApplication;
import org.apache.jetspeed.om.common.portlet.MutablePortletEntity;
import org.apache.jetspeed.om.common.portlet.PortletDefinitionComposite;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.preference.impl.PrefsPreferenceSetImpl;
import org.apache.jetspeed.util.JetspeedObjectID;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.entity.PortletEntityCtrl;
import org.apache.pluto.om.portlet.PortletDefinition;

public class PortletEntityAccessComponentImpl
implements PortletEntityAccessComponent {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$components$portletentity$PortletEntityAccessComponentImpl == null ? (class$org$apache$jetspeed$components$portletentity$PortletEntityAccessComponentImpl = PortletEntityAccessComponentImpl.class$("org.apache.jetspeed.components.portletentity.PortletEntityAccessComponentImpl")) : class$org$apache$jetspeed$components$portletentity$PortletEntityAccessComponentImpl));
    private boolean autoCreateNewEntities;
    private HashMap entityCache = new HashMap();
    private PersistenceStore persistenceStore;
    private PortletRegistry registry;
    protected Principal principal;
    static /* synthetic */ Class class$org$apache$jetspeed$components$portletentity$PortletEntityAccessComponentImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$components$portletentity$PortletEntityImpl;

    public PortletEntityAccessComponentImpl(PersistenceStore persistenceStore, PortletRegistry registry) {
        this.persistenceStore = persistenceStore;
        this.registry = registry;
        PortletEntityImpl.pac = this;
    }

    public MutablePortletEntity generateEntityFromFragment(Fragment fragment, String principal) throws PortletEntityNotGeneratedException {
        PortletDefinitionComposite pd = this.registry.getPortletDefinitionByUniqueName(fragment.getName());
        ObjectID entityKey = this.generateEntityKey(fragment, principal);
        MutablePortletEntity portletEntity = null;
        if (pd != null) {
            portletEntity = this.newPortletEntityInstance((PortletDefinition)pd);
            if (portletEntity == null) {
                throw new PortletEntityNotGeneratedException("Failed to create Portlet Entity for " + fragment.getName());
            }
        } else {
            String msg = "Failed to retrieve Portlet Definition for " + fragment.getName();
            log.warn((Object)msg);
            portletEntity = new PortletEntityImpl();
            fragment.overrideRenderedContent(msg);
        }
        portletEntity.setId(entityKey.toString());
        return portletEntity;
    }

    public MutablePortletEntity generateEntityFromFragment(Fragment fragment) throws PortletEntityNotGeneratedException {
        return this.generateEntityFromFragment(fragment, null);
    }

    public MutablePortletEntity getPortletEntityForFragment(Fragment fragment, String principal) {
        return this.getPortletEntity(this.generateEntityKey(fragment, principal));
    }

    public MutablePortletEntity getPortletEntityForFragment(Fragment fragment) {
        return this.getPortletEntity(this.generateEntityKey(fragment, null));
    }

    public ObjectID generateEntityKey(Fragment fragment, String principal) {
        StringBuffer key = new StringBuffer();
        if (principal != null && principal.length() > 0) {
            key.append(principal);
            key.append("/");
        }
        key.append(fragment.getId());
        return JetspeedObjectID.createFromString((String)key.toString());
    }

    public MutablePortletEntity getPortletEntity(String entityId) {
        JetspeedObjectID oid = JetspeedObjectID.createFromString((String)entityId);
        return this.getPortletEntity((ObjectID)oid);
    }

    public MutablePortletEntity getPortletEntity(ObjectID entityId) {
        if (this.entityCache.get(entityId) != null) {
            PortletEntityImpl entity = (PortletEntityImpl)this.entityCache.get(entityId);
            return entity;
        }
        PersistenceStore store = this.getPersistenceStore();
        this.prepareTransaction(store);
        Filter filter = store.newFilter();
        filter.addEqualTo("id", (Object)entityId.toString());
        Object q = store.newQuery(class$org$apache$jetspeed$components$portletentity$PortletEntityImpl == null ? (class$org$apache$jetspeed$components$portletentity$PortletEntityImpl = PortletEntityAccessComponentImpl.class$("org.apache.jetspeed.components.portletentity.PortletEntityImpl")) : class$org$apache$jetspeed$components$portletentity$PortletEntityImpl, filter);
        MutablePortletEntity portletEntity = (MutablePortletEntity)store.getObjectByQuery(q);
        if (portletEntity == null) {
            return null;
        }
        String portletUniqueName = portletEntity.getPortletUniqueName();
        PortletDefinitionComposite parentPortletDef = this.registry.getPortletDefinitionByUniqueName(portletUniqueName);
        portletEntity.setPortletDefinition((PortletDefinition)parentPortletDef);
        this.entityCache.put(entityId, portletEntity);
        return (PortletEntityImpl)portletEntity;
    }

    public MutablePortletEntity newPortletEntityInstance(PortletDefinition portletDefinition) {
        PortletEntityImpl portletEntity = new PortletEntityImpl();
        portletEntity.setPortletDefinition(portletDefinition);
        return portletEntity;
    }

    public void removePortletEntity(PortletEntity portletEntity) throws PortletEntityNotDeletedException {
        if (this.entityCache.containsKey(portletEntity.getId())) {
            this.entityCache.remove(this.entityCache.get(portletEntity.getId()));
        }
        PersistenceStore store = this.getPersistenceStore();
        try {
            this.prepareTransaction(store);
            this.entityCache.remove(portletEntity.getId());
            store.deletePersistent((Object)portletEntity);
            store.getTransaction().checkpoint();
        }
        catch (Exception e) {
            String msg = "Unable to delete Portlet Entity.";
            log.error((Object)msg, (Throwable)e);
            store.getTransaction().rollback();
            throw new PortletEntityNotDeletedException(msg, (Throwable)e);
        }
    }

    public void removeFromCache(PortletEntity entity) {
        this.entityCache.remove(entity.getId());
        try {
            this.persistenceStore.invalidate((Object)entity);
        }
        catch (LockFailedException e) {
            log.error((Object)("Unable to remove entity from PersistenceStoreCache " + e.toString()), (Throwable)e);
        }
    }

    public void storePortletEntity(PortletEntity portletEntity) throws PortletEntityNotStoredException {
        try {
            ((PortletEntityCtrl)portletEntity).store();
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            throw new PortletEntityNotStoredException(e.toString(), (Throwable)e);
        }
    }

    public Collection getPortletEntities(PortletDefinition portletDefinition) {
        this.prepareTransaction(this.persistenceStore);
        Filter filter = this.persistenceStore.newFilter();
        String appName = ((MutablePortletApplication)portletDefinition.getPortletApplicationDefinition()).getName();
        String portletName = portletDefinition.getName();
        filter.addEqualTo("appName", (Object)appName);
        filter.addEqualTo("portletName", (Object)portletName);
        return this.persistenceStore.getCollectionByQuery(this.persistenceStore.newQuery(class$org$apache$jetspeed$components$portletentity$PortletEntityImpl == null ? (class$org$apache$jetspeed$components$portletentity$PortletEntityImpl = PortletEntityAccessComponentImpl.class$("org.apache.jetspeed.components.portletentity.PortletEntityImpl")) : class$org$apache$jetspeed$components$portletentity$PortletEntityImpl, filter));
    }

    public void removePortletEntities(PortletDefinition portletDefinition) throws PortletEntityNotDeletedException {
        Iterator entities = this.getPortletEntities(portletDefinition).iterator();
        while (entities.hasNext()) {
            PortletEntity entity = (PortletEntity)entities.next();
            this.removePortletEntity(entity);
        }
    }

    private void autoCreateEntityId(PortletEntity realEntity, PersistenceStore store) throws Exception {
        PortletEntityImpl impl;
        if (realEntity instanceof PortletEntityImpl && (impl = (PortletEntityImpl)realEntity).getId() == null) {
            System.out.println("setting oid = " + impl.getOid());
            impl.setId(new Long(impl.getOid()).toString());
            store.lockForWrite((Object)realEntity);
            store.getTransaction().checkpoint();
        }
    }

    protected void prepareTransaction(PersistenceStore store) {
        Transaction tx = store.getTransaction();
        if (!tx.isOpen()) {
            tx.begin();
        }
    }

    protected PersistenceStore getPersistenceStore() {
        return this.persistenceStore;
    }

    public void storePreferenceSet(PreferenceSet prefSet, PortletEntity entity) throws IOException {
        PrefsPreferenceSetImpl preferenceSet = (PrefsPreferenceSetImpl)prefSet;
        try {
            this.prepareTransaction(this.persistenceStore);
            this.persistenceStore.lockForWrite((Object)entity);
            if (preferenceSet != null) {
                preferenceSet.flush();
            }
            this.persistenceStore.getTransaction().checkpoint();
        }
        catch (Exception e) {
            String msg = "Failed to store portlet entity:" + e.toString();
            IOException ioe = new IOException(msg);
            ioe.initCause(e);
            this.persistenceStore.getTransaction().rollback();
            throw ioe;
        }
    }

    public MutablePortletEntity newPortletEntityInstance(PortletDefinition portletDefinition, String id) {
        PortletEntityImpl portletEntity = new PortletEntityImpl();
        portletEntity.setPortletDefinition(portletDefinition);
        portletEntity.setId(id);
        return portletEntity;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

