/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.deploy;

import java.util.Arrays;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.xpath.XPath;

public class JetspeedWebApplicationRewriter {
    public static final String JETSPEED_CONTAINER = "JetspeedContainer";
    public static final String JETSPEED_SERVLET_XPATH = "/web-app/servlet/servlet-name[contains(child::text(), \"JetspeedContainer\")]";
    public static final String JETSPEED_SERVLET_MAPPING_XPATH = "/web-app/servlet-mapping/servlet-name[contains(child::text(), \"JetspeedContainer\")]";
    public static final String PORTLET_TAGLIB_XPATH = "/web-app/taglib/taglib-uri[contains(child::text(), \"http://java.sun.com/portlet\")]";
    protected static final String WEB_XML_PATH = "WEB-INF/web.xml";
    protected static final String[] ELEMENTS_BEFORE_SERVLET = new String[]{"icon", "display-name", "description", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet"};
    protected static final String[] ELEMENTS_BEFORE_SERVLET_MAPPING = new String[]{"icon", "display-name", "description", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet", "servlet-mapping"};
    protected static final String[] ELEMENTS_BEFORE_TAGLIB_MAPPING = new String[]{"icon", "display-name", "description", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet", "servlet-mapping", "session-config", "mime-mapping", "welcome-file-list", "error-page", "taglib"};
    private Document document;
    private String portletApplication;
    private boolean changed = false;
    private boolean portletTaglibAdded = false;

    public JetspeedWebApplicationRewriter(Document doc, String portletApplication) {
        this.document = doc;
        this.portletApplication = portletApplication;
    }

    public JetspeedWebApplicationRewriter(Document doc) {
        this.document = doc;
    }

    public void processWebXML() throws Exception {
        try {
            Element jetspeedServletElement;
            Element root = this.document.getRootElement();
            Object jetspeedServlet = XPath.selectSingleNode((Object)this.document, (String)JETSPEED_SERVLET_XPATH);
            Object jetspeedServletMapping = XPath.selectSingleNode((Object)this.document, (String)JETSPEED_SERVLET_MAPPING_XPATH);
            Object portletTaglib = XPath.selectSingleNode((Object)this.document, (String)PORTLET_TAGLIB_XPATH);
            if (!this.document.hasRootElement()) {
                root = new Element("web-app");
                this.document.setRootElement(root);
            }
            if (jetspeedServlet == null) {
                jetspeedServletElement = new Element("servlet");
                Element servletName = new Element("servlet-name").addContent(JETSPEED_CONTAINER);
                Element servletDspName = new Element("display-name").addContent("Jetspeed Container");
                Element servletDesc = new Element("description").addContent("MVC Servlet for Jetspeed Portlet Applications");
                Element servletClass = new Element("servlet-class").addContent("org.apache.jetspeed.container.JetspeedContainerServlet");
                jetspeedServletElement.addContent((Content)servletName);
                jetspeedServletElement.addContent((Content)servletDspName);
                jetspeedServletElement.addContent((Content)servletDesc);
                jetspeedServletElement.addContent((Content)servletClass);
                this.insertContextNameParam(jetspeedServletElement);
                this.insertLoadOnStartup(jetspeedServletElement);
                this.insertElementCorrectly(root, jetspeedServletElement, ELEMENTS_BEFORE_SERVLET);
                this.changed = true;
            } else if (jetspeedServlet instanceof Element) {
                jetspeedServletElement = ((Element)jetspeedServlet).getParent();
                if (null == XPath.selectSingleNode((Object)jetspeedServletElement, (String)"init-param/param-name[contains(child::text(), \"contextName\")]")) {
                    this.insertContextNameParam(jetspeedServletElement);
                }
                if (null == XPath.selectSingleNode((Object)jetspeedServletElement, (String)"load-on-startup")) {
                    this.insertLoadOnStartup(jetspeedServletElement);
                }
            }
            if (jetspeedServletMapping == null) {
                Element jetspeedServletMappingElement = new Element("servlet-mapping");
                Element servletMapName = new Element("servlet-name").addContent(JETSPEED_CONTAINER);
                Element servletUrlPattern = new Element("url-pattern").addContent("/container/*");
                jetspeedServletMappingElement.addContent((Content)servletMapName);
                jetspeedServletMappingElement.addContent((Content)servletUrlPattern);
                this.insertElementCorrectly(root, jetspeedServletMappingElement, ELEMENTS_BEFORE_SERVLET_MAPPING);
                this.changed = true;
            }
            if (portletTaglib == null) {
                Element taglib = new Element("taglib");
                Element taguri = new Element("taglib-uri").addContent("http://java.sun.com/portlet");
                Element taglocation = new Element("taglib-location").addContent("/WEB-INF/tld/portlet.tld");
                taglib.addContent((Content)taguri);
                taglib.addContent((Content)taglocation);
                this.insertElementCorrectly(root, taglib, ELEMENTS_BEFORE_TAGLIB_MAPPING);
                this.changed = true;
                this.portletTaglibAdded = true;
            }
        }
        catch (Exception e) {
            throw new Exception("Unable to process web.xml for infusion " + e.toString(), e);
        }
    }

    private void insertContextNameParam(Element jetspeedServletElement) {
        Element param2Name = new Element("param-name").addContent("contextName");
        Element param2Value = new Element("param-value").addContent(this.portletApplication);
        Element init2Param = new Element("init-param");
        init2Param.addContent((Content)param2Name);
        init2Param.addContent((Content)param2Value);
        jetspeedServletElement.addContent((Content)init2Param);
    }

    private void insertLoadOnStartup(Element jetspeedServletElement) {
        Element loadOnStartup = new Element("load-on-startup").addContent("0");
        jetspeedServletElement.addContent((Content)loadOnStartup);
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void insertElementCorrectly(Element root, Element toInsert, String[] elementsBefore) throws Exception {
        List allChildren = root.getChildren();
        List<String> elementsBeforeList = Arrays.asList(elementsBefore);
        toInsert.detach();
        int insertAfter = 0;
        int count = 0;
        for (int i = 0; i < allChildren.size(); ++i) {
            Element element = (Element)allChildren.get(i);
            if (elementsBeforeList.contains(element.getName())) {
                insertAfter = root.indexOf((Content)element);
            }
            ++count;
        }
        insertAfter = count == 0 ? 0 : insertAfter + 1;
        try {
            root.addContent(insertAfter, (Content)toInsert);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            root.addContent((Content)toInsert);
        }
    }

    public boolean isPortletTaglibAdded() {
        return this.portletTaglibAdded;
    }
}

