/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.jetspeed.tools.deploy.Deploy;
import org.apache.jetspeed.tools.deploy.JetspeedContextRewriter;
import org.apache.jetspeed.tools.deploy.JetspeedWebApplicationRewriter;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JetspeedDeploy
implements Deploy {
    private final byte[] buffer = new byte[4096];

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args.length > 3 || args.length == 3 && !args[0].equalsIgnoreCase("-s")) {
            System.out.println("Usage: java -jar jetspeed-deploy-tools-<version>.jar [-s] INPUT OUTPUT");
            System.out.println("Options:");
            System.out.println("  -s: stripLoggers - remove commons-logging[version].jar and/or log4j[version].jar from war");
            System.out.println("                     (required when targetting application servers like JBoss)");
            System.exit(1);
            return;
        }
        new JetspeedDeploy(args[0], args[1], args.length == 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JetspeedDeploy(String inputName, String outputName, boolean stripLoggers) throws Exception {
        IOException e122;
        File tempFile = null;
        ZipFile jin = null;
        ZipOutputStream jout = null;
        AbstractInterruptibleChannel srcChannel = null;
        AbstractInterruptibleChannel dstChannel = null;
        try {
            String portletApplicationName = this.getPortletApplicationName(outputName);
            tempFile = File.createTempFile(portletApplicationName, "");
            tempFile.deleteOnExit();
            jin = new JarFile(inputName);
            jout = new JarOutputStream(new FileOutputStream(tempFile));
            Document webXml = null;
            Document portletXml = null;
            Document contextXml = null;
            Enumeration<JarEntry> zipEntries = ((JarFile)jin).entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry src = zipEntries.nextElement();
                InputStream source = ((JarFile)jin).getInputStream(src);
                try {
                    String target = src.getName();
                    if ("WEB-INF/web.xml".equals(target)) {
                        System.out.println("Found web.xml");
                        webXml = this.parseXml(source);
                        continue;
                    }
                    if ("WEB-INF/portlet.xml".equals(target)) {
                        System.out.println("Found WEB-INF/portlet.xml");
                        portletXml = this.parseXml(source);
                        continue;
                    }
                    if ("META-INF/context.xml".equals(target)) {
                        System.out.println("Found META-INF/context.xml");
                        contextXml = this.parseXml(source);
                        continue;
                    }
                    if (stripLoggers && target.endsWith(".jar") && (target.startsWith("WEB-INF/lib/commons-logging") || target.startsWith("WEB-INF/lib/log4j"))) {
                        System.out.println("Stripping logger " + target);
                        continue;
                    }
                    this.addFile(target, source, (JarOutputStream)jout);
                }
                finally {
                    source.close();
                }
            }
            if (webXml == null) {
                throw new IllegalArgumentException("WEB-INF/web.xml");
            }
            if (portletXml == null) {
                throw new IllegalArgumentException("WEB-INF/portlet.xml");
            }
            JetspeedWebApplicationRewriter webRewriter = new JetspeedWebApplicationRewriter(webXml, portletApplicationName);
            webRewriter.processWebXML();
            JetspeedContextRewriter contextRewriter = new JetspeedContextRewriter(contextXml, portletApplicationName);
            contextRewriter.processContextXML();
            this.addFile("WEB-INF/web.xml", webXml, (JarOutputStream)jout);
            this.addFile("WEB-INF/portlet.xml", portletXml, (JarOutputStream)jout);
            this.addFile("META-INF/context.xml", contextXml, (JarOutputStream)jout);
            if (webRewriter.isPortletTaglibAdded()) {
                System.out.println("Attempting to add portlet.tld to war...");
                InputStream is = this.getClass().getResourceAsStream("/org/apache/jetspeed/tools/deploy/portlet.tld");
                if (is == null) {
                    System.out.println("Failed to find portlet.tld in classpath");
                } else {
                    System.out.println("Adding portlet.tld to war...");
                    try {
                        this.addFile("WEB-INF/tld/portlet.tld", is, (JarOutputStream)jout);
                    }
                    finally {
                        is.close();
                    }
                }
            }
            jout.close();
            jin.close();
            jin = null;
            jout = null;
            System.out.println("Creating war " + outputName + " ...");
            System.out.flush();
            srcChannel = new FileInputStream(tempFile).getChannel();
            dstChannel = new FileOutputStream(outputName).getChannel();
            ((FileChannel)dstChannel).transferFrom((ReadableByteChannel)((Object)srcChannel), 0L, ((FileChannel)srcChannel).size());
            srcChannel.close();
            srcChannel = null;
            dstChannel.close();
            dstChannel = null;
            tempFile.delete();
            tempFile = null;
            System.out.println("War " + outputName + " created");
            System.out.flush();
            Object var21_21 = null;
        }
        catch (Throwable throwable) {
            IOException e122;
            Object var21_22 = null;
            if (srcChannel != null && srcChannel.isOpen()) {
                try {
                    srcChannel.close();
                }
                catch (IOException e122) {
                    // empty catch block
                }
            }
            if (dstChannel != null && dstChannel.isOpen()) {
                try {
                    dstChannel.close();
                }
                catch (IOException e122) {
                    // empty catch block
                }
            }
            if (jin != null) {
                try {
                    jin.close();
                    jin = null;
                }
                catch (IOException e122) {
                    // empty catch block
                }
            }
            if (jout != null) {
                try {
                    jout.close();
                    jout = null;
                }
                catch (IOException e122) {
                    // empty catch block
                }
            }
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
            throw throwable;
        }
        if (srcChannel != null && srcChannel.isOpen()) {
            try {
                srcChannel.close();
            }
            catch (IOException e122) {
                // empty catch block
            }
        }
        if (dstChannel != null && dstChannel.isOpen()) {
            try {
                dstChannel.close();
            }
            catch (IOException e122) {
                // empty catch block
            }
        }
        if (jin != null) {
            try {
                jin.close();
                jin = null;
            }
            catch (IOException e122) {
                // empty catch block
            }
        }
        if (jout != null) {
            try {
                jout.close();
                jout = null;
            }
            catch (IOException e122) {
                // empty catch block
            }
        }
        if (tempFile != null && tempFile.exists()) {
            tempFile.delete();
        }
    }

    protected Document parseXml(InputStream source) throws Exception {
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.equals("http://java.sun.com/dtd/web-app_2_3.dtd")) {
                    return new InputSource(this.getClass().getResourceAsStream("web-app_2_3.dtd"));
                }
                return null;
            }
        });
        Document document = saxBuilder.build(source);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFile(String path, InputStream source, JarOutputStream jos) throws IOException {
        jos.putNextEntry(new ZipEntry(path));
        try {
            int count;
            while ((count = source.read(this.buffer)) > 0) {
                jos.write(this.buffer, 0, count);
            }
        }
        finally {
            jos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFile(String path, Document source, JarOutputStream jos) throws IOException {
        if (source != null) {
            jos.putNextEntry(new ZipEntry(path));
            XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
            try {
                xmlOutputter.output(source, (OutputStream)jos);
            }
            finally {
                jos.closeEntry();
            }
        }
    }

    protected String getPortletApplicationName(String path) {
        String name;
        File file = new File(path);
        String portletApplicationName = name = file.getName();
        int index = name.lastIndexOf(".");
        if (index > -1) {
            portletApplicationName = name.substring(0, index);
        }
        return portletApplicationName;
    }
}

