/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.deploy;

import org.jdom.Document;
import org.jdom.Element;

public class JetspeedContextRewriter {
    private Document document;
    private String portletApplication;
    private boolean changed = false;

    public JetspeedContextRewriter(Document doc, String portletApplication) {
        this.document = doc;
        this.portletApplication = portletApplication;
    }

    public void processContextXML() throws Exception {
        if (this.document != null) {
            try {
                String docBaseAttribute;
                Element root = null;
                if (!this.document.hasRootElement()) {
                    root = new Element("Context");
                    this.document.setRootElement(root);
                } else {
                    root = this.document.getRootElement();
                }
                String pathAttribute = root.getAttributeValue("path");
                if (pathAttribute == null || !pathAttribute.equals("/" + this.portletApplication)) {
                    root.setAttribute("path", "/" + this.portletApplication);
                    this.changed = true;
                }
                if ((docBaseAttribute = root.getAttributeValue("docBase")) == null || !docBaseAttribute.equals(this.portletApplication)) {
                    root.setAttribute("docBase", this.portletApplication);
                    this.changed = true;
                }
            }
            catch (Exception e) {
                throw new Exception("Unable to process context.xml for infusion " + e.toString(), e);
            }
        }
    }
}

