/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.security.PortalResourcePermission;
import org.apache.jetspeed.security.PortalResourcePermissionCollection;

public class FolderPermission
extends PortalResourcePermission {
    public static final char RECURSIVE_CHAR = '-';
    public static final char WILD_CHAR = '*';
    public static final char FOLDER_SEPARATOR = '/';
    private transient boolean folder;
    private transient boolean recursive;
    private transient String cpath;

    public FolderPermission(String name, String actions) {
        this(name, actions, null);
    }

    public FolderPermission(String name, String actions, Subject subject) {
        super(name, actions, subject);
        this.parseActions(actions);
        this.subject = subject;
    }

    public PermissionCollection newPermissionCollection() {
        return new PortalResourcePermissionCollection();
    }

    private void parseActions(String actions) {
        this.mask = 0;
        if (actions != null) {
            StringTokenizer tokenizer = new StringTokenizer(actions, ",\t ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals(JetspeedActions.VIEW)) {
                    this.mask |= 8;
                    continue;
                }
                if (token.equals(JetspeedActions.VIEW) || token.equals("restore")) {
                    this.mask |= 8;
                    continue;
                }
                if (token.equals(JetspeedActions.EDIT)) {
                    this.mask |= 0x10;
                    continue;
                }
                if (token.equals(JetspeedActions.MINIMIZE)) {
                    this.mask |= 1;
                    continue;
                }
                if (token.equals(JetspeedActions.MAXIMIZE)) {
                    this.mask |= 2;
                    continue;
                }
                if (token.equals(JetspeedActions.HELP)) {
                    this.mask |= 0x20;
                    continue;
                }
                if (token.equals("secure")) {
                    this.mask |= 0x40;
                    continue;
                }
                throw new IllegalArgumentException("Unknown action: " + token);
            }
        }
        if ((this.cpath = this.getName()) == null) {
            throw new NullPointerException("name can't be null");
        }
        if (this.cpath.equals("<<ALL FILES>>")) {
            this.folder = true;
            this.recursive = true;
            this.cpath = "";
            return;
        }
        int len = this.cpath.length();
        if (len == 0) {
            throw new IllegalArgumentException("invalid folder reference");
        }
        char last = this.cpath.charAt(len - 1);
        if (last == '-' && (len == 1 || this.cpath.charAt(len - 2) == '/')) {
            this.folder = true;
            this.recursive = true;
            this.cpath = this.cpath.substring(0, --len);
        } else if (last == '*' && (len == 1 || this.cpath.charAt(len - 2) == '/')) {
            this.folder = true;
            this.cpath = this.cpath.substring(0, --len);
        }
    }

    public boolean implies(Permission p) {
        if (!(p instanceof FolderPermission)) {
            return false;
        }
        FolderPermission that = (FolderPermission)p;
        return (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
    }

    boolean impliesIgnoreMask(FolderPermission that) {
        if (this.folder) {
            if (this.recursive) {
                if (that.folder) {
                    return that.cpath.length() >= this.cpath.length() && that.cpath.startsWith(this.cpath);
                }
                return that.cpath.length() > this.cpath.length() && that.cpath.startsWith(this.cpath);
            }
            if (that.folder) {
                if (that.recursive) {
                    return false;
                }
                return this.cpath.equals(that.cpath);
            }
            int last = that.cpath.lastIndexOf(47);
            if (last == -1) {
                return false;
            }
            return this.cpath.length() == last + 1 && this.cpath.regionMatches(0, that.cpath, 0, last + 1);
        }
        return this.cpath.equals(that.cpath);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FolderPermission)) {
            return false;
        }
        FolderPermission that = (FolderPermission)obj;
        return this.mask == that.mask && this.cpath.equals(that.cpath) && this.folder == that.folder && this.recursive == that.recursive;
    }

    public int hashCode() {
        return this.cpath.hashCode();
    }
}

