/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.impl;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.cache.file.FileCache;
import org.apache.jetspeed.cache.file.FileCacheEntry;
import org.apache.jetspeed.cache.file.FileCacheEventListener;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.folder.DocumentSet;
import org.apache.jetspeed.om.folder.DocumentSetPath;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.om.folder.impl.FolderImpl;
import org.apache.jetspeed.om.page.Document;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.AbstractNode;
import org.apache.jetspeed.page.document.DocumentException;
import org.apache.jetspeed.page.document.DocumentHandlerFactory;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.FolderHandler;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.NodeSetImpl;
import org.apache.jetspeed.page.document.UnsupportedDocumentTypeException;
import org.apache.jetspeed.page.impl.AbstractPageManager;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.ProfileLocatorProperty;
import org.apache.jetspeed.profiler.ProfiledPageContext;

public class CastorXmlPageManager
extends AbstractPageManager
implements PageManager,
FileCacheEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$page$impl$CastorXmlPageManager == null ? (class$org$apache$jetspeed$page$impl$CastorXmlPageManager = CastorXmlPageManager.class$("org.apache.jetspeed.page.impl.CastorXmlPageManager")) : class$org$apache$jetspeed$page$impl$CastorXmlPageManager));
    protected static final String PROFILE_PROPERTY_FOLDER_PREFIX = "_";
    protected static final String PROFILE_NAVIGATION_PROPERTY_FOLDER_PREFIX = "__";
    private DocumentHandlerFactory handlerFactory;
    private FolderHandler folderHandler;
    private boolean profilingEnabled;
    private Map pageContextCache;
    private Map perl5PathRegexpCache;
    private FileCache fileCache;
    static /* synthetic */ Class class$org$apache$jetspeed$page$impl$CastorXmlPageManager;

    public CastorXmlPageManager(IdGenerator generator, DocumentHandlerFactory handlerFactory, FolderHandler folderHandler, FileCache fileCache, int cacheSize, boolean profilingEnabled, boolean permissionsEnabled, boolean constraintsEnabled) throws FileNotFoundException {
        super(generator, permissionsEnabled, constraintsEnabled);
        handlerFactory.setPermissionsEnabled(permissionsEnabled);
        handlerFactory.setConstraintsEnabled(constraintsEnabled);
        this.handlerFactory = handlerFactory;
        this.folderHandler = folderHandler;
        this.fileCache = fileCache;
        this.fileCache.addListener((FileCacheEventListener)this);
        this.profilingEnabled = profilingEnabled;
        this.initCaches(cacheSize);
    }

    public CastorXmlPageManager(IdGenerator generator, DocumentHandlerFactory handlerFactory, FolderHandler folderHandler, FileCache fileCache, int cacheSize, boolean profilingEnabled, boolean permissionsEnabled, boolean constraintsEnabled, List modelClasses) throws FileNotFoundException {
        super(generator, permissionsEnabled, constraintsEnabled, modelClasses);
        handlerFactory.setPermissionsEnabled(permissionsEnabled);
        handlerFactory.setConstraintsEnabled(constraintsEnabled);
        this.handlerFactory = handlerFactory;
        this.folderHandler = folderHandler;
        this.fileCache = fileCache;
        this.fileCache.addListener((FileCacheEventListener)this);
        this.profilingEnabled = profilingEnabled;
        this.initCaches(cacheSize);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeProfiledPageContext(ProfiledPageContext pageContext) throws PageNotFoundException, DocumentException, NodeException {
        ArrayList<AbstractNode> allProfiledFolders;
        HashMap documentSetNodeSets;
        HashMap documentSetNames;
        NodeSetImpl documentSets;
        NodeSet rootLinks;
        NodeSet siblingFolders;
        Folder parentFolder;
        NodeSet siblingPages;
        Page page;
        Folder folder;
        AbstractPageManager.CacheablePageContext cachedPageContext;
        String pageContextCacheKey;
        block42: {
            String requestPath;
            block43: {
                pageContextCacheKey = this.pageContextCacheKey(pageContext);
                log.debug((Object)("computeProfiledPageContext() invoked, cache key = " + pageContextCacheKey + ", (profilingEnabled = " + this.profilingEnabled + ")"));
                cachedPageContext = this.lookupPageContext(pageContextCacheKey);
                if (cachedPageContext != null) {
                    this.populateProfiledPageContext(cachedPageContext, pageContext);
                    return;
                }
                ProfileLocator locator = this.selectPageProfileLocator(pageContext.getLocators());
                requestPath = locator.getRequestPath();
                folder = null;
                page = null;
                siblingPages = null;
                parentFolder = null;
                siblingFolders = null;
                rootLinks = null;
                documentSets = null;
                documentSetNames = null;
                documentSetNodeSets = null;
                allProfiledFolders = null;
                if (!this.profilingEnabled) break block43;
                Folder[] profiledFolder = new Folder[1];
                Page[] profiledPage = new Page[1];
                ArrayList profiledFolders = new ArrayList(16);
                ArrayList searchProfiledFolders = new ArrayList(24);
                List searchPaths = this.generateProfilingSearchPaths(requestPath, locator, false);
                boolean profiled = this.findProfiledPageAndFolders(searchPaths, profiledPage, profiledFolder, profiledFolders, searchProfiledFolders);
                boolean rootFallback = false;
                rootFallback = !profiled && !requestPath.equals("/");
                if (rootFallback) {
                    searchPaths = this.generateProfilingSearchPaths("/", locator, true);
                    profiled = this.findProfiledPageAndFolders(searchPaths, profiledPage, profiledFolder, profiledFolders, searchProfiledFolders);
                    if (profiled && pageContext.getLocators().size() > 1) {
                        Page[] alternateProfiledPage = new Page[1];
                        Iterator locatorsIter = this.selectAlternatePageProfileLocators(pageContext.getLocators()).iterator();
                        while (alternateProfiledPage[0] == null && locatorsIter.hasNext()) {
                            ProfileLocator alternateLocator = (ProfileLocator)locatorsIter.next();
                            List alternateSearchPaths = this.generateProfilingSearchPaths(requestPath, alternateLocator, false);
                            this.findProfiledPageAndFolders(alternateSearchPaths, alternateProfiledPage);
                        }
                        if (alternateProfiledPage[0] != null) {
                            log.debug((Object)("computeProfiledPageContext(): Using alternate locator match " + alternateProfiledPage[0] + " for " + requestPath));
                            profiledPage[0] = alternateProfiledPage[0];
                        } else {
                            log.warn((Object)("computeProfiledPageContext(): No alternate locator match: falling back to profiled root default page for " + requestPath));
                        }
                    } else {
                        log.warn((Object)("computeProfiledPageContext(): Falling back to profiled root default page for " + requestPath));
                    }
                }
                if (profiled) {
                    folder = (Folder)this.setProfiledNodePathAndUrl((AbstractNode)profiledFolder[0]);
                    page = (Page)this.setProfiledNodePathAndUrl((AbstractNode)profiledPage[0]);
                }
                if (page != null && folder != null) {
                    AbstractNode parentFolderNode;
                    allProfiledFolders = new ArrayList<AbstractNode>(24);
                    Iterator foldersIter = profiledFolders.iterator();
                    while (foldersIter.hasNext()) {
                        FolderImpl profiledPageFolder = (FolderImpl)foldersIter.next();
                        if (profiledPageFolder.isHidden()) continue;
                        allProfiledFolders.add(this.setProfiledNodePathAndUrl(profiledPageFolder));
                    }
                    Vector documentOrder = null;
                    foldersIter = searchProfiledFolders.iterator();
                    while (documentOrder == null && foldersIter.hasNext()) {
                        FolderImpl profiledPageFolder = (FolderImpl)this.setProfiledNodePathAndUrl((AbstractNode)foldersIter.next());
                        if (profiledPageFolder.getMetaData() == null || profiledPageFolder.getMetaData().getDocumentOrder() == null || profiledPageFolder.getMetaData().getDocumentOrder().isEmpty()) continue;
                        documentOrder = profiledPageFolder.getMetaData().getDocumentOrder();
                    }
                    DocumentOrderComparator documentComparator = new DocumentOrderComparator(documentOrder);
                    siblingPages = new NodeSetImpl(null, documentComparator);
                    siblingPages = this.addUniqueOrDescribedUrlNode((NodeSetImpl)siblingPages, (AbstractNode)page);
                    foldersIter = profiledFolders.iterator();
                    while (foldersIter.hasNext()) {
                        FolderImpl aggregatePagesFolder = (FolderImpl)foldersIter.next();
                        NodeSet aggregatePages = aggregatePagesFolder.getPages(false);
                        Iterator aggregatePagesIter = aggregatePages.iterator();
                        while (aggregatePagesIter.hasNext()) {
                            AbstractNode siblingPageNode = (AbstractNode)aggregatePagesIter.next();
                            if (siblingPageNode.isHidden()) continue;
                            siblingPages = this.addUniqueOrDescribedUrlNode((NodeSetImpl)siblingPages, this.setProfiledNodePathAndUrl(siblingPageNode));
                        }
                    }
                    if (((AbstractNode)folder).getParent(false) != null && !((AbstractNode)folder).getProfiledPath().equals("/") && !(parentFolderNode = (AbstractNode)((AbstractNode)folder).getParent(false)).isHidden()) {
                        parentFolder = (Folder)this.setProfiledNodePathAndUrl(parentFolderNode);
                        allProfiledFolders.add((AbstractNode)parentFolder);
                    }
                    siblingFolders = new NodeSetImpl(null, documentComparator);
                    foldersIter = profiledFolders.iterator();
                    while (foldersIter.hasNext()) {
                        FolderImpl aggregateFoldersFolder = (FolderImpl)foldersIter.next();
                        NodeSet aggregateFolders = aggregateFoldersFolder.getFolders(false).exclusiveSubset("^.*/__[^/]*$").exclusiveSubset("^.*/_[^/]*$");
                        Iterator aggregateFoldersIter = aggregateFolders.iterator();
                        while (aggregateFoldersIter.hasNext()) {
                            AbstractNode siblingFolderNode = (AbstractNode)aggregateFoldersIter.next();
                            if (siblingFolderNode.isHidden()) continue;
                            siblingFolders = this.addUniqueOrDescribedUrlNode((NodeSetImpl)siblingFolders, this.setProfiledNodePathAndUrl(siblingFolderNode));
                            allProfiledFolders.add(siblingFolderNode);
                        }
                    }
                    HashMap<String, AbstractNode> aggregateDocumentSets = new HashMap<String, AbstractNode>(12);
                    foldersIter = searchProfiledFolders.iterator();
                    while (foldersIter.hasNext()) {
                        FolderImpl aggregateFolder = (FolderImpl)foldersIter.next();
                        NodeSet aggregateFolderDocumentSets = aggregateFolder.getDocumentSets(false);
                        Iterator aggregateFolderDocumentSetsIter = aggregateFolderDocumentSets.iterator();
                        while (aggregateFolderDocumentSetsIter.hasNext()) {
                            String documentSetProfiledPath;
                            AbstractNode documentSetNode = this.setProfiledNodePathAndUrl((AbstractNode)aggregateFolderDocumentSetsIter.next());
                            if (documentSetNode.isHidden() || aggregateDocumentSets.containsKey(documentSetProfiledPath = documentSetNode.getProfiledPath())) continue;
                            aggregateDocumentSets.put(documentSetProfiledPath, documentSetNode);
                        }
                    }
                    if (!aggregateDocumentSets.isEmpty()) {
                        documentSets = new NodeSetImpl(null, documentComparator);
                        documentSetNames = new HashMap(aggregateDocumentSets.size() * 2);
                        documentSetNodeSets = new HashMap(aggregateDocumentSets.size() * 2);
                        Iterator documentSetsIter = aggregateDocumentSets.values().iterator();
                        while (documentSetsIter.hasNext()) {
                            DocumentSet documentSet = (DocumentSet)documentSetsIter.next();
                            NodeSetImpl documentSetNodes = this.expandAndProfileDocumentSet(pageContext.getLocators(), documentSet, null, "", documentSetNames, documentSetNodeSets, allProfiledFolders);
                            if (documentSetNodes == null) continue;
                            documentSets.add((Node)documentSet);
                        }
                    }
                    if (!rootFallback && !requestPath.equals("/")) {
                        searchPaths = this.generateProfilingSearchPaths("/", locator, true);
                        profiled = this.findProfiledPageAndFolders(searchPaths, profiledPage, profiledFolder, profiledFolders, searchProfiledFolders);
                    }
                    if (profiled) {
                        Vector linkDocumentOrder = null;
                        foldersIter = profiledFolders.iterator();
                        while (linkDocumentOrder == null && foldersIter.hasNext()) {
                            FolderImpl profiledRootFolder = (FolderImpl)this.setProfiledNodePathAndUrl((AbstractNode)foldersIter.next());
                            if (!profiledRootFolder.getProfiledPath().equals("/") || profiledRootFolder.getMetaData() == null || profiledRootFolder.getMetaData().getDocumentOrder() == null || profiledRootFolder.getMetaData().getDocumentOrder().isEmpty()) continue;
                            linkDocumentOrder = profiledRootFolder.getMetaData().getDocumentOrder();
                        }
                        DocumentOrderComparator linkDocumentComparator = new DocumentOrderComparator(linkDocumentOrder);
                        rootLinks = new NodeSetImpl(null, linkDocumentComparator);
                        foldersIter = profiledFolders.iterator();
                        while (foldersIter.hasNext()) {
                            FolderImpl aggregateLinksFolder = (FolderImpl)this.setProfiledNodePathAndUrl((AbstractNode)foldersIter.next());
                            if (!aggregateLinksFolder.getProfiledPath().equals("/")) continue;
                            NodeSet aggregateLinks = aggregateLinksFolder.getLinks(false);
                            Iterator aggregateLinksIter = aggregateLinks.iterator();
                            while (aggregateLinksIter.hasNext()) {
                                AbstractNode rootLinkNode = (AbstractNode)aggregateLinksIter.next();
                                if (rootLinkNode.isHidden()) continue;
                                rootLinks = this.addUniqueOrDescribedUrlNode((NodeSetImpl)rootLinks, this.setProfiledNodePathAndUrl(rootLinkNode));
                            }
                        }
                        break block42;
                    } else {
                        rootLinks = new NodeSetImpl(null);
                    }
                    break block42;
                } else {
                    log.error((Object)("computeProfiledPageContext(): Failed to find profiled page and/or folder for " + requestPath + " at " + locator));
                    throw new PageNotFoundException(requestPath + " at " + locator);
                }
            }
            try {
                String folderPath = requestPath;
                if (folderPath.endsWith(".psml") || folderPath.endsWith("/")) {
                    int lastSlashIndex = folderPath.lastIndexOf(47);
                    folderPath = lastSlashIndex > 0 ? folderPath.substring(0, lastSlashIndex) : "/";
                }
                folder = this.folderHandler.getFolder(folderPath);
                String pagePath = requestPath;
                if (!pagePath.endsWith(".psml")) {
                    pagePath = folder.getDefaultPage(true);
                }
                page = ((FolderImpl)folder).getPage(pagePath, false);
            }
            catch (NodeException ne) {
                // empty catch block
            }
            if (page == null) {
                log.warn((Object)("computeProfiledPageContext(): Falling back to managed root default page for " + requestPath));
                try {
                    folder = this.folderHandler.getFolder("/");
                    String pagePath = folder.getDefaultPage(true);
                    page = ((FolderImpl)folder).getPage(pagePath, false);
                }
                catch (NodeException ne) {
                    // empty catch block
                }
            }
            if (page == null) {
                log.error((Object)("computeProfiledPageContext(): Failed to find managed page for " + requestPath));
                throw new PageNotFoundException(requestPath);
            }
            siblingPages = ((FolderImpl)folder).getPages(false);
            parentFolder = (Folder)((AbstractNode)folder).getParent(false);
            siblingFolders = ((FolderImpl)folder).getFolders(false);
            try {
                Folder rootFolder = this.folderHandler.getFolder("/");
                rootLinks = ((FolderImpl)rootFolder).getLinks(false);
            }
            catch (NodeException ne) {
                // empty catch block
            }
            try {
                Comparator documentComparator = ((NodeSetImpl)((FolderImpl)folder).getAllNodes()).getComparator();
                documentSets = new NodeSetImpl(null, documentComparator);
                documentSetNames = new HashMap(8);
                documentSetNodeSets = new HashMap(8);
                HashSet<String> uniqueDocumentSetPaths = new HashSet<String>(8);
                FolderImpl aggregateFolder = (FolderImpl)folder;
                do {
                    Iterator documentSetsIter = aggregateFolder.getDocumentSets(false).iterator();
                    while (documentSetsIter.hasNext()) {
                        DocumentSet documentSet = (DocumentSet)documentSetsIter.next();
                        String documentSetPath = documentSet.getPath();
                        if (uniqueDocumentSetPaths.contains(documentSetPath)) continue;
                        uniqueDocumentSetPaths.add(documentSetPath);
                        NodeSetImpl documentSetNodes = new NodeSetImpl(null, documentComparator);
                        if ((documentSetNodes = this.expandDocumentSet(documentSet, documentSetNodes, "", documentSetNames, documentSetNodeSets)) == null) continue;
                        documentSets.add((Node)documentSet);
                    }
                } while ((aggregateFolder = (FolderImpl)aggregateFolder.getParent(false)) != null);
            }
            catch (NodeException ne) {}
        }
        cachedPageContext = new AbstractPageManager.CacheablePageContext(page, folder, siblingPages, parentFolder, siblingFolders, rootLinks, documentSets, documentSetNames, documentSetNodeSets, allProfiledFolders);
        this.cachePageContext(pageContextCacheKey, cachedPageContext);
        this.populateProfiledPageContext(cachedPageContext, pageContext);
    }

    private NodeSetImpl expandAndProfileDocumentSet(Map profileLocators, DocumentSet documentSet, NodeSetImpl expandedNodes, String documentSetNamePrefix, Map documentSetNames, Map documentSetNodeSets, List allProfiledFolders) {
        Iterator pathsIter;
        DocumentSetPath documentSetPath;
        ProfileLocator navigationLocator = this.selectNavigationProfileLocator(documentSet.getProfileLocatorName(), profileLocators);
        if (navigationLocator == null) {
            log.warn((Object)("expandAndProfileDocumentSet(): Navigation profile locator " + documentSet.getProfileLocatorName() + " unavailable for document set " + documentSet.getPath() + ", ignored."));
            return null;
        }
        List searchPaths = this.generateProfilingSearchPaths("/", navigationLocator, true);
        if (log.isDebugEnabled()) {
            Iterator pathsIter2 = searchPaths.iterator();
            while (pathsIter2.hasNext()) {
                log.debug((Object)("expandAndProfileDocumentSet(), searchPath = " + pathsIter2.next()));
            }
        }
        if (expandedNodes == null) {
            String documentFolderPath;
            int lastSlashIndex;
            Vector documentOrder = null;
            Vector documentPaths = documentSet.getDefaultedDocumentPaths();
            if (documentPaths.size() == 1 && (documentSetPath = (DocumentSetPath)documentPaths.get(0)).isRegexp() && (lastSlashIndex = (documentFolderPath = this.forceAbsoluteDocumentSetPath(documentSetPath.getPath())).lastIndexOf(47)) > 2) {
                documentFolderPath = documentFolderPath.substring(0, lastSlashIndex);
                pathsIter = searchPaths.iterator();
                while (documentOrder == null && pathsIter.hasNext()) {
                    String folderPath = (String)pathsIter.next();
                    folderPath = folderPath.endsWith("/") ? folderPath.substring(0, folderPath.length() - 1) + documentFolderPath : folderPath + documentFolderPath;
                    try {
                        FolderImpl folder = (FolderImpl)this.setProfiledNodePathAndUrl((AbstractNode)this.folderHandler.getFolder(folderPath));
                        if (folder.getMetaData() == null || folder.getMetaData().getDocumentOrder() == null || folder.getMetaData().getDocumentOrder().isEmpty()) continue;
                        documentOrder = folder.getMetaData().getDocumentOrder();
                    }
                    catch (NodeException ne) {}
                }
            }
            if (documentOrder == null) {
                Iterator pathsIter3 = searchPaths.iterator();
                while (documentOrder == null && pathsIter3.hasNext()) {
                    String folderPath = (String)pathsIter3.next();
                    if (folderPath.endsWith("/") && folderPath.length() > 1) {
                        folderPath = folderPath.substring(0, folderPath.length() - 1);
                    }
                    try {
                        FolderImpl folder = (FolderImpl)this.setProfiledNodePathAndUrl((AbstractNode)this.folderHandler.getFolder(folderPath));
                        if (folder.getMetaData() == null || folder.getMetaData().getDocumentOrder() == null || folder.getMetaData().getDocumentOrder().isEmpty()) continue;
                        documentOrder = folder.getMetaData().getDocumentOrder();
                    }
                    catch (NodeException ne) {}
                }
            }
            DocumentOrderComparator documentComparator = new DocumentOrderComparator(documentOrder);
            expandedNodes = new NodeSetImpl(null, documentComparator);
        }
        String name = documentSetNamePrefix + documentSet.getUrl();
        documentSetNames.put(documentSet, name);
        Iterator documentSetPathsIter = documentSet.getDefaultedDocumentPaths().iterator();
        while (documentSetPathsIter.hasNext()) {
            documentSetPath = (DocumentSetPath)documentSetPathsIter.next();
            String path = this.forceAbsoluteDocumentSetPath(documentSetPath.getPath());
            log.debug((Object)("expandAndProfileDocumentSet(), document set path = " + path));
            boolean regexp = documentSetPath.isRegexp();
            if (regexp) {
                path = this.pathToPerl5Regexp(path);
            }
            pathsIter = searchPaths.iterator();
            while (pathsIter.hasNext()) {
                String searchPath = (String)pathsIter.next();
                searchPath = searchPath.endsWith("/") ? searchPath + path.substring(1) : searchPath + path;
                try {
                    Iterator pathNodesIter = this.filterDocumentSet(this.folderHandler.getNodes(searchPath, regexp, null)).iterator();
                    while (pathNodesIter.hasNext()) {
                        AbstractNode pathNode = this.setProfiledNodePathAndUrl((AbstractNode)pathNodesIter.next());
                        if (pathNode.isHidden()) continue;
                        if (!(pathNode instanceof DocumentSet)) {
                            expandedNodes = this.addUniqueOrDescribedUrlNode(expandedNodes, pathNode);
                            if (!(pathNode instanceof Folder) || allProfiledFolders.contains(pathNode)) continue;
                            allProfiledFolders.add(pathNode);
                            continue;
                        }
                        if (documentSetNames.containsKey(pathNode) || this.expandAndProfileDocumentSet(profileLocators, (DocumentSet)pathNode, null, name, documentSetNames, documentSetNodeSets, allProfiledFolders) == null) continue;
                        expandedNodes = this.addUniqueOrDescribedUrlNode(expandedNodes, pathNode);
                    }
                }
                catch (NodeException ne) {
                }
            }
        }
        documentSetNodeSets.put(documentSet, expandedNodes);
        return expandedNodes;
    }

    private List generateProfilingSearchPaths(String requestPath, ProfileLocator locator, boolean forceRequestPath) {
        boolean pagePathSet = false;
        String pagePath = requestPath;
        ArrayList<String> orderedLocatorPaths = new ArrayList<String>(16);
        ArrayList locatorPathsSet = new ArrayList(16);
        Iterator locatorIter = locator.iterator();
        while (locatorIter.hasNext()) {
            ProfileLocatorProperty[] locatorProperties = (ProfileLocatorProperty[])locatorIter.next();
            log.debug((Object)("generateProfilingSearchPaths(), locatorPath = " + locator.getLocatorPath(locatorProperties)));
            String locatorPathRoot = "/";
            int locatorPathDepth = 0;
            ArrayList<StringBuffer> locatorPaths = new ArrayList<StringBuffer>(16);
            locatorPaths.add(new StringBuffer(locatorPathRoot));
            int lastLocatorPathsCount = 0;
            String lastLocatorPropertyName = null;
            int lastLocatorPropertyValueCount = 0;
            int lastLocatorPropertyValueLength = 0;
            for (int i = 0; i < locatorProperties.length; ++i) {
                if (locatorProperties[i].isNavigation()) {
                    if (locatorProperties[i].getValue() != null) {
                        locatorPathRoot = locatorProperties[i].getValue();
                        if (!locatorPathRoot.startsWith("/")) {
                            locatorPathRoot = "/" + locatorPathRoot;
                        }
                        if (!locatorPathRoot.endsWith("/")) {
                            locatorPathRoot = locatorPathRoot + "/";
                        }
                        if (!locatorPathRoot.equals("/")) {
                            int folderIndex = 1;
                            do {
                                if (locatorPathRoot.regionMatches(folderIndex, PROFILE_NAVIGATION_PROPERTY_FOLDER_PREFIX, 0, PROFILE_NAVIGATION_PROPERTY_FOLDER_PREFIX.length())) continue;
                                locatorPathRoot = locatorPathRoot.substring(0, folderIndex) + PROFILE_NAVIGATION_PROPERTY_FOLDER_PREFIX + locatorPathRoot.substring(folderIndex);
                            } while ((folderIndex = locatorPathRoot.indexOf("/", folderIndex) + 1) != -1 && folderIndex != locatorPathRoot.length());
                        }
                        locatorPathDepth = 0;
                        locatorPaths.clear();
                        locatorPaths.add(new StringBuffer(locatorPathRoot));
                        lastLocatorPathsCount = 0;
                        lastLocatorPropertyName = null;
                        lastLocatorPropertyValueCount = 0;
                        lastLocatorPropertyValueLength = 0;
                        continue;
                    }
                    ++lastLocatorPropertyValueCount;
                    continue;
                }
                if (locatorProperties[i].isControl()) {
                    if (locatorProperties[i].getValue() != null) {
                        String locatorPropertyName = locatorProperties[i].getName().toLowerCase();
                        String locatorPropertyValue = locatorProperties[i].getValue().toLowerCase();
                        if (locatorPropertyName.equals(lastLocatorPropertyName)) {
                            ArrayList<StringBuffer> multipleValueLocatorPaths = new ArrayList<StringBuffer>(lastLocatorPathsCount);
                            Iterator locatorPathsIter = locatorPaths.iterator();
                            for (int count = 0; locatorPathsIter.hasNext() && count < lastLocatorPathsCount; ++count) {
                                StringBuffer locatorPath = (StringBuffer)locatorPathsIter.next();
                                StringBuffer multipleValueLocatorPath = new StringBuffer(locatorPath.toString());
                                multipleValueLocatorPath.setLength(multipleValueLocatorPath.length() - lastLocatorPropertyValueLength - 1);
                                multipleValueLocatorPath.append(locatorPropertyValue);
                                multipleValueLocatorPath.append('/');
                                multipleValueLocatorPaths.add(multipleValueLocatorPath);
                            }
                            locatorPaths.addAll(multipleValueLocatorPaths);
                            ++lastLocatorPropertyValueCount;
                            continue;
                        }
                        Iterator locatorPathsIter = locatorPaths.iterator();
                        while (locatorPathsIter.hasNext()) {
                            StringBuffer locatorPath = (StringBuffer)locatorPathsIter.next();
                            locatorPath.append(PROFILE_PROPERTY_FOLDER_PREFIX);
                            locatorPath.append(locatorPropertyName);
                            locatorPath.append('/');
                            locatorPath.append(locatorPropertyValue);
                            locatorPath.append('/');
                        }
                        ++locatorPathDepth;
                        lastLocatorPathsCount = locatorPaths.size();
                        lastLocatorPropertyName = locatorPropertyName;
                        lastLocatorPropertyValueCount = 1;
                        lastLocatorPropertyValueLength = locatorPropertyValue.length();
                        continue;
                    }
                    ++lastLocatorPropertyValueCount;
                    continue;
                }
                if (!forceRequestPath && !pagePathSet && locatorProperties[i].getValue() != null) {
                    pagePath = this.constructAbsolutePagePath(requestPath, locatorProperties[i].getValue());
                    pagePathSet = true;
                }
                ++lastLocatorPropertyValueCount;
            }
            if (locatorPathDepth > 0) {
                locatorPathsSet.addAll(locatorPaths);
            }
            if (locatorPathDepth <= 1) {
                locatorPathsSet.add(new StringBuffer(locatorPathRoot));
                ListIterator locatorPathsIter = locatorPathsSet.listIterator(locatorPathsSet.size());
                while (locatorPathsIter.hasPrevious()) {
                    String locatorPath = locatorPathsIter.previous().toString();
                    if (orderedLocatorPaths.contains(locatorPath)) continue;
                    orderedLocatorPaths.add(0, locatorPath);
                }
                locatorPathsSet.clear();
            }
            for (int skip = lastLocatorPropertyValueCount; skip > 1 && locatorIter.hasNext(); --skip) {
                locatorIter.next();
            }
        }
        if (pagePath != null) {
            if (pagePath.startsWith("/")) {
                pagePath = pagePath.substring(1);
            }
            ListIterator<String> locatorPathsIter = orderedLocatorPaths.listIterator();
            while (locatorPathsIter.hasNext()) {
                String locatorPath = (String)locatorPathsIter.next();
                locatorPathsIter.set(locatorPath + pagePath);
            }
        }
        return orderedLocatorPaths;
    }

    private String constructAbsolutePagePath(String requestPath, String pagePath) {
        if (pagePath == null || !pagePath.startsWith("/")) {
            int lastSlashIndex;
            boolean folderRequest;
            if (pagePath == null) {
                pagePath = "";
            } else if (pagePath.indexOf("/") == -1 && !pagePath.endsWith(".psml")) {
                pagePath = pagePath + ".psml";
            }
            if (pagePath.equals("default-page.psml")) {
                pagePath = "";
            }
            boolean defaultPage = pagePath.equals("");
            boolean rootFolderRequest = requestPath.equals("/");
            boolean bl = folderRequest = !requestPath.endsWith(".psml");
            pagePath = !defaultPage || folderRequest ? ((lastSlashIndex = requestPath.lastIndexOf(47)) > 0 ? requestPath.substring(0, lastSlashIndex) + "/" + pagePath : (!rootFolderRequest && folderRequest ? requestPath + "/" + pagePath : "/" + pagePath)) : requestPath;
        }
        return pagePath;
    }

    private boolean findProfiledPageAndFolders(List pageSearchPaths, Page[] page) {
        return this.findProfiledPageAndFolders(pageSearchPaths, page, null, null, null);
    }

    private boolean findProfiledPageAndFolders(List pageSearchPaths, Page[] page, Folder[] folder, List folders, List searchFolders) {
        page[0] = null;
        if (folder != null) {
            folder[0] = null;
        }
        if (folders != null) {
            folders.clear();
        }
        if (searchFolders != null) {
            searchFolders.clear();
        }
        int numSearchFoldersFound = 0;
        Folder lastSearchFolderFound = null;
        String lastSearchFolderFoundPath = null;
        Iterator pathsIter = pageSearchPaths.iterator();
        while (pathsIter.hasNext()) {
            String searchRequestPath = (String)pathsIter.next();
            log.debug((Object)("findProfiledPageAndFolders(), searchPath = " + searchRequestPath));
            String folderPath = searchRequestPath;
            Folder searchFolder = null;
            Page searchPage = null;
            try {
                if (folderPath.endsWith(".psml") || folderPath.endsWith("/")) {
                    int lastSlashIndex = folderPath.lastIndexOf(47);
                    folderPath = lastSlashIndex > 0 ? folderPath.substring(0, lastSlashIndex) : "/";
                }
                searchFolder = this.folderHandler.getFolder(folderPath);
                if (page[0] == null) {
                    boolean allowDefaulting;
                    String pagePath = searchRequestPath;
                    if (!pagePath.endsWith(".psml") && (pagePath = searchFolder.getDefaultPage(allowDefaulting = folderPath.equals("/"))) != null && !pagePath.equals("default-page.psml") && numSearchFoldersFound > 0) {
                        ListIterator<String> pageSearchPathsIter = pageSearchPaths.listIterator();
                        while (pageSearchPathsIter.hasNext()) {
                            String pageSearchPath = (String)pageSearchPathsIter.next();
                            if (pageSearchPath.endsWith("/")) {
                                pageSearchPathsIter.set(pageSearchPath + pagePath);
                                continue;
                            }
                            pageSearchPathsIter.set(pageSearchPath + "/" + pagePath);
                        }
                        log.debug((Object)("findProfiledPageAndFolders(): invoking again with default page: " + pagePath));
                        return this.findProfiledPageAndFolders(pageSearchPaths, page, folder, folders, searchFolders);
                    }
                    if (pagePath != null) {
                        searchPage = ((FolderImpl)searchFolder).getPage(pagePath, false);
                    }
                }
                ++numSearchFoldersFound;
                lastSearchFolderFound = searchFolder;
                lastSearchFolderFoundPath = searchRequestPath;
            }
            catch (NodeException ne) {
                // empty catch block
            }
            if (searchFolder != null) {
                log.debug((Object)("findProfiledPageAndFolders(), matched searchFolder = " + searchFolder));
            }
            if (searchPage != null) {
                log.debug((Object)("findProfiledPageAndFolders(), matched searchPage = " + searchPage));
            }
            if (page[0] == null && searchPage != null) {
                page[0] = searchPage;
                if (folder != null) {
                    folder[0] = searchFolder;
                }
                log.debug((Object)("findProfiledPageAndFolders(), using matched searchFolder = " + searchFolder));
                log.debug((Object)("findProfiledPageAndFolders(), using matched searchPage = " + searchPage));
            }
            if (folders == null || searchFolders == null) continue;
            if (searchFolder != null) {
                folders.add(searchFolder);
                if (!searchFolder.getName().startsWith(PROFILE_NAVIGATION_PROPERTY_FOLDER_PREFIX)) {
                    do {
                        searchFolders.add(searchFolder);
                    } while ((searchFolder = (Folder)((AbstractNode)searchFolder).getParent(false)) != null && !searchFolder.getName().startsWith(PROFILE_PROPERTY_FOLDER_PREFIX) && !searchFolder.getName().startsWith(PROFILE_NAVIGATION_PROPERTY_FOLDER_PREFIX));
                }
                if (searchFolder == null || !searchFolder.getName().startsWith(PROFILE_NAVIGATION_PROPERTY_FOLDER_PREFIX)) continue;
                searchFolders.add(searchFolder);
                continue;
            }
            String searchFolderName = null;
            do {
                block31: {
                    if (searchFolder == null) {
                        int separatorIndex = folderPath.lastIndexOf("/");
                        folderPath = separatorIndex > 0 ? folderPath.substring(0, separatorIndex) : "/";
                        try {
                            searchFolder = this.folderHandler.getFolder(folderPath);
                            searchFolderName = searchFolder.getName();
                        }
                        catch (NodeException ne) {
                            separatorIndex = folderPath.lastIndexOf("/");
                            if (separatorIndex > 0) {
                                searchFolderName = folderPath.substring(separatorIndex + 1);
                                break block31;
                            }
                            searchFolderName = "/";
                        }
                    } else if ((searchFolder = (Folder)((AbstractNode)searchFolder).getParent(false)) != null) {
                        searchFolderName = searchFolder.getName();
                    }
                }
                if (searchFolder == null || !searchFolderName.startsWith(PROFILE_NAVIGATION_PROPERTY_FOLDER_PREFIX) && searchFolderName.startsWith(PROFILE_PROPERTY_FOLDER_PREFIX)) continue;
                searchFolders.add(searchFolder);
            } while (!searchFolderName.equals("/") && !searchFolderName.startsWith(PROFILE_PROPERTY_FOLDER_PREFIX) && !searchFolderName.startsWith(PROFILE_NAVIGATION_PROPERTY_FOLDER_PREFIX));
        }
        if (page[0] == null && numSearchFoldersFound == 1 && !lastSearchFolderFound.getPath().equals("/") && !lastSearchFolderFoundPath.endsWith(".psml")) {
            String defaultPagePath = lastSearchFolderFound.getDefaultPage(true);
            Page lastSearchFolderFoundPage = null;
            try {
                lastSearchFolderFoundPage = ((FolderImpl)lastSearchFolderFound).getPage(defaultPagePath, false);
            }
            catch (NodeException ne) {
                // empty catch block
            }
            if (lastSearchFolderFoundPage != null) {
                page[0] = lastSearchFolderFoundPage;
                if (folder != null) {
                    folder[0] = lastSearchFolderFound;
                }
                log.debug((Object)("findProfiledPageAndFolders(), using matched default searchFolder = " + lastSearchFolderFound));
                log.debug((Object)("findProfiledPageAndFolders(), using matched default searchPage = " + lastSearchFolderFoundPage));
            }
        }
        return page[0] != null;
    }

    private AbstractNode setProfiledNodePathAndUrl(AbstractNode profiledNode) {
        String profiledPath;
        if (profiledNode.getProfiledPath() == null && (profiledPath = this.stripProfiledPath(profiledNode.getPath())).startsWith("/")) {
            profiledNode.setProfiledPath(profiledPath);
            if (!profiledNode.isUrlSet()) {
                profiledNode.setUrl(profiledPath);
            }
            if (profiledNode.getPath().equals(profiledNode.getTitle())) {
                profiledNode.setTitle(profiledPath);
            }
        }
        return profiledNode;
    }

    private String stripProfiledPath(String path) {
        if (path != null) {
            int subsitePathIndex;
            int pairPathIndex = path.lastIndexOf("/_");
            if (pairPathIndex > (subsitePathIndex = path.lastIndexOf("/__"))) {
                int contentPathIndex = path.indexOf("/", pairPathIndex + 1);
                if (contentPathIndex != -1) {
                    path = (contentPathIndex = path.indexOf("/", contentPathIndex + 1)) != -1 ? path.substring(contentPathIndex) : "/";
                }
            } else if (subsitePathIndex >= pairPathIndex) {
                int contentPathIndex = path.indexOf("/", subsitePathIndex + 1);
                path = contentPathIndex != -1 ? path.substring(contentPathIndex) : "/";
            }
        }
        return path;
    }

    private NodeSetImpl addUniqueOrDescribedUrlNode(NodeSetImpl set, AbstractNode node) {
        if (node.getProfiledPath() == null) {
            return set;
        }
        Iterator setIter = set.iterator();
        while (setIter.hasNext()) {
            AbstractNode setNode = (AbstractNode)setIter.next();
            if (!node.getProfiledPath().equals(setNode.getProfiledPath())) continue;
            if (node.getMetadata() != null && setNode.getMetadata() == null) {
                NodeSetImpl newSet = new NodeSetImpl(null, set.getComparator());
                Iterator copyIter = set.iterator();
                while (copyIter.hasNext()) {
                    Node copyNode = (Node)copyIter.next();
                    if (copyNode != setNode) {
                        newSet.add(copyNode);
                        continue;
                    }
                    newSet.add(node);
                }
                return newSet;
            }
            return set;
        }
        set.add(node);
        return set;
    }

    private NodeSetImpl expandDocumentSet(DocumentSet documentSet, NodeSetImpl expandedNodes, String documentSetNamePrefix, Map documentSetNames, Map documentSetNodeSets) {
        if (documentSet.getProfileLocatorName() != null) {
            log.warn((Object)("expandDocumentSet(), profiling locator " + documentSet.getProfileLocatorName() + " ignored, ignoring document set path = " + documentSet.getPath()));
            return null;
        }
        if (expandedNodes == null) {
            expandedNodes = new NodeSetImpl(null);
        }
        String name = documentSetNamePrefix + documentSet.getUrl();
        documentSetNames.put(documentSet, name);
        Iterator documentSetPathsIter = documentSet.getDefaultedDocumentPaths().iterator();
        while (documentSetPathsIter.hasNext()) {
            DocumentSetPath documentSetPath = (DocumentSetPath)documentSetPathsIter.next();
            String path = this.forceAbsoluteDocumentSetPath(documentSetPath.getPath());
            log.debug((Object)("expandDocumentSet(), document set path = " + path));
            boolean regexp = documentSetPath.isRegexp();
            if (regexp) {
                path = this.pathToPerl5Regexp(path);
            }
            try {
                Iterator pathNodesIter = this.filterDocumentSet(this.folderHandler.getNodes(path, regexp, null)).iterator();
                while (pathNodesIter.hasNext()) {
                    NodeSetImpl nodes;
                    AbstractNode pathNode = (AbstractNode)pathNodesIter.next();
                    if (!(pathNode instanceof DocumentSet)) {
                        expandedNodes.add(pathNode);
                        continue;
                    }
                    if (documentSetNames.containsKey(pathNode) || this.expandDocumentSet((DocumentSet)pathNode, nodes = new NodeSetImpl(null, expandedNodes.getComparator()), name, documentSetNames, documentSetNodeSets) == null) continue;
                    expandedNodes.add(pathNode);
                }
            }
            catch (NodeException ne) {
            }
        }
        documentSetNodeSets.put(documentSet, expandedNodes);
        return expandedNodes;
    }

    private String forceAbsoluteDocumentSetPath(String path) {
        if (path == null) {
            path = "/";
        } else if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    private synchronized String pathToPerl5Regexp(String path) {
        String perl5Path = this.lookupPerl5Regexp(path);
        if (perl5Path == null) {
            perl5Path = path.replaceAll("\\.", "\\\\.");
            perl5Path = perl5Path.replaceAll("\\?", ".");
            perl5Path = perl5Path.replaceAll("\\*", ".*");
            this.cachePerl5Regexp(path, perl5Path);
        }
        return perl5Path;
    }

    private NodeSet filterDocumentSet(NodeSet set) {
        if (set.isEmpty()) {
            return set;
        }
        boolean filterRequired = false;
        Iterator setIter = set.iterator();
        while (!filterRequired && setIter.hasNext()) {
            AbstractNode node = (AbstractNode)setIter.next();
            filterRequired = !(node instanceof Page) && !(node instanceof Folder) && !(node instanceof Link) && !(node instanceof DocumentSet);
        }
        if (!filterRequired) {
            return set;
        }
        NodeSetImpl filteredSet = new NodeSetImpl(null);
        setIter = set.iterator();
        while (setIter.hasNext()) {
            AbstractNode node = (AbstractNode)setIter.next();
            if (!(node instanceof Page) && !(node instanceof Folder) && !(node instanceof Link) && !(node instanceof DocumentSet)) continue;
            filteredSet.add(node);
        }
        return filteredSet;
    }

    public Page getPage(String path) throws PageNotFoundException, FolderNotFoundException, NodeException {
        FolderImpl folder = this.getNodeFolder(path);
        return folder.getPage(this.getNodeName(path));
    }

    public void registerPage(Page page) throws JetspeedException {
        if (page.getPath() == null && page.getId() != null) {
            String path = page.getId();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith(".psml")) {
                path = path + ".psml";
            }
            page.setId(path);
            page.setPath(path);
        }
        if (page.getPath() != null) {
            if (!page.getPath().equals(page.getId())) {
                log.error((Object)"Page paths and ids must match!");
                return;
            }
        } else {
            log.error((Object)"Page paths and ids must be set!");
            return;
        }
        this.setProfiledNodePathAndUrl((AbstractNode)page);
        page.checkAccess("edit");
        this.handlerFactory.getDocumentHandler(".psml").updateDocument((Document)page);
        FolderImpl folder = this.getNodeFolder(page.getPath());
        if (!folder.getAllNodes().contains((Node)page)) {
            folder.getAllNodes().add((Node)page);
        }
        page.setParent((Node)folder);
    }

    public void updatePage(Page page) throws JetspeedException {
        this.registerPage(page);
    }

    public void removePage(Page page) throws JetspeedException {
        page.checkAccess("edit");
        this.handlerFactory.getDocumentHandler(".psml").removeDocument((Document)page);
        FolderImpl folder = this.getNodeFolder(page.getPath());
        ((NodeSetImpl)folder.getAllNodes()).remove((Node)page);
        page.setParent(null);
    }

    public Link getLink(String path) throws DocumentNotFoundException, UnsupportedDocumentTypeException, FolderNotFoundException, NodeException {
        FolderImpl folder = this.getNodeFolder(path);
        return folder.getLink(this.getNodeName(path));
    }

    public DocumentSet getDocumentSet(String path) throws DocumentNotFoundException, UnsupportedDocumentTypeException, FolderNotFoundException, NodeException {
        FolderImpl folder = this.getNodeFolder(path);
        return folder.getDocumentSet(this.getNodeName(path));
    }

    public PageSecurity getPageSecurity() throws DocumentNotFoundException, UnsupportedDocumentTypeException, FolderNotFoundException, NodeException {
        FolderImpl folder = this.getNodeFolder("/");
        return folder.getPageSecurity();
    }

    public Folder getFolder(String folderPath) throws FolderNotFoundException, InvalidFolderException, NodeException {
        return this.folderHandler.getFolder(folderPath);
    }

    private FolderImpl getNodeFolder(String nodePath) throws NodeException, InvalidFolderException {
        int folderIndex = nodePath.lastIndexOf("/");
        if (folderIndex > 0) {
            return (FolderImpl)this.folderHandler.getFolder(nodePath.substring(0, folderIndex));
        }
        return (FolderImpl)this.folderHandler.getFolder("/");
    }

    private String getNodeName(String nodePath) {
        int folderIndex = nodePath.lastIndexOf("/");
        if (folderIndex > -1) {
            return nodePath.substring(folderIndex + 1);
        }
        return nodePath;
    }

    public void refresh(FileCacheEntry entry) throws Exception {
        this.evictAllPageContextCache();
    }

    public void evict(FileCacheEntry entry) throws Exception {
        this.evictAllPageContextCache();
    }

    private void initCaches(int cacheSize) {
        if (cacheSize > 0) {
            this.pageContextCache = new LRUMap(cacheSize);
            this.perl5PathRegexpCache = new LRUMap(cacheSize * 2);
        } else {
            this.pageContextCache = new HashMap();
            this.perl5PathRegexpCache = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cachePageContext(String pageContextCacheKey, AbstractPageManager.CacheablePageContext pageContext) {
        Map map = this.pageContextCache;
        synchronized (map) {
            this.pageContextCache.put(pageContextCacheKey, pageContext);
        }
        log.debug((Object)("cacheProfiledPageContext() cached, cache key = " + pageContextCacheKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractPageManager.CacheablePageContext lookupPageContext(String pageContextCacheKey) {
        AbstractPageManager.CacheablePageContext pageContext = null;
        Map map = this.pageContextCache;
        synchronized (map) {
            pageContext = (AbstractPageManager.CacheablePageContext)this.pageContextCache.get(pageContextCacheKey);
        }
        if (pageContext != null) {
            log.debug((Object)("lookupProfiledPageContext() cache hit, cache key = " + pageContextCacheKey));
        }
        return pageContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictAllPageContextCache() {
        Map map = this.pageContextCache;
        synchronized (map) {
            this.pageContextCache.clear();
        }
        log.debug((Object)"evictAllProfiledPageContext() invoked, all page contexts evicted from cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cachePerl5Regexp(String regexpKey, String regexp) {
        Map map = this.perl5PathRegexpCache;
        synchronized (map) {
            this.perl5PathRegexpCache.put(regexpKey, regexp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String lookupPerl5Regexp(String regexpKey) {
        Map map = this.perl5PathRegexpCache;
        synchronized (map) {
            return (String)this.perl5PathRegexpCache.get(regexpKey);
        }
    }

    private String pageContextCacheKey(ProfiledPageContext pageContext) {
        StringBuffer cacheKeyBuffer = new StringBuffer();
        if (pageContext.getLocators() != null) {
            ArrayList locators = new ArrayList(pageContext.getLocators().entrySet());
            Comparator locatorComparator = new Comparator(){

                public int compare(Object locator1, Object locator2) {
                    return ((String)((Map.Entry)locator1).getKey()).compareTo((String)((Map.Entry)locator1).getKey());
                }
            };
            Collections.sort(locators, locatorComparator);
            Iterator locatorIter = locators.iterator();
            while (locatorIter.hasNext()) {
                Map.Entry locator = (Map.Entry)locatorIter.next();
                if (cacheKeyBuffer.length() > 0) {
                    cacheKeyBuffer.append(',');
                }
                cacheKeyBuffer.append(locator.getKey());
                cacheKeyBuffer.append(":");
                cacheKeyBuffer.append(locator.getValue());
            }
        }
        return cacheKeyBuffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DocumentOrderComparator
    implements Comparator {
        private List order;

        public DocumentOrderComparator(List documentOrderList) {
            this.order = documentOrderList;
        }

        public int compare(Object rootLink1, Object rootLink2) {
            String name2;
            int nameIndex2;
            String name1 = rootLink1.toString();
            int nameIndex1 = name1.lastIndexOf(47);
            if (nameIndex1 != -1) {
                name1 = name1.substring(nameIndex1 + 1);
            }
            if ((nameIndex2 = (name2 = rootLink2.toString()).lastIndexOf(47)) != -1) {
                name2 = name2.substring(nameIndex2 + 1);
            }
            if (this.order != null) {
                int index1 = this.order.indexOf(name1);
                int index2 = this.order.indexOf(name2);
                if (index1 != -1 || index2 != -1) {
                    if (index1 == -1 && index2 != -1) {
                        return 1;
                    }
                    if (index1 != -1 && index2 == -1) {
                        return -1;
                    }
                    return index1 - index2;
                }
            }
            return name1.compareTo(name2);
        }
    }
}

