/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.folder.DocumentSet;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.impl.FolderImpl;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.Property;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.AbstractNode;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.NodeSetImpl;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.ProfiledPageContext;

public abstract class AbstractPageManager
implements PageManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$page$impl$AbstractPageManager == null ? (class$org$apache$jetspeed$page$impl$AbstractPageManager = AbstractPageManager.class$("org.apache.jetspeed.page.impl.AbstractPageManager")) : class$org$apache$jetspeed$page$impl$AbstractPageManager));
    protected Class fragmentClass = class$org$apache$jetspeed$om$page$psml$FragmentImpl == null ? (class$org$apache$jetspeed$om$page$psml$FragmentImpl = AbstractPageManager.class$("org.apache.jetspeed.om.page.psml.FragmentImpl")) : class$org$apache$jetspeed$om$page$psml$FragmentImpl;
    protected Class pageClass = class$org$apache$jetspeed$om$page$psml$PageImpl == null ? (class$org$apache$jetspeed$om$page$psml$PageImpl = AbstractPageManager.class$("org.apache.jetspeed.om.page.psml.PageImpl")) : class$org$apache$jetspeed$om$page$psml$PageImpl;
    protected Class propertyClass = class$org$apache$jetspeed$om$page$psml$PropertyImpl == null ? (class$org$apache$jetspeed$om$page$psml$PropertyImpl = AbstractPageManager.class$("org.apache.jetspeed.om.page.psml.PropertyImpl")) : class$org$apache$jetspeed$om$page$psml$PropertyImpl;
    protected IdGenerator generator = null;
    private boolean permissionsEnabled;
    private boolean constraintsEnabled;
    static /* synthetic */ Class class$org$apache$jetspeed$page$impl$AbstractPageManager;
    static /* synthetic */ Class class$org$apache$jetspeed$om$page$psml$FragmentImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$page$psml$PageImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$om$page$psml$PropertyImpl;

    public AbstractPageManager(IdGenerator generator, boolean permissionsEnabled, boolean constraintsEnabled) {
        this.generator = generator;
        this.permissionsEnabled = permissionsEnabled;
        this.constraintsEnabled = constraintsEnabled;
    }

    public AbstractPageManager(IdGenerator generator, boolean permissionsEnabled, boolean constraintsEnabled, List modelClasses) {
        this.generator = generator;
        if (modelClasses.size() > 0) {
            this.fragmentClass = (Class)modelClasses.get(0);
            if (modelClasses.size() > 1) {
                this.pageClass = (Class)modelClasses.get(1);
                if (modelClasses.size() > 2) {
                    this.propertyClass = (Class)modelClasses.get(2);
                }
            }
        }
        this.permissionsEnabled = permissionsEnabled;
        this.constraintsEnabled = constraintsEnabled;
    }

    public boolean getPermissionsEnabled() {
        return this.permissionsEnabled;
    }

    public boolean getConstraintsEnabled() {
        return this.constraintsEnabled;
    }

    public Page newPage() {
        Page page = null;
        try {
            page = (Page)this.createObject(this.pageClass);
            page.setId(this.generator.getNextPeid());
            Fragment fragment = (Fragment)this.createObject(this.fragmentClass);
            fragment.setId(this.generator.getNextPeid());
            fragment.setType("layout");
            page.setRootFragment(fragment);
        }
        catch (ClassCastException e) {
            String message = "Failed to create page object for " + this.pageClass;
            log.error((Object)message, (Throwable)e);
        }
        return page;
    }

    public Fragment newFragment() {
        Fragment fragment = null;
        try {
            fragment = (Fragment)this.createObject(this.fragmentClass);
            fragment.setId(this.generator.getNextPeid());
            fragment.setType("layout");
        }
        catch (ClassCastException e) {
            String message = "Failed to create page object for " + this.pageClass;
            log.error((Object)message, (Throwable)e);
        }
        return fragment;
    }

    public Property newProperty() {
        Property property = null;
        try {
            property = (Property)this.createObject(this.propertyClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create fragment-property object for " + this.propertyClass;
            log.error((Object)message, (Throwable)e);
        }
        return property;
    }

    public Object createObject(Class classe) {
        Object object = null;
        try {
            object = classe.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Factory failed to create object: " + classe.getName()), (Throwable)e);
        }
        return object;
    }

    protected void populateProfiledPageContext(CacheablePageContext cachedPageContext, ProfiledPageContext pageContext) {
        pageContext.setPage((Page)this.checkVisibility((AbstractNode)cachedPageContext.page, cachedPageContext.profiledFolders));
        pageContext.setFolder(cachedPageContext.folder);
        pageContext.setSiblingPages(this.checkVisibility(cachedPageContext.siblingPages, cachedPageContext.profiledFolders));
        pageContext.setParentFolder(cachedPageContext.parentFolder);
        pageContext.setSiblingFolders(this.checkVisibility(cachedPageContext.siblingFolders, cachedPageContext.profiledFolders));
        pageContext.setRootLinks(this.checkVisibility(cachedPageContext.rootLinks, cachedPageContext.profiledFolders));
        if (cachedPageContext.documentSets != null) {
            Iterator documentSetIter = this.checkVisibility(cachedPageContext.documentSets, cachedPageContext.profiledFolders).iterator();
            while (documentSetIter.hasNext()) {
                DocumentSet documentSet = (DocumentSet)documentSetIter.next();
                String documentSetName = (String)cachedPageContext.documentSetNames.get(documentSet);
                NodeSet documentSetNodes = this.checkVisibility((NodeSet)cachedPageContext.documentSetNodeSets.get(documentSet), cachedPageContext.profiledFolders);
                pageContext.setDocumentSet(documentSetName, documentSet, documentSetNodes);
            }
            if (cachedPageContext.nestedDocumentSets != null) {
                Iterator nestedDocumentSetIter = this.checkVisibility(cachedPageContext.nestedDocumentSets, cachedPageContext.profiledFolders).iterator();
                while (nestedDocumentSetIter.hasNext()) {
                    DocumentSet documentSet = (DocumentSet)nestedDocumentSetIter.next();
                    String documentSetName = (String)cachedPageContext.documentSetNames.get(documentSet);
                    NodeSet documentSetNodes = this.checkVisibility((NodeSet)cachedPageContext.documentSetNodeSets.get(documentSet), cachedPageContext.profiledFolders);
                    pageContext.setNestedDocumentSet(documentSetName, documentSet, documentSetNodes);
                }
            }
        }
    }

    protected AbstractNode checkVisibility(AbstractNode node, List profiledFolders) throws SecurityException {
        if (node != null) {
            if (node instanceof Folder) {
                boolean securityException = false;
                try {
                    Iterator pagesIter = ((FolderImpl)node).getPages(false).iterator();
                    while (pagesIter.hasNext()) {
                        try {
                            AbstractNode page = (AbstractNode)pagesIter.next();
                            if (page.isHidden()) continue;
                            this.checkVisibility(page, profiledFolders);
                            return node;
                        }
                        catch (SecurityException se) {
                            securityException = true;
                        }
                    }
                }
                catch (NodeException ne) {
                    // empty catch block
                }
                if (profiledFolders != null) {
                    String folderUrl = node.getUrl();
                    Iterator foldersIter = profiledFolders.iterator();
                    while (foldersIter.hasNext()) {
                        FolderImpl profiledFolder = (FolderImpl)foldersIter.next();
                        if (profiledFolder == node || !folderUrl.equals(profiledFolder.getUrl())) continue;
                        try {
                            Iterator pagesIter = profiledFolder.getPages(false).iterator();
                            while (pagesIter.hasNext()) {
                                try {
                                    AbstractNode page = (AbstractNode)pagesIter.next();
                                    if (page.isHidden()) continue;
                                    this.checkVisibility(page, profiledFolders);
                                    return node;
                                }
                                catch (SecurityException se) {
                                    securityException = true;
                                }
                            }
                        }
                        catch (NodeException ne) {
                        }
                    }
                }
                if (securityException) {
                    throw new SecurityException("AbstractPageManager.checkVisibility(): Access for view not permitted to any folder page.");
                }
                throw new RuntimeException("AbstractPageManager.checkVisibility(): Empty folders not visible.");
            }
            node.checkAccess("view");
        }
        return node;
    }

    protected NodeSet checkVisibility(NodeSet nodes, List profiledFolders) {
        if (nodes != null && !nodes.isEmpty()) {
            NodeSetImpl filteredNodes = null;
            Iterator checkAccessIter = nodes.iterator();
            while (checkAccessIter.hasNext()) {
                AbstractNode node = (AbstractNode)checkAccessIter.next();
                try {
                    this.checkVisibility(node, profiledFolders);
                    if (filteredNodes == null) continue;
                    filteredNodes.add(node);
                }
                catch (RuntimeException rte) {
                    AbstractNode copyNode;
                    if (filteredNodes != null) continue;
                    filteredNodes = new NodeSetImpl(null, ((NodeSetImpl)nodes).getComparator());
                    Iterator copyIter = nodes.iterator();
                    while (copyIter.hasNext() && (copyNode = (AbstractNode)copyIter.next()) != node) {
                        filteredNodes.add(copyNode);
                    }
                }
            }
            if (filteredNodes != null) {
                return filteredNodes;
            }
        }
        return nodes;
    }

    protected ProfileLocator selectPageProfileLocator(Map profileLocators) {
        return (ProfileLocator)profileLocators.get("page");
    }

    protected List selectAlternatePageProfileLocators(Map profileLocators) {
        ArrayList locators = new ArrayList(4);
        Iterator locatorsIter = profileLocators.entrySet().iterator();
        while (locatorsIter.hasNext()) {
            Map.Entry locatorEntry = locatorsIter.next();
            if (((String)locatorEntry.getKey()).equals("page")) continue;
            locators.add(locatorEntry.getValue());
        }
        return locators;
    }

    protected ProfileLocator selectNavigationProfileLocator(String profileLocatorName, Map profileLocators) {
        ProfileLocator locator = null;
        if (profileLocatorName != null) {
            locator = (ProfileLocator)profileLocators.get(profileLocatorName);
        } else {
            locator = (ProfileLocator)profileLocators.get("docset");
            if (locator == null) {
                locator = (ProfileLocator)profileLocators.get("page");
            }
        }
        return locator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class CacheablePageContext {
        public Page page;
        public Folder folder;
        public NodeSet siblingPages;
        public Folder parentFolder;
        public NodeSet siblingFolders;
        public NodeSet rootLinks;
        public NodeSet documentSets;
        public Map documentSetNames;
        public Map documentSetNodeSets;
        public List profiledFolders;
        public NodeSet nestedDocumentSets;

        public CacheablePageContext(Page page, Folder folder, NodeSet siblingPages, Folder parentFolder, NodeSet siblingFolders, NodeSet rootLinks, NodeSet documentSets, Map documentSetNames, Map documentSetNodeSets, List profiledFolders) {
            this.page = page;
            this.folder = folder;
            this.siblingPages = siblingPages;
            this.parentFolder = parentFolder;
            this.siblingFolders = siblingFolders;
            this.profiledFolders = profiledFolders;
            this.rootLinks = rootLinks;
            this.documentSets = documentSets;
            this.documentSetNames = documentSetNames;
            this.documentSetNodeSets = documentSetNodeSets;
            if (this.documentSetNames != null && this.documentSets != null && this.documentSetNames.size() > this.documentSets.size()) {
                Iterator mappedIter = this.documentSetNames.entrySet().iterator();
                while (mappedIter.hasNext()) {
                    Map.Entry mappedEntry = mappedIter.next();
                    DocumentSet documentSet = (DocumentSet)mappedEntry.getKey();
                    if (this.documentSets.contains((Node)documentSet)) continue;
                    if (this.nestedDocumentSets == null) {
                        this.nestedDocumentSets = new NodeSetImpl(null);
                    }
                    this.nestedDocumentSets.add((Node)documentSet);
                }
            }
            if (log.isDebugEnabled()) {
                Page debug;
                Iterator debugIter;
                log.debug((Object)("CacheablePageContext(), folder = " + this.folder + ", url = " + this.folder.getUrl()));
                log.debug((Object)("CacheablePageContext(), page = " + this.page + ", url = " + this.page.getUrl()));
                if (this.siblingPages != null && !this.siblingPages.isEmpty()) {
                    debugIter = this.siblingPages.iterator();
                    while (debugIter.hasNext()) {
                        debug = (Page)debugIter.next();
                        log.debug((Object)("CacheablePageContext(), siblingPage = " + debug + ", url = " + debug.getUrl()));
                    }
                } else {
                    log.debug((Object)"CacheablePageContext(), siblingPages = null/empty");
                }
                log.debug((Object)("CacheablePageContext(), parentFolder = " + this.parentFolder + ", url = " + (this.parentFolder != null ? this.parentFolder.getUrl() : "null")));
                if (this.siblingFolders != null && !this.siblingFolders.isEmpty()) {
                    debugIter = this.siblingFolders.iterator();
                    while (debugIter.hasNext()) {
                        debug = (Folder)debugIter.next();
                        log.debug((Object)("CacheablePageContext(), siblingFolder = " + debug + ", url = " + debug.getUrl()));
                    }
                } else {
                    log.debug((Object)"CacheablePageContext(), siblingFolders = null/empty");
                }
                if (this.rootLinks != null && !this.rootLinks.isEmpty()) {
                    debugIter = this.rootLinks.iterator();
                    while (debugIter.hasNext()) {
                        debug = (Link)debugIter.next();
                        log.debug((Object)("CacheablePageContext(), rootLink = " + debug + ", url = " + debug.getUrl()));
                    }
                } else {
                    log.debug((Object)"CacheablePageContext(), rootLinks = null/empty");
                }
                if (!(this.documentSets == null || this.documentSets.isEmpty() || this.documentSetNames == null || this.documentSetNames.isEmpty() || this.documentSetNodeSets == null || this.documentSetNodeSets.isEmpty())) {
                    debugIter = this.documentSets.iterator();
                    while (debugIter.hasNext()) {
                        log.debug((Object)("CacheablePageContext(), " + this.debugDocumentSetMessage((DocumentSet)debugIter.next())));
                    }
                    if (this.nestedDocumentSets != null && !this.nestedDocumentSets.isEmpty()) {
                        debugIter = this.nestedDocumentSets.iterator();
                        while (debugIter.hasNext()) {
                            log.debug((Object)("CacheablePageContext(), nested " + this.debugDocumentSetMessage((DocumentSet)debugIter.next())));
                        }
                    }
                } else {
                    log.debug((Object)"CacheablePageContext(), documentSets/documentSetNames/documentSetNodeSets = null/empty");
                }
                if (this.profiledFolders != null && !this.profiledFolders.isEmpty()) {
                    debugIter = this.profiledFolders.iterator();
                    while (debugIter.hasNext()) {
                        debug = (Folder)debugIter.next();
                        log.debug((Object)("CacheablePageContext(), profiledFolder = " + debug + ", url = " + debug.getUrl()));
                    }
                } else {
                    log.debug((Object)"CacheablePageContext(), profiledFolders = null/empty");
                }
            }
        }

        private String debugDocumentSetMessage(DocumentSet debug) {
            String debugName = (String)this.documentSetNames.get(debug);
            NodeSet debugNodes = (NodeSet)this.documentSetNodeSets.get(debug);
            String debugMessage = "document set " + debug + ", name = " + debugName + ", nodes = {";
            Iterator nodesIter = debugNodes.iterator();
            if (nodesIter.hasNext()) {
                debugMessage = debugMessage + ((Node)nodesIter.next()).getUrl();
            }
            while (nodesIter.hasNext()) {
                debugMessage = debugMessage + ", " + ((Node)nodesIter.next()).getUrl();
            }
            debugMessage = debugMessage + "}, url = " + debug.getUrl();
            return debugMessage;
        }
    }
}

